/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.EhcacheClientEntity;
import org.ehcache.clustered.client.internal.EhcacheEntityCreationException;
import org.ehcache.clustered.client.internal.EhcacheEntityNotFoundException;
import org.ehcache.clustered.client.internal.EhcacheEntityValidationException;
import org.ehcache.clustered.client.internal.lock.VoltronReadWriteLock;
import org.ehcache.clustered.client.internal.service.ClusteredTierManagerConfigurationException;
import org.ehcache.clustered.client.internal.service.ClusteredTierManagerValidationException;
import org.ehcache.clustered.client.service.EntityBusyException;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.exception.PermanentEntityException;

public class EhcacheClientEntityFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheClientEntityFactory.class);
    private static final long ENTITY_VERSION = 1L;
    private final Connection connection;
    private final Map<String, VoltronReadWriteLock.Hold> maintenanceHolds = new ConcurrentHashMap<String, VoltronReadWriteLock.Hold>();
    private final EhcacheClientEntity.Timeouts entityTimeouts;

    public EhcacheClientEntityFactory(Connection connection) {
        this(connection, EhcacheClientEntity.Timeouts.builder().build());
    }

    public EhcacheClientEntityFactory(Connection connection, EhcacheClientEntity.Timeouts entityTimeouts) {
        this.connection = connection;
        this.entityTimeouts = entityTimeouts;
    }

    public boolean acquireLeadership(String entityIdentifier) {
        VoltronReadWriteLock lock = this.createAccessLockFor(entityIdentifier);
        VoltronReadWriteLock.Hold hold = lock.tryWriteLock();
        if (hold == null) {
            return false;
        }
        this.maintenanceHolds.put(entityIdentifier, hold);
        return true;
    }

    public void abandonLeadership(String entityIdentifier) {
        VoltronReadWriteLock.Hold hold = this.maintenanceHolds.remove(entityIdentifier);
        if (hold == null) {
            throw new IllegalMonitorStateException("Leadership was never held");
        }
        hold.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String identifier, ServerSideConfiguration config) throws EntityAlreadyExistsException, EhcacheEntityCreationException, EntityBusyException, TimeoutException {
        VoltronReadWriteLock.Hold existingMaintenance = this.maintenanceHolds.get(identifier);
        VoltronReadWriteLock.Hold localMaintenance = null;
        if (existingMaintenance == null) {
            localMaintenance = this.createAccessLockFor(identifier).tryWriteLock();
        }
        if (existingMaintenance == null && localMaintenance == null) {
            throw new EntityBusyException("Unable to create clustered tier manager for id " + identifier + ": another client owns the maintenance lease");
        }
        boolean finished = false;
        try {
            EntityRef<EhcacheClientEntity, UUID> ref = this.getEntityRef(identifier);
            while (true) {
                ref.create(UUID.randomUUID());
                EhcacheClientEntity entity = ref.fetchEntity();
                try {
                    entity.setTimeouts(this.entityTimeouts);
                    entity.configure(config);
                    finished = true;
                    if (finished) {
                        entity.close();
                    } else {
                        this.silentlyClose(entity, identifier);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (finished) {
                                entity.close();
                            } else {
                                this.silentlyClose(entity, identifier);
                            }
                            throw throwable;
                        }
                        catch (ClusteredTierManagerConfigurationException e) {
                            try {
                                ref.destroy();
                            }
                            catch (EntityNotFoundException f) {
                                // empty catch block
                            }
                            throw new EhcacheEntityCreationException("Unable to configure clustered tier manager for id " + identifier, e);
                        }
                        catch (EntityNotFoundException e) {
                        }
                    }
                    catch (EntityNotProvidedException e) {
                        LOGGER.error("Unable to create clustered tier manager for id {}", (Object)identifier, (Object)e);
                        throw new AssertionError((Object)e);
                    }
                    catch (EntityVersionMismatchException e) {
                        LOGGER.error("Unable to create clustered tier manager for id {}", (Object)identifier, (Object)e);
                        throw new AssertionError((Object)e);
                    }
                    catch (PermanentEntityException e) {
                        LOGGER.error("Unable to create entity - server indicates it is permanent", (Throwable)e);
                        throw new AssertionError((Object)e);
                    }
                    catch (EntityConfigurationException e) {
                        LOGGER.error("Unable to create entity - configuration exception", (Throwable)e);
                        throw new AssertionError((Object)e);
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            if (localMaintenance != null) {
                if (finished) {
                    localMaintenance.unlock();
                } else {
                    this.silentlyUnlock(localMaintenance, identifier);
                }
            }
        }
    }

    public EhcacheClientEntity retrieve(String identifier, ServerSideConfiguration config) throws EntityNotFoundException, EhcacheEntityValidationException, TimeoutException {
        EhcacheClientEntity entity;
        VoltronReadWriteLock.Hold fetchHold = this.createAccessLockFor(identifier).readLock();
        try {
            entity = this.getEntityRef(identifier).fetchEntity();
        }
        catch (EntityVersionMismatchException e) {
            LOGGER.error("Unable to retrieve clustered tier manager for id {}", (Object)identifier, (Object)e);
            this.silentlyUnlock(fetchHold, identifier);
            throw new AssertionError((Object)e);
        }
        boolean validated = false;
        try {
            entity.setTimeouts(this.entityTimeouts);
            entity.validate(config);
            validated = true;
            EhcacheClientEntity ehcacheClientEntity = entity;
            return ehcacheClientEntity;
        }
        catch (ClusteredTierManagerValidationException e) {
            throw new EhcacheEntityValidationException("Unable to validate clustered tier manager for id " + identifier, e);
        }
        finally {
            if (!validated) {
                this.silentlyClose(entity, identifier);
                this.silentlyUnlock(fetchHold, identifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String identifier) throws EhcacheEntityNotFoundException, EntityBusyException {
        VoltronReadWriteLock.Hold existingMaintenance = this.maintenanceHolds.get(identifier);
        VoltronReadWriteLock.Hold localMaintenance = null;
        if (existingMaintenance == null) {
            localMaintenance = this.createAccessLockFor(identifier).tryWriteLock();
        }
        if (existingMaintenance == null && localMaintenance == null) {
            throw new EntityBusyException("Destroy operation failed; " + identifier + " clustered tier's maintenance lease held");
        }
        boolean finished = false;
        try {
            EntityRef<EhcacheClientEntity, UUID> ref = this.getEntityRef(identifier);
            try {
                if (!ref.destroy()) {
                    throw new EntityBusyException("Destroy operation failed; " + identifier + " clustered tier in use by other clients");
                }
                finished = true;
            }
            catch (EntityNotProvidedException e) {
                LOGGER.error("Unable to delete clustered tier manager for id {}", (Object)identifier, (Object)e);
                throw new AssertionError((Object)e);
            }
            catch (EntityNotFoundException e) {
                throw new EhcacheEntityNotFoundException(e);
            }
            catch (PermanentEntityException e) {
                LOGGER.error("Unable to destroy entity - server says it is permanent", (Throwable)e);
                throw new AssertionError((Object)e);
            }
        }
        finally {
            if (localMaintenance != null) {
                if (finished) {
                    localMaintenance.unlock();
                } else {
                    this.silentlyUnlock(localMaintenance, identifier);
                }
            }
        }
    }

    private void silentlyClose(EhcacheClientEntity entity, String identifier) {
        try {
            entity.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close entity {}", (Object)identifier, (Object)e);
        }
    }

    private void silentlyUnlock(VoltronReadWriteLock.Hold localMaintenance, String identifier) {
        try {
            localMaintenance.unlock();
        }
        catch (Exception e) {
            LOGGER.error("Failed to unlock for id {}", (Object)identifier, (Object)e);
        }
    }

    private VoltronReadWriteLock createAccessLockFor(String entityIdentifier) {
        return new VoltronReadWriteLock(this.connection, "EhcacheClientEntityFactory-AccessLock-" + entityIdentifier);
    }

    private EntityRef<EhcacheClientEntity, UUID> getEntityRef(String identifier) {
        try {
            return this.connection.getEntityRef(EhcacheClientEntity.class, 1L, identifier);
        }
        catch (EntityNotProvidedException e) {
            LOGGER.error("Unable to get clustered tier manager for id {}", (Object)identifier, (Object)e);
            throw new AssertionError((Object)e);
        }
    }
}

