/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.exception.TCNotRunningException;
import com.tc.util.Assert;
import com.tc.util.Util;

public class ClientEntityStateManager {
    private volatile State currentState = State.RUNNING;

    public synchronized void start() {
        this.moveTo(State.STARTING);
    }

    public synchronized void stop() {
        this.moveTo(State.STOPPED);
    }

    public synchronized void running() {
        this.moveTo(State.RUNNING);
    }

    public synchronized void pause() {
        this.moveTo(State.PAUSED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitUntilRunning() {
        boolean isInterrupted = false;
        try {
            while (State.RUNNING != this.currentState) {
                if (State.STOPPED == this.currentState) {
                    throw new TCNotRunningException();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    isInterrupted = true;
                }
            }
        }
        finally {
            Util.selfInterruptIfNeeded(isInterrupted);
        }
    }

    public String getCurrentState() {
        return this.currentState.toString();
    }

    private void moveTo(State newState) {
        this.currentState.check(newState);
        this.currentState = newState;
        this.notifyAll();
    }

    private static enum State {
        PAUSED{

            @Override
            void check(State newState) {
                Assert.assertTrue("Attempt to pause while PAUSED", newState != PAUSED);
            }
        }
        ,
        RUNNING{

            @Override
            void check(State newState) {
                Assert.assertTrue("Attempt to unpause while RUNNING", newState != RUNNING);
                Assert.assertTrue("Attempt to handshake while RUNNING", newState != STARTING);
            }
        }
        ,
        STARTING{

            @Override
            void check(State newState) {
                Assert.assertTrue("Attempt to handshake while STARTING", newState != STARTING);
            }
        }
        ,
        STOPPED{

            @Override
            void check(State newState) {
            }
        };


        abstract void check(State var1);
    }
}

