/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.StageMonitor;
import com.tc.text.StringFormatter;
import java.util.ArrayList;
import java.util.List;

class StageMonitorImpl
implements StageMonitor {
    private final String name;
    private final StringFormatter formatter;
    private final List<Snapshot> snapshots = new ArrayList<Snapshot>();
    private long begin = System.currentTimeMillis();

    StageMonitorImpl(String name, StringFormatter formatter) {
        this.name = formatter.rightPad(30, name);
        this.formatter = formatter;
    }

    @Override
    public synchronized void eventBegin(int queueDepth) {
        this.snapshots.add(new Snapshot(queueDepth));
    }

    @Override
    public synchronized String dumpAndFlush() {
        long elapsed = System.currentTimeMillis() - this.begin;
        StringBuffer rv = new StringBuffer();
        this.dump(elapsed, rv);
        this.flush();
        return rv.toString();
    }

    private StringBuffer dump(long elapsed, StringBuffer buf) {
        StageMonitor.Analysis an = this.analyze();
        buf.append(this.name).append("| period: ").append(this.formatter.leftPad(10, an.getElapsedTime())).append("ms.| events: ").append(this.formatter.leftPad(10, an.getEventCount()));
        buf.append("| events/sec: ").append(this.formatter.leftPad(10, an.getEventsPerSecond()));
        buf.append("| Q depth, min: ").append(this.formatter.leftPad(10, an.getMinQueueDepth()));
        buf.append(", max: ").append(this.formatter.leftPad(10, an.getMaxQueueDepth()));
        buf.append(", avg: ").append(this.formatter.leftPad(10, an.getAvgQueueDepth()));
        return buf;
    }

    private Double safeDiv(long numerator, long denominator) {
        if (denominator > 0L) {
            return new Double((double)numerator / (double)denominator);
        }
        return new Double(-1.0);
    }

    @Override
    public synchronized StageMonitor.Analysis analyze() {
        long elapsed = System.currentTimeMillis() - this.begin;
        int min = -1;
        int max = 0;
        long sum = 0L;
        for (Snapshot snapshot : this.snapshots) {
            int qd = snapshot.getQueueDepth();
            if (qd < min || min < 0) {
                min = qd;
            }
            if (qd > max) {
                max = qd;
            }
            sum += (long)qd;
        }
        return new AnalysisImpl(elapsed, this.snapshots.size(), this.safeDiv(this.snapshots.size() * 1000, elapsed), min, max, this.safeDiv(sum, this.snapshots.size()));
    }

    @Override
    public synchronized void flush() {
        this.snapshots.clear();
        this.begin = System.currentTimeMillis();
    }

    private static class Snapshot {
        private final int queueDepth;

        private Snapshot(int queueDepth) {
            this.queueDepth = queueDepth;
        }

        public int getQueueDepth() {
            return this.queueDepth;
        }
    }

    public static class AnalysisImpl
    implements StageMonitor.Analysis {
        private final Number eventCount;
        private final Number eventsPerSecond;
        private final Number minQueueDepth;
        private final Number maxQueueDepth;
        private final Number avgQueueDepth;
        private final Number elapsedTime;

        private AnalysisImpl(Number elapsedTime, Number eventCount, Number eventsPerSecond, Number minQueueDepth, Number maxQueueDepth, Number avgQueueDepth) {
            this.elapsedTime = elapsedTime;
            this.eventCount = eventCount;
            this.eventsPerSecond = eventsPerSecond;
            this.minQueueDepth = minQueueDepth;
            this.maxQueueDepth = maxQueueDepth;
            this.avgQueueDepth = avgQueueDepth;
        }

        @Override
        public Number getElapsedTime() {
            return this.elapsedTime;
        }

        @Override
        public Number getAvgQueueDepth() {
            return this.avgQueueDepth;
        }

        @Override
        public Number getMaxQueueDepth() {
            return this.maxQueueDepth;
        }

        @Override
        public Number getMinQueueDepth() {
            return this.minQueueDepth;
        }

        @Override
        public Number getEventsPerSecond() {
            return this.eventsPerSecond;
        }

        @Override
        public Number getEventCount() {
            return this.eventCount;
        }
    }
}

