/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.store.operations.codecs;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.store.operations.Operation;
import org.ehcache.clustered.common.internal.store.operations.OperationCode;
import org.ehcache.spi.serialization.Serializer;

public class OperationsCodec<K, V> {
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;

    public OperationsCodec(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public ByteBuffer encode(Operation<K, V> operation) {
        return operation.encode(this.keySerializer, this.valueSerializer);
    }

    public static OperationCode getOperationCode(ByteBuffer buffer) {
        OperationCode opCode = OperationCode.valueOf(buffer.get());
        buffer.rewind();
        return opCode;
    }

    public Operation<K, V> decode(ByteBuffer buffer) {
        OperationCode opCode = OperationsCodec.getOperationCode(buffer);
        return opCode.decode(buffer, this.keySerializer, this.valueSerializer);
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }
}

