/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats.counter.sampled;

import com.tc.stats.counter.sampled.SampledCounterConfig;
import com.tc.stats.counter.sampled.SampledCounterImpl;
import com.tc.stats.counter.sampled.SampledCumulativeCounter;
import java.util.concurrent.atomic.AtomicLong;

public class SampledCumulativeCounterImpl
extends SampledCounterImpl
implements SampledCumulativeCounter {
    private AtomicLong cumulativeCount;

    public SampledCumulativeCounterImpl(SampledCounterConfig config) {
        super(config);
        this.cumulativeCount = new AtomicLong(config.getInitialValue());
    }

    @Override
    public long getCumulativeValue() {
        if (this.resetOnSample) {
            return this.cumulativeCount.get();
        }
        return this.getValue();
    }

    @Override
    public long decrement() {
        this.cumulativeCount.decrementAndGet();
        return super.decrement();
    }

    @Override
    public long decrement(long amount) {
        this.cumulativeCount.addAndGet(amount * -1L);
        return super.decrement(amount);
    }

    @Override
    public long increment() {
        this.cumulativeCount.incrementAndGet();
        return super.increment();
    }

    @Override
    public long increment(long amount) {
        this.cumulativeCount.addAndGet(amount);
        return super.increment(amount);
    }
}

