/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import org.ehcache.clustered.client.service.ClientEntityFactory;
import org.ehcache.clustered.client.service.EntityBusyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;

abstract class AbstractClientEntityFactory<E extends Entity, C>
implements ClientEntityFactory<E, C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClientEntityFactory.class);
    private final String entityIdentifier;
    private final Class<E> entityType;
    private final long entityVersion;
    private final C configuration;

    AbstractClientEntityFactory(String entityIdentifier, Class<E> entityType, long entityVersion, C configuration) {
        this.entityIdentifier = entityIdentifier;
        this.entityType = entityType;
        this.entityVersion = entityVersion;
        this.configuration = configuration;
    }

    @Override
    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getEntityIdentifier() {
        return this.entityIdentifier;
    }

    @Override
    public Class<E> getEntityType() {
        return this.entityType;
    }

    @Override
    public long getEntityVersion() {
        return this.entityVersion;
    }

    @Override
    public void create() throws EntityAlreadyExistsException {
        EntityRef<E, C> ref = this.getEntityRef();
        try {
            while (true) {
                ref.create(this.configuration);
                try {
                    ref.fetchEntity().close();
                    return;
                }
                catch (EntityNotFoundException e) {
                    continue;
                }
                break;
            }
        }
        catch (EntityNotProvidedException e) {
            LOGGER.error("Unable to create entity {} for id {}", new Object[]{this.entityType.getName(), this.entityIdentifier, e});
            throw new AssertionError((Object)e);
        }
        catch (EntityVersionMismatchException e) {
            LOGGER.error("Unable to create entity {} for id {}", new Object[]{this.entityType.getName(), this.entityIdentifier, e});
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public E retrieve() throws EntityNotFoundException {
        try {
            return this.getEntityRef().fetchEntity();
        }
        catch (EntityVersionMismatchException e) {
            LOGGER.error("Unable to retrieve entity {} for id {}", new Object[]{this.entityType.getName(), this.entityIdentifier, e});
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void destroy() throws EntityNotFoundException, EntityBusyException {
        EntityRef<E, C> ref = this.getEntityRef();
        try {
            if (!ref.tryDestroy()) {
                throw new EntityBusyException("Destroy operation failed; " + this.entityIdentifier + " clustered tier in use by other clients");
            }
        }
        catch (EntityNotProvidedException e) {
            LOGGER.error("Unable to destroy entity {} for id {}", new Object[]{this.entityType.getName(), this.entityIdentifier, e});
            throw new AssertionError((Object)e);
        }
    }

    private EntityRef<E, C> getEntityRef() {
        try {
            return this.getConnection().getEntityRef(this.entityType, this.entityVersion, this.entityIdentifier);
        }
        catch (EntityNotProvidedException e) {
            LOGGER.error("Unable to find reference for entity {} for id {}", new Object[]{this.entityType.getName(), this.entityIdentifier, e});
            throw new AssertionError((Object)e);
        }
    }

    protected abstract Connection getConnection();
}

