/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.config.TimeoutDuration;
import org.ehcache.clustered.client.internal.service.ClusteredTierCreationException;
import org.ehcache.clustered.client.internal.service.ClusteredTierDestructionException;
import org.ehcache.clustered.client.internal.service.ClusteredTierManagerConfigurationException;
import org.ehcache.clustered.client.internal.service.ClusteredTierManagerValidationException;
import org.ehcache.clustered.client.internal.service.ClusteredTierReleaseException;
import org.ehcache.clustered.client.internal.service.ClusteredTierValidationException;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ClusteredEhcacheIdentity;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageFactory;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

public class EhcacheClientEntity
implements Entity {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheClientEntity.class);
    private final EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint;
    private final LifeCycleMessageFactory messageFactory;
    private final Map<Class<? extends EhcacheEntityResponse>, List<ResponseListener<? extends EhcacheEntityResponse>>> responseListeners = new ConcurrentHashMap<Class<? extends EhcacheEntityResponse>, List<ResponseListener<? extends EhcacheEntityResponse>>>();
    private final List<DisconnectionListener> disconnectionListeners = new CopyOnWriteArrayList<DisconnectionListener>();
    private volatile boolean connected = true;
    private Timeouts timeouts = Timeouts.builder().build();
    private static final Set<ServerStoreOpMessage.ServerStoreOp> GET_STORE_OPS = EnumSet.of(ServerStoreOpMessage.ServerStoreOp.GET);

    public EhcacheClientEntity(EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint) {
        this.endpoint = endpoint;
        this.messageFactory = new LifeCycleMessageFactory();
        endpoint.setDelegate(new EndpointDelegate(){

            @Override
            public void handleMessage(EntityResponse messageFromServer) {
                if (messageFromServer instanceof EhcacheEntityResponse) {
                    EhcacheClientEntity.this.fireResponseEvent((EhcacheEntityResponse)messageFromServer);
                }
            }

            @Override
            public byte[] createExtendedReconnectData() {
                return new byte[0];
            }

            @Override
            public void didDisconnectUnexpectedly() {
                EhcacheClientEntity.this.fireDisconnectionEvent();
            }
        });
    }

    void fireDisconnectionEvent() {
        this.connected = false;
        for (DisconnectionListener listener : this.disconnectionListeners) {
            listener.onDisconnection();
        }
    }

    void setConnected(boolean connected) {
        this.connected = connected;
    }

    void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    private void fireResponseEvent(EhcacheEntityResponse response) {
        List<ResponseListener<? extends EhcacheEntityResponse>> responseListeners = this.responseListeners.get(response.getClass());
        if (responseListeners == null) {
            return;
        }
        LOGGER.debug("{} registered response listener(s) for {}", (Object)responseListeners.size(), response.getClass());
        for (ResponseListener<? extends EhcacheEntityResponse> responseListener : responseListeners) {
            responseListener.onResponse(response);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void addDisconnectionListener(DisconnectionListener listener) {
        this.disconnectionListeners.add(listener);
    }

    public <T extends EhcacheEntityResponse> void addResponseListener(Class<T> responseType, ResponseListener<T> responseListener) {
        List<ResponseListener<? extends EhcacheEntityResponse>> responseListeners = this.responseListeners.get(responseType);
        if (responseListeners == null) {
            responseListeners = new CopyOnWriteArrayList<ResponseListener<? extends EhcacheEntityResponse>>();
            this.responseListeners.put(responseType, responseListeners);
        }
        responseListeners.add(responseListener);
    }

    public UUID identity() {
        return ClusteredEhcacheIdentity.deserialize(this.endpoint.getEntityConfiguration());
    }

    @Override
    public void close() {
        this.endpoint.close();
    }

    public void validate(ServerSideConfiguration config) throws ClusteredTierManagerValidationException, TimeoutException {
        try {
            this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.validateStoreManager(config), false);
        }
        catch (ClusterException e) {
            throw new ClusteredTierManagerValidationException("Error validating server clustered tier manager", e);
        }
    }

    public void configure(ServerSideConfiguration config) throws ClusteredTierManagerConfigurationException, TimeoutException {
        try {
            this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.configureStoreManager(config), true);
        }
        catch (ClusterException e) {
            throw new ClusteredTierManagerConfigurationException("Error configuring clustered tier manager", e);
        }
    }

    public void createCache(String name, ServerStoreConfiguration serverStoreConfiguration) throws ClusteredTierCreationException, TimeoutException {
        try {
            this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.createServerStore(name, serverStoreConfiguration), true);
        }
        catch (ClusterException e) {
            throw new ClusteredTierCreationException("Error creating clustered tier '" + name + "'", e);
        }
    }

    public void validateCache(String name, ServerStoreConfiguration serverStoreConfiguration) throws ClusteredTierValidationException, TimeoutException {
        try {
            this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.validateServerStore(name, serverStoreConfiguration), false);
        }
        catch (ClusterException e) {
            throw new ClusteredTierValidationException("Error validating clustered tier '" + name + "'", e);
        }
    }

    public void releaseCache(String name) throws ClusteredTierReleaseException, TimeoutException {
        try {
            this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.releaseServerStore(name), false);
        }
        catch (ClusterException e) {
            throw new ClusteredTierReleaseException("Error releasing clustered tier '" + name + "'", e);
        }
    }

    public void destroyCache(String name) throws ClusteredTierDestructionException, TimeoutException {
        try {
            this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.destroyServerStore(name), true);
        }
        catch (ClusterException e) {
            throw new ClusteredTierDestructionException("Error destroying clustered tier '" + name + "'", e);
        }
    }

    public EhcacheEntityResponse invoke(EhcacheEntityMessage message, boolean replicate) throws ClusterException, TimeoutException {
        TimeoutDuration timeLimit = message.getType() == EhcacheEntityMessage.Type.SERVER_STORE_OP && GET_STORE_OPS.contains((Object)ServerStoreOpMessage.ServerStoreOp.getServerStoreOp(message.getOpCode())) ? this.timeouts.getReadOperationTimeout() : this.timeouts.getMutativeOperationTimeout();
        return this.invokeInternal(timeLimit, message, replicate);
    }

    private EhcacheEntityResponse invokeInternal(TimeoutDuration timeLimit, EhcacheEntityMessage message, boolean replicate) throws ClusterException, TimeoutException {
        try {
            EhcacheEntityResponse response = EhcacheClientEntity.waitFor(timeLimit, this.invokeAsync(message, replicate));
            if (EhcacheEntityResponse.Type.FAILURE.equals((Object)response.getType())) {
                throw ((EhcacheEntityResponse.Failure)response).getCause();
            }
            return response;
        }
        catch (EntityException e) {
            throw new RuntimeException(message + " error: " + e.toString(), e);
        }
        catch (MessageCodecException e) {
            throw new RuntimeException(message + " error: " + e.toString(), e);
        }
        catch (TimeoutException e) {
            String msg = "Timeout exceeded for " + this.getMessageOp(message) + " message; " + timeLimit;
            TimeoutException timeoutException = new TimeoutException(msg);
            timeoutException.initCause(e);
            LOGGER.info(msg, (Throwable)timeoutException);
            throw timeoutException;
        }
    }

    public InvokeFuture<EhcacheEntityResponse> invokeAsync(EhcacheEntityMessage message, boolean replicate) throws MessageCodecException {
        if (replicate) {
            return this.endpoint.beginInvoke().message(message).replicate(true).invoke();
        }
        return this.endpoint.beginInvoke().message(message).invoke();
    }

    private static <T> T waitFor(TimeoutDuration timeLimit, InvokeFuture<T> future) throws EntityException, TimeoutException {
        boolean interrupted = false;
        long deadlineTimeout = System.nanoTime() + timeLimit.toNanos();
        while (true) {
            try {
                long timeRemaining = deadlineTimeout - System.nanoTime();
                T t = future.getWithTimeout(timeRemaining, TimeUnit.NANOSECONDS);
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private String getMessageOp(EhcacheEntityMessage message) {
        switch (message.getType()) {
            case SERVER_STORE_OP: {
                try {
                    return (Object)((Object)message.getType()) + "/" + (Object)((Object)ServerStoreOpMessage.ServerStoreOp.getServerStoreOp(message.getOpCode()));
                }
                catch (IllegalArgumentException e) {
                    return (Object)((Object)message.getType()) + "/" + message.getOpCode();
                }
            }
            case LIFECYCLE_OP: {
                try {
                    return (Object)((Object)message.getType()) + "/" + (Object)((Object)((LifecycleMessage)message).operation());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return (Object)((Object)message.getType()) + "/" + message.getOpCode();
                }
            }
        }
        return (Object)((Object)message.getType()) + "/" + message.getOpCode();
    }

    public static final class Timeouts {
        private final TimeoutDuration readOperationTimeout;
        private final TimeoutDuration mutativeOperationTimeout;
        private final TimeoutDuration lifecycleOperationTimeout;

        private Timeouts(TimeoutDuration readOperationTimeout, TimeoutDuration mutativeOperationTimeout, TimeoutDuration lifecycleOperationTimeout) {
            this.readOperationTimeout = readOperationTimeout;
            this.mutativeOperationTimeout = mutativeOperationTimeout;
            this.lifecycleOperationTimeout = lifecycleOperationTimeout;
        }

        public TimeoutDuration getReadOperationTimeout() {
            return this.readOperationTimeout;
        }

        public TimeoutDuration getMutativeOperationTimeout() {
            return this.mutativeOperationTimeout;
        }

        public TimeoutDuration getLifecycleOperationTimeout() {
            return this.lifecycleOperationTimeout;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String toString() {
            return "Timeouts{readOperationTimeout=" + this.readOperationTimeout + ", mutativeOperationTimeout=" + this.mutativeOperationTimeout + ", lifecycleOperationTimeout=" + this.lifecycleOperationTimeout + '}';
        }

        public static final class Builder {
            private TimeoutDuration readOperationTimeout = TimeoutDuration.of(5L, TimeUnit.SECONDS);
            private TimeoutDuration mutativeOperationTimeout = TimeoutDuration.of(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            private TimeoutDuration lifecycleOperationTimeout = TimeoutDuration.of(10L, TimeUnit.SECONDS);

            public Builder setReadOperationTimeout(TimeoutDuration readOperationTimeout) {
                if (readOperationTimeout == null) {
                    throw new NullPointerException("readOperationTimeout");
                }
                this.readOperationTimeout = readOperationTimeout;
                return this;
            }

            public Builder setMutativeOperationTimeout(TimeoutDuration mutativeOperationTimeout) {
                if (mutativeOperationTimeout == null) {
                    throw new NullPointerException("mutativeOperationTimeout");
                }
                this.mutativeOperationTimeout = mutativeOperationTimeout;
                return this;
            }

            public Builder setLifecycleOperationTimeout(TimeoutDuration lifecycleOperationTimeout) {
                if (lifecycleOperationTimeout == null) {
                    throw new NullPointerException("lifecycleOperationTimeout");
                }
                this.lifecycleOperationTimeout = lifecycleOperationTimeout;
                return this;
            }

            public Timeouts build() {
                return new Timeouts(this.readOperationTimeout, this.mutativeOperationTimeout, this.lifecycleOperationTimeout);
            }
        }
    }

    public static interface DisconnectionListener {
        public void onDisconnection();
    }

    public static interface ResponseListener<T extends EhcacheEntityResponse> {
        public void onResponse(T var1);
    }
}

