/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.entity;

import com.tc.entity.VoltronEntityMessage;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.ExceptionUtils;
import com.tc.util.Assert;
import com.tc.util.Util;
import com.terracotta.connection.entity.MaintenanceModeService;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;

public class TerracottaEntityRef<T extends Entity, C>
implements EntityRef<T, C> {
    private final TCLogger logger = TCLogging.getLogger(TerracottaEntityRef.class);
    private final ClientEntityManager entityManager;
    private final MaintenanceModeService maintenanceModeService;
    private final Class<T> type;
    private final long version;
    private final String name;
    private final EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse> entityClientService;
    private final AtomicLong nextClientInstanceID;

    public TerracottaEntityRef(ClientEntityManager entityManager, MaintenanceModeService maintenanceModeService, Class<T> type, long version, String name, EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse> entityClientService, AtomicLong clientIds) {
        this.entityManager = entityManager;
        this.maintenanceModeService = maintenanceModeService;
        this.type = type;
        this.version = version;
        this.name = name;
        this.entityClientService = entityClientService;
        this.nextClientInstanceID = clientIds;
    }

    @Override
    public synchronized T fetchEntity() throws EntityNotFoundException, EntityVersionMismatchException {
        this.maintenanceModeService.readLockEntity(this.type, this.name);
        Runnable closeHook = new Runnable(){

            @Override
            public void run() {
                TerracottaEntityRef.this.maintenanceModeService.readUnlockEntity(TerracottaEntityRef.this.type, TerracottaEntityRef.this.name);
            }
        };
        EntityClientEndpoint endpoint = null;
        try {
            ClientInstanceID clientInstanceID = new ClientInstanceID(this.nextClientInstanceID.getAndIncrement());
            EntityDescriptor entityDescriptor = new EntityDescriptor(this.getEntityID(), clientInstanceID, this.version);
            endpoint = this.entityManager.fetchEntity(entityDescriptor, this.entityClientService.getMessageCodec(), closeHook);
        }
        catch (EntityException e) {
            closeHook.run();
            e = ExceptionUtils.addLocalStackTraceToEntityException(e);
            if (e instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e;
            }
            if (e instanceof EntityVersionMismatchException) {
                throw (EntityVersionMismatchException)e;
            }
            throw Assert.failure("Unsupported exception type returned to fetch", e);
        }
        catch (Throwable t) {
            closeHook.run();
            Util.printLogAndRethrowError(t, this.logger);
        }
        if (endpoint == null) {
            Assert.assertNotNull(endpoint);
        }
        return this.entityClientService.create(endpoint);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private EntityID getEntityID() {
        return new EntityID(this.type.getName(), this.name);
    }

    @Override
    public void create(C configuration) throws EntityNotProvidedException, EntityAlreadyExistsException, EntityVersionMismatchException {
        EntityID entityID = this.getEntityID();
        boolean didEnter = this.maintenanceModeService.tryEnterMaintenanceMode(this.type, this.name);
        if (didEnter) {
            try {
                this.entityManager.createEntity(entityID, this.version, Collections.singleton(VoltronEntityMessage.Acks.APPLIED), this.entityClientService.serializeConfiguration(configuration)).get();
            }
            catch (EntityException e) {
                e = ExceptionUtils.addLocalStackTraceToEntityException(e);
                if (e instanceof EntityNotProvidedException) {
                    throw (EntityNotProvidedException)e;
                }
                if (e instanceof EntityAlreadyExistsException) {
                    throw (EntityAlreadyExistsException)e;
                }
                if (e instanceof EntityVersionMismatchException) {
                    throw (EntityVersionMismatchException)e;
                }
                throw Assert.failure("Unsupported exception type returned to create", e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.maintenanceModeService.exitMaintenanceMode(this.type, this.name);
            }
        } else {
            throw new EntityAlreadyExistsException(entityID.getClassName(), entityID.getEntityName());
        }
    }

    @Override
    public C reconfigure(C configuration) throws EntityException {
        EntityID entityID = this.getEntityID();
        try {
            return this.entityClientService.deserializeConfiguration(this.entityManager.reconfigureEntity(entityID, this.version, Collections.singleton(VoltronEntityMessage.Acks.APPLIED), this.entityClientService.serializeConfiguration(configuration)).get());
        }
        catch (EntityException e) {
            throw ExceptionUtils.addLocalStackTraceToEntityException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws EntityNotFoundException {
        this.maintenanceModeService.enterMaintenanceMode(this.type, this.name);
        try {
            this.destroyLockedEntity();
        }
        finally {
            this.maintenanceModeService.exitMaintenanceMode(this.type, this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryDestroy() throws EntityNotFoundException {
        boolean didEnter = this.maintenanceModeService.tryEnterMaintenanceMode(this.type, this.name);
        if (didEnter) {
            try {
                this.destroyLockedEntity();
            }
            finally {
                this.maintenanceModeService.exitMaintenanceMode(this.type, this.name);
            }
        }
        return didEnter;
    }

    private void destroyLockedEntity() throws EntityNotFoundException {
        EntityID entityID = this.getEntityID();
        InvokeFuture<byte[]> future = this.entityManager.destroyEntity(entityID, this.version, Collections.<VoltronEntityMessage.Acks>emptySet());
        boolean interrupted = false;
        while (true) {
            try {
                future.get();
            }
            catch (EntityException e) {
                e = ExceptionUtils.addLocalStackTraceToEntityException(e);
                if (e instanceof EntityNotFoundException) {
                    throw (EntityNotFoundException)e;
                }
                Assert.failure("Unsupported exception type returned to destroy", e);
                continue;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        Util.selfInterruptIfNeeded(interrupted);
    }
}

