/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import com.tc.properties.TCPropertiesImpl;
import com.tc.util.concurrent.ScheduledNamedTaskRunner;
import com.tc.util.concurrent.TaskRunner;
import java.util.concurrent.TimeUnit;

public final class Runners {
    private Runners() {
    }

    public static TaskRunner newDefaultCachedScheduledTaskRunner() {
        return Runners.newDefaultCachedScheduledTaskRunner(null);
    }

    public static TaskRunner newDefaultCachedScheduledTaskRunner(ThreadGroup threadGroup) {
        ScheduledNamedTaskRunner runner = new ScheduledNamedTaskRunner(TCPropertiesImpl.getProperties().getInt("default.taskrunner.core.pool.size", 16), threadGroup);
        runner.setKeepAliveTime(2L, TimeUnit.MINUTES);
        runner.allowCoreThreadTimeOut(true);
        return runner;
    }

    public static TaskRunner newScheduledTaskRunner(int poolSize) {
        return Runners.newScheduledTaskRunner(poolSize, null);
    }

    public static TaskRunner newScheduledTaskRunner(int poolSize, ThreadGroup threadGroup) {
        if (poolSize <= 0) {
            throw new IllegalArgumentException("poolSize should be a positive integer");
        }
        return new ScheduledNamedTaskRunner(poolSize, threadGroup);
    }

    public static TaskRunner newSingleThreadScheduledTaskRunner() {
        return Runners.newScheduledTaskRunner(1);
    }

    public static TaskRunner newSingleThreadScheduledTaskRunner(ThreadGroup threadGroup) {
        return Runners.newScheduledTaskRunner(1, threadGroup);
    }
}

