/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import java.util.Arrays;

public class StringUtil {
    public static final char SPACE = ' ';
    public static final String SPACE_STRING = " ";
    public static final String EMPTY = "";
    public static final String NULL_STRING = "<null>";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static final String safeToString(Object object) {
        return object != null ? object.toString() : NULL_STRING;
    }

    public static String indentLines(String source) {
        return StringUtil.indentLines(source, 1);
    }

    public static String indentLines(String source, int indentLevel) {
        return StringUtil.indentLines(new StringBuffer(source), indentLevel).toString();
    }

    public static StringBuffer indentLines(StringBuffer source, int indentLevel) {
        return StringUtil.indentLines(source, indentLevel, '\t');
    }

    public static StringBuffer indentLines(StringBuffer source, int indentLevel, char indentChar) {
        String indentStr;
        if (source == null || indentLevel == 0) {
            return source;
        }
        if (indentLevel <= 0) {
            throw new IllegalArgumentException("Negative indentation not supported");
        }
        if (indentLevel > 1) {
            char[] chars = new char[indentLevel];
            Arrays.fill(chars, indentChar);
            indentStr = new String(chars);
        } else {
            indentStr = new String(new char[]{indentChar});
        }
        source.insert(0, indentStr);
        int index = 0;
        while ((index = StringUtil.indexOfStringBuffer(source, "\n", index)) != -1 && ++index != source.length()) {
            source.insert(index, indentStr);
        }
        return source;
    }

    public static int indexOfStringBuffer(StringBuffer source, String search, int start) {
        return source.toString().indexOf(search, start);
    }

    public static final String toString(Object[] objs, String separator, String prefix, String postfix) {
        String sep = StringUtil.getNonNull(separator);
        String pre = StringUtil.getNonNull(prefix);
        String post = StringUtil.getNonNull(postfix);
        StringBuffer rv = new StringBuffer();
        if (objs != null) {
            for (int pos = 0; pos < objs.length; ++pos) {
                if (rv.length() > 0) {
                    rv.append(sep);
                }
                rv.append(pre);
                rv.append(objs[pos] != null ? objs[pos].toString() : "null");
                rv.append(post);
            }
        } else {
            rv.append(NULL_STRING);
        }
        return rv.toString();
    }

    public static final String toString(Object[] objs) {
        return StringUtil.toString(objs, ", ", null, null);
    }

    public static final String toPaddedString(long value, int radix, int paddedWidth) {
        StringBuffer result = new StringBuffer();
        String strValue = Long.toString(value, radix);
        for (int pos = 0; pos < paddedWidth - strValue.length(); ++pos) {
            result.append("0");
        }
        result.append(strValue);
        return result.toString();
    }

    public static final String replaceAll(String source, String search, String replace, boolean skipQuotedStrings) {
        if (source == null || search == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int beginQuoteIdx = 0;
        for (int pos = 0; pos < source.length(); ++pos) {
            if (skipQuotedStrings && source.startsWith("'", pos)) {
                beginQuoteIdx = pos++;
                while (pos < source.length() && !source.startsWith("'", pos)) {
                    ++pos;
                }
                result.append(source.substring(beginQuoteIdx, pos + 1));
                continue;
            }
            if (skipQuotedStrings && source.startsWith("\"", pos)) {
                beginQuoteIdx = pos++;
                while (pos < source.length() && !source.startsWith("\"", pos)) {
                    ++pos;
                }
                result.append(source.substring(beginQuoteIdx, pos + 1));
                continue;
            }
            if (source.startsWith(search, pos)) {
                if (replace != null) {
                    result.append(replace);
                }
                pos += search.length() - 1;
                continue;
            }
            result.append(source.charAt(pos));
        }
        return result.toString();
    }

    public static final String reduce(String source) {
        if (null == source) {
            return null;
        }
        char[] chars = new char[source.length()];
        source.getChars(0, source.length(), chars, 0);
        return new String(chars);
    }

    public static final String getNonNull(String s, String nullToken) {
        return s == null ? nullToken : s;
    }

    public static final String getNonNull(String s) {
        return StringUtil.getNonNull(s, EMPTY);
    }
}

