/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.io.TCFile;
import com.tc.util.AbstractStartupLock;
import com.tc.util.TCDataFileLockingException;
import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;

public class NonBlockingStartupLock
extends AbstractStartupLock {
    public NonBlockingStartupLock(TCFile location, boolean retries) {
        super(location, retries);
    }

    @Override
    protected void requestLock(TCFile tcFile) {
        try {
            this.lock = this.channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException ioe) {
            throw new TCDataFileLockingException("Unable to acquire file lock on '" + tcFile.getFile().getAbsolutePath() + "'.  Aborting Terracotta server instance startup.");
        }
    }

    @Override
    public boolean isBlocked() {
        return false;
    }
}

