/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.exception.TCLockUpgradeNotSupportedError;
import com.tc.exception.TCNotRunningException;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.object.locks.ClientGreediness;
import com.tc.object.locks.ClientLock;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.GarbageLockException;
import com.tc.object.locks.LockFlushCallback;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockLevel;
import com.tc.object.locks.LockStateNode;
import com.tc.object.locks.RemoteLockManager;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.object.locks.WaitListener;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.util.Assert;
import com.tc.util.FindbugsSuppressWarnings;
import com.tc.util.SinglyLinkedList;
import com.tc.util.SynchronizedSinglyLinkedList;
import com.tc.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;

class ClientLockImpl
extends SynchronizedSinglyLinkedList<LockStateNode>
implements ClientLock {
    private static long NULL_AWARD_ID = -1L;
    private static final TCLogger LOGGER = TCLogging.getLogger(ClientLockImpl.class);
    private static final Set<LockLevel> WRITE_LEVELS = EnumSet.of(LockLevel.WRITE, LockLevel.SYNCHRONOUS_WRITE);
    private static final Set<LockLevel> READ_LEVELS = EnumSet.of(LockLevel.READ);
    private static final int BLOCKING_LOCK = Integer.MIN_VALUE;
    private final LockID lock;
    @FindbugsSuppressWarnings(value={"IS2_INCONSISTENT_SYNC"})
    private ClientGreediness greediness = ClientGreediness.FREE;
    private volatile byte gcCycleCount = 0;
    private int pinned = 0;
    private long awardId = NULL_AWARD_ID;

    public ClientLockImpl(LockID lock) {
        this.lock = lock;
    }

    @Override
    public synchronized void cleanup() {
        this.notifyAll();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            LockStateNode lockState = (LockStateNode)it.next();
            this.removeAndUnpark(lockState, it);
        }
        this.greediness = ClientGreediness.FREE;
        this.pinned = 0;
        this.setAwardID(NULL_AWARD_ID);
    }

    private void removeAndUnpark(LockStateNode lockState, Iterator<LockStateNode> it) {
        try {
            it.remove();
            lockState.unpark();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Override
    public void lock(RemoteLockManager remote, ThreadID thread, LockLevel level) throws GarbageLockException {
        this.markUsed();
        if (!this.tryAcquireLocally(remote, thread, level).isSuccess()) {
            this.acquireQueued(remote, thread, level);
        }
    }

    @Override
    public void lockInterruptibly(RemoteLockManager remote, ThreadID thread, LockLevel level) throws InterruptedException, GarbageLockException {
        this.markUsed();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryAcquireLocally(remote, thread, level).isSuccess()) {
            this.acquireQueuedInterruptibly(remote, thread, level);
        }
    }

    @Override
    public boolean tryLock(RemoteLockManager remote, ThreadID thread, LockLevel level) throws GarbageLockException {
        this.markUsed();
        LockAcquireResult result = this.tryAcquireLocally(remote, thread, level);
        if (result.isKnownResult()) {
            return result.isSuccess();
        }
        try {
            return this.acquireQueuedTimeout(remote, thread, level, 0L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean tryLock(RemoteLockManager remote, ThreadID thread, LockLevel level, long timeout) throws InterruptedException, GarbageLockException {
        this.markUsed();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquireLocally(remote, thread, level).isSuccess() || this.acquireQueuedTimeout(remote, thread, level, timeout);
    }

    @Override
    public void unlock(RemoteLockManager remote, ThreadID thread, LockLevel level) {
        this.markUsed();
        if (this.release(remote, thread, level)) {
            this.unparkFirstQueuedAcquire();
        }
    }

    @Override
    public boolean notify(RemoteLockManager remote, ThreadID thread, Object waitObject) {
        this.markUsed();
        return this.notify(thread, false);
    }

    @Override
    public boolean notifyAll(RemoteLockManager remote, ThreadID thread, Object waitObject) {
        this.markUsed();
        return this.notify(thread, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notify(ThreadID thread, boolean all) {
        boolean result;
        ArrayList<LockStateNode.LockWaiter> waiters = new ArrayList<LockStateNode.LockWaiter>();
        ClientLockImpl clientLockImpl = this;
        synchronized (clientLockImpl) {
            if (!this.isLockedBy(thread, WRITE_LEVELS)) {
                throw new IllegalMonitorStateException();
            }
            if (this.greediness.isFree()) {
                result = true;
            } else {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    LockStateNode s = (LockStateNode)it.next();
                    if (!(s instanceof LockStateNode.LockWaiter)) continue;
                    it.remove();
                    waiters.add((LockStateNode.LockWaiter)s);
                    this.addPendingAcquires((LockStateNode.LockWaiter)s);
                    if (all) continue;
                    result = false;
                    break;
                }
                result = true;
            }
        }
        for (LockStateNode.LockWaiter waiter : waiters) {
            waiter.unpark();
        }
        return result;
    }

    @Override
    public void wait(RemoteLockManager remote, WaitListener listener, ThreadID thread, Object waitObject) throws InterruptedException {
        this.wait(remote, listener, thread, waitObject, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wait(RemoteLockManager remote, WaitListener listener, ThreadID thread, Object waitObject, long timeout) throws InterruptedException {
        this.markUsed();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.isLockedBy(thread, WRITE_LEVELS)) {
            throw new IllegalMonitorStateException();
        }
        LockStateNode.LockWaiter waiter = null;
        try {
            boolean flush;
            ClientLockImpl clientLockImpl = this;
            synchronized (clientLockImpl) {
                flush = this.flushOnUnlockAll(thread);
                if (!flush) {
                    waiter = this.releaseAllAndPushWaiter(remote, thread, waitObject, timeout);
                }
            }
            if (flush) {
                while (true) {
                    ServerLockLevel flushLevel;
                    ClientLockImpl clientLockImpl2 = this;
                    synchronized (clientLockImpl2) {
                        flushLevel = this.greediness.getFlushLevel();
                    }
                    remote.flush(this.lock);
                    clientLockImpl2 = this;
                    synchronized (clientLockImpl2) {
                        if (flushLevel.equals((Object)this.greediness.getFlushLevel())) {
                            waiter = this.releaseAllAndPushWaiter(remote, thread, waitObject, timeout);
                            break;
                        }
                        LOGGER.info("Retrying flush on " + this.lock + " as flush level moved from " + (Object)((Object)flushLevel) + " to " + (Object)((Object)this.greediness.getFlushLevel()) + " during flush operation");
                    }
                }
            }
            this.unparkFirstQueuedAcquire();
            this.waitOnLockWaiter(remote, thread, waiter, listener);
            if (waiter != null) {
                this.moveWaiterToPending(waiter);
                this.acquireAll(remote, thread, waiter.getReacquires());
            } else if (!this.isLockedBy(thread, WRITE_LEVELS)) {
                LOGGER.fatal("Potential lock reacquire failure after wait by " + thread + " in:\n" + this);
            }
        }
        catch (Throwable throwable) {
            if (waiter != null) {
                this.moveWaiterToPending(waiter);
                this.acquireAll(remote, thread, waiter.getReacquires());
            } else if (!this.isLockedBy(thread, WRITE_LEVELS)) {
                LOGGER.fatal("Potential lock reacquire failure after wait by " + thread + " in:\n" + this);
            }
            throw throwable;
        }
    }

    protected synchronized void resetPinIfNecessary() {
        if (this.noLocksHeld(null, null)) {
            this.pinned = 0;
            this.setAwardID(NULL_AWARD_ID);
        }
    }

    private synchronized LockStateNode.LockWaiter releaseAllAndPushWaiter(RemoteLockManager remote, ThreadID thread, Object waitObject, long timeout) {
        Stack<LockStateNode.LockHold> holds = this.releaseAll(remote, thread);
        LockStateNode.LockWaiter waiter = new LockStateNode.LockWaiter(thread, waitObject, holds, timeout);
        this.addLast(waiter);
        if (this.greediness.isFree()) {
            remote.wait(this.lock, thread, timeout);
        } else if (this.greediness.isRecalled() && this.canRecallNow()) {
            this.greediness = this.recallCommit(remote, false);
        }
        return waiter;
    }

    private synchronized Stack<LockStateNode.LockHold> releaseAll(RemoteLockManager remote, ThreadID thread) {
        Stack<LockStateNode.LockHold> holds = new Stack<LockStateNode.LockHold>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            LockStateNode node = (LockStateNode)it.next();
            if (!(node instanceof LockStateNode.LockHold) || !node.getOwner().equals(thread)) continue;
            it.remove();
            holds.push((LockStateNode.LockHold)node);
        }
        return holds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnLockWaiter(RemoteLockManager remote, ThreadID thread, LockStateNode.LockWaiter waiter, WaitListener listener) throws InterruptedException {
        listener.handleWaitEvent();
        try {
            if (waiter.getTimeout() == 0L) {
                waiter.park();
            } else {
                waiter.park(waiter.getTimeout());
            }
        }
        catch (InterruptedException e) {
            ClientLockImpl clientLockImpl = this;
            synchronized (clientLockImpl) {
                if (this.greediness.isFree()) {
                    remote.interrupt(this.lock, thread);
                }
                this.moveWaiterToPending(waiter);
            }
            throw e;
        }
    }

    private void acquireAll(RemoteLockManager remote, ThreadID thread, Stack<LockStateNode.PendingLockHold> acquires) {
        Stack<LockStateNode.PendingLockHold> acquiresClone = ClientLockImpl.copyStack(acquires);
        while (!acquires.isEmpty()) {
            LockStateNode.PendingLockHold qa = acquires.pop();
            try {
                this.acquireQueued(remote, thread, qa.getLockLevel(), qa);
            }
            catch (GarbageLockException e) {
                throw new AssertionError((Object)"GarbageLockException thrown while reacquiring locks after wait");
            }
        }
    }

    private static <T> Stack<T> copyStack(Stack<T> toCopy) {
        Stack<T> newStack = new Stack<T>();
        newStack.addAll(toCopy);
        return newStack;
    }

    @Override
    public synchronized Collection<ClientServerExchangeLockContext> getStateSnapshot(ClientID client) {
        ArrayList<ClientServerExchangeLockContext> contexts = new ArrayList<ClientServerExchangeLockContext>();
        switch (this.greediness) {
            case GARBAGE: {
                break;
            }
            default: {
                ClientServerExchangeLockContext c = this.greediness.toContext(this.lock, client);
                if (c == null) break;
                contexts.add(c);
            }
        }
        for (LockStateNode s : this) {
            ClientServerExchangeLockContext c = s.toContext(this.lock, client);
            if (c == null) continue;
            contexts.add(c);
        }
        return contexts;
    }

    @Override
    public synchronized int pendingCount() {
        int penders = 0;
        for (LockStateNode s : this) {
            if (!(s instanceof LockStateNode.PendingLockHold)) continue;
            ++penders;
        }
        return penders;
    }

    @Override
    public synchronized int waitingCount() {
        int waiters = 0;
        for (LockStateNode s : this) {
            if (!(s instanceof LockStateNode.LockWaiter)) continue;
            ++waiters;
        }
        return waiters;
    }

    @Override
    public synchronized boolean isLocked(LockLevel level) {
        for (LockStateNode s : this) {
            if (!(s instanceof LockStateNode.LockHold) || !((LockStateNode.LockHold)s).getLockLevel().equals((Object)level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isLockedBy(ThreadID thread, LockLevel level) {
        for (LockStateNode s : this) {
            if (!(s instanceof LockStateNode.LockHold) || !((LockStateNode.LockHold)s).getLockLevel().equals((Object)level) && level != null || !s.getOwner().equals(thread)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isLockedBy(ThreadID thread, Set<LockLevel> levels) {
        for (LockStateNode s : this) {
            if (!(s instanceof LockStateNode.LockHold) || !s.getOwner().equals(thread) || !levels.contains((Object)((LockStateNode.LockHold)s).getLockLevel())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized int holdCount(LockLevel level) {
        int holders = 0;
        for (LockStateNode s : this) {
            if (s instanceof LockStateNode.LockHold && ((LockStateNode.LockHold)s).getLockLevel().equals((Object)level)) {
                ++holders;
                continue;
            }
            if (!(s instanceof LockStateNode.LockWaiter) && !(s instanceof LockStateNode.PendingLockHold)) continue;
            break;
        }
        return holders;
    }

    @Override
    public synchronized void pinLock(long awardID) {
        if (this.isAwardValid(awardID)) {
            ++this.pinned;
        }
    }

    @Override
    public synchronized void unpinLock(long awardID) {
        if (this.isAwardValid(awardID)) {
            if (this.pinned == 0) {
                Assert.fail();
            }
            --this.pinned;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notified(ThreadID thread) {
        LockStateNode.LockWaiter waiter = null;
        ClientLockImpl clientLockImpl = this;
        synchronized (clientLockImpl) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                LockStateNode s = (LockStateNode)it.next();
                if (!(s instanceof LockStateNode.LockWaiter) || !s.getOwner().equals(thread)) continue;
                it.remove();
                waiter = (LockStateNode.LockWaiter)s;
                this.addPendingAcquires(waiter);
                break;
            }
        }
        if (waiter != null) {
            waiter.unpark();
        }
    }

    private synchronized void moveWaiterToPending(LockStateNode.LockWaiter waiter) {
        if (waiter != null && this.remove(waiter) != null) {
            this.addPendingAcquires(waiter);
        }
    }

    private synchronized void addPendingAcquires(LockStateNode.LockWaiter waiter) {
        Stack<LockStateNode.PendingLockHold> reacquires = waiter.getReacquires();
        ListIterator it = reacquires.listIterator(reacquires.size());
        while (it.hasPrevious()) {
            this.addLast((SinglyLinkedList.LinkedNode)it.previous());
        }
    }

    @Override
    public synchronized boolean recall(RemoteLockManager remote, ServerLockLevel interest, int lease, boolean batch) {
        this.greediness = this.greediness.recalled(this, lease, interest);
        if (this.greediness.isRecalled()) {
            this.greediness = this.doRecall(remote, batch);
            return false;
        }
        return this.greediness.isGreedy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refuse(ThreadID thread, ServerLockLevel level) {
        LockStateNode.PendingLockHold acquire;
        ClientLockImpl clientLockImpl = this;
        synchronized (clientLockImpl) {
            acquire = this.getQueuedAcquire(thread, level);
            if (acquire != null) {
                acquire.refused();
            }
        }
        if (acquire != null) {
            acquire.unpark();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void award(RemoteLockManager remote, ThreadID thread, ServerLockLevel level, long lockAwardID) throws GarbageLockException {
        if (ThreadID.VM_ID.equals(thread)) {
            ClientLockImpl clientLockImpl = this;
            synchronized (clientLockImpl) {
                this.setAwardID(lockAwardID);
                this.greediness = this.greediness.awarded(level);
            }
            this.unparkFirstQueuedAcquire();
        } else {
            LockStateNode.PendingLockHold acquire;
            ClientLockImpl clientLockImpl = this;
            synchronized (clientLockImpl) {
                this.setAwardID(lockAwardID);
                acquire = this.getQueuedAcquire(thread, level);
                if (acquire == null) {
                    this.resetPinIfNecessary();
                    remote.unlock(this.lock, thread, level);
                } else {
                    acquire.awarded();
                }
            }
            if (acquire != null) {
                acquire.unpark();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockAcquireResult tryAcquire(RemoteLockManager remote, ThreadID thread, LockLevel level, long timeout, LockStateNode.PendingLockHold node) throws GarbageLockException {
        LockAcquireResult result = this.tryAcquireLocally(remote, thread, level);
        if (result.isKnownResult()) {
            return result;
        }
        ClientLockImpl clientLockImpl = this;
        synchronized (clientLockImpl) {
            if (!node.canDelegate()) {
                return result;
            }
            ServerLockLevel requestLevel = ServerLockLevel.fromClientLockLevel(level);
            this.greediness = this.greediness.requested(requestLevel);
            if (this.greediness.isFree()) {
                switch ((int)timeout) {
                    case -2147483648: {
                        remote.lock(this.lock, thread, requestLevel);
                        node.delegated("Called remote.lock(...)...");
                        break;
                    }
                    default: {
                        remote.tryLock(this.lock, thread, requestLevel, timeout);
                        node.delegated("Called remote.tryLock(...)...");
                    }
                }
                return LockAcquireResult.USED_SERVER;
            }
            if (!this.greediness.isRecalled()) {
                node.delegated("Waiting For Recall...");
                return LockAcquireResult.USED_SERVER;
            }
        }
        while (true) {
            ServerLockLevel flushLevel;
            ClientLockImpl clientLockImpl2 = this;
            synchronized (clientLockImpl2) {
                flushLevel = this.greediness.getFlushLevel();
            }
            remote.flush(this.lock);
            clientLockImpl2 = this;
            synchronized (clientLockImpl2) {
                if (flushLevel.equals((Object)this.greediness.getFlushLevel())) {
                    if (this.greediness.isRecalled() && this.canRecallNow()) {
                        this.greediness = this.recallCommit(remote, false);
                    }
                    node.delegated("Waiting For Recall...");
                    return LockAcquireResult.USED_SERVER;
                }
                LOGGER.info("Retrying flush on " + this.lock + " as flush level moved from " + (Object)((Object)flushLevel) + " to " + (Object)((Object)this.greediness.getFlushLevel()) + " during flush operation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockAcquireResult tryAcquireLocally(RemoteLockManager remote, ThreadID thread, LockLevel level) throws GarbageLockException {
        if (level == LockLevel.CONCURRENT) {
            return LockAcquireResult.SHARED_SUCCESS;
        }
        ClientLockImpl clientLockImpl = this;
        synchronized (clientLockImpl) {
            LockAcquireResult result = this.tryAcquireUsingThreadState(remote, thread, level);
            boolean interrupted = false;
            while (result.isWaitingForFlush()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                result = this.tryAcquireUsingThreadState(remote, thread, level);
            }
            if (interrupted) {
                Util.selfInterruptIfNeeded(interrupted);
            }
            if (result.isKnownResult()) {
                return result;
            }
            if (this.greediness.canAward(level)) {
                this.addFirst(new LockStateNode.LockHold(thread, level));
                return level.isWrite() ? LockAcquireResult.SUCCESS : LockAcquireResult.SHARED_SUCCESS;
            }
            return LockAcquireResult.UNKNOWN;
        }
    }

    private LockAcquireResult tryAcquireUsingThreadState(RemoteLockManager remote, ThreadID thread, LockLevel level) {
        if (this.isFlushInProgress()) {
            return LockAcquireResult.WAIT_FOR_FLUSH;
        }
        LockStateNode.LockHold newHold = new LockStateNode.LockHold(thread, level);
        for (LockStateNode s : this) {
            LockAcquireResult result = s.allowsHold(newHold);
            if (!result.isKnownResult()) continue;
            if (result.isWaitingForFlush()) {
                return result;
            }
            if (result.isSuccess()) {
                this.addFirst(newHold);
            } else if (level.isWrite() && this.isLockedBy(thread, READ_LEVELS)) {
                throw new TCLockUpgradeNotSupportedError();
            }
            return result;
        }
        if (level.isWrite() && this.isLockedBy(thread, READ_LEVELS)) {
            throw new TCLockUpgradeNotSupportedError();
        }
        return LockAcquireResult.UNKNOWN;
    }

    private boolean isFlushInProgress() {
        for (LockStateNode s : this) {
            if (!(s instanceof LockStateNode.LockHold) || !((LockStateNode.LockHold)s).isFlushInProgress()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean release(RemoteLockManager remote, ThreadID thread, LockLevel level) {
        if (level == LockLevel.CONCURRENT) {
            return false;
        }
        LockStateNode.LockHold unlock = null;
        ClientLockImpl clientLockImpl = this;
        synchronized (clientLockImpl) {
            for (LockStateNode s : this) {
                LockStateNode.LockHold hold;
                if (!(s instanceof LockStateNode.LockHold) || !(hold = (LockStateNode.LockHold)s).getOwner().equals(thread) || !hold.getLockLevel().equals((Object)level)) continue;
                unlock = hold;
                break;
            }
            if (unlock == null) {
                throw new IllegalMonitorStateException();
            }
            if (!unlock.getLockLevel().isSyncWrite() && !this.flushOnUnlock(unlock)) {
                return this.release(remote, unlock);
            }
        }
        clientLockImpl = this;
        synchronized (clientLockImpl) {
            ServerLockLevel flushLevel = this.greediness.getFlushLevel();
            if (this.flushOnUnlock(unlock) && !this.isFlushInProgress()) {
                unlock.flushInProgress();
                UnlockCallback flushCallback = new UnlockCallback(remote, flushLevel, unlock);
                if (remote.asyncFlush(this.lock, flushCallback)) {
                    flushCallback.transactionsForLockFlushed(this.lock);
                }
            } else {
                return this.release(remote, unlock);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean noLocksHeld(LockStateNode.LockHold unlockHold, ThreadID thread) {
        ClientLockImpl clientLockImpl = this;
        synchronized (clientLockImpl) {
            if (this.greediness == ClientGreediness.WRITE_RECALL_FOR_READ_IN_PROGRESS || this.greediness == ClientGreediness.RECALLED_WRITE_FOR_READ) {
                return false;
            }
            for (LockStateNode s : this) {
                if (s == unlockHold || s.getOwner().equals(thread) || !(s instanceof LockStateNode.LockHold)) continue;
                return false;
            }
            return true;
        }
    }

    private synchronized boolean release(RemoteLockManager remote, LockStateNode.LockHold unlock) {
        this.remove(unlock);
        if (this.greediness.isFree()) {
            this.remoteUnlock(remote, unlock);
        } else if (this.greediness.isRecalled() && this.canRecallNow()) {
            this.greediness = this.recallCommit(remote, false);
        }
        return true;
    }

    private void remoteUnlock(RemoteLockManager remote, LockStateNode.LockHold unlock) {
        for (LockStateNode s : this) {
            if (s == unlock || !(s instanceof LockStateNode.LockHold) || !s.getOwner().equals(unlock.getOwner())) continue;
            LockStateNode.LockHold hold = (LockStateNode.LockHold)s;
            if (unlock.getLockLevel().isWrite()) {
                if (!hold.getLockLevel().isWrite()) continue;
                return;
            }
            return;
        }
        this.resetPinIfNecessary();
        remote.unlock(this.lock, unlock.getOwner(), ServerLockLevel.fromClientLockLevel(unlock.getLockLevel()));
    }

    private synchronized boolean flushOnUnlock(LockStateNode.LockHold unlock) {
        if (!this.greediness.flushOnUnlock()) {
            return false;
        }
        for (LockStateNode s : this) {
            if (s == unlock || !(s instanceof LockStateNode.LockHold) || !s.getOwner().equals(unlock.getOwner())) continue;
            if (((LockStateNode.LockHold)s).getLockLevel().isWrite()) {
                return false;
            }
            if (!unlock.getLockLevel().isRead()) continue;
            return false;
        }
        return true;
    }

    private synchronized boolean flushOnUnlockAll(ThreadID thread) {
        if (this.greediness.flushOnUnlock()) {
            return true;
        }
        for (LockStateNode s : this) {
            if (!(s instanceof LockStateNode.LockHold) || !s.getOwner().equals(thread) || !((LockStateNode.LockHold)s).getLockLevel().isSyncWrite()) continue;
            return true;
        }
        return false;
    }

    private void acquireQueued(RemoteLockManager remote, ThreadID thread, LockLevel level) throws GarbageLockException {
        LockStateNode.PendingLockHold node = new LockStateNode.PendingLockHold(thread, level);
        this.addLast(node);
        this.acquireQueued(remote, thread, level, node);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void acquireQueued(RemoteLockManager remote, ThreadID thread, LockLevel level, LockStateNode.PendingLockHold node) throws GarbageLockException {
        boolean interrupted = false;
        try {
            while (true) {
                LockAcquireResult result;
                if ((result = this.tryAcquire(remote, thread, level, Integer.MIN_VALUE, node)).isShared()) {
                    this.unparkNextQueuedAcquire(node);
                } else {
                    this.unparkSubsequentTryLocks(node);
                }
                if (result.isSuccess()) {
                    this.remove(node);
                    return;
                }
                node.park();
                if (!Thread.interrupted()) continue;
                interrupted = true;
                if (remote.isShutdown()) throw new TCNotRunningException();
                continue;
                break;
            }
        }
        catch (RuntimeException ex) {
            this.abortAndRemove(remote, node);
            this.unparkFirstQueuedAcquire();
            throw ex;
        }
        catch (TCLockUpgradeNotSupportedError e) {
            this.abortAndRemove(remote, node);
            this.unparkFirstQueuedAcquire();
            throw e;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void acquireQueuedInterruptibly(RemoteLockManager remote, ThreadID thread, LockLevel level) throws InterruptedException, GarbageLockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 7[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean acquireQueuedTimeout(RemoteLockManager remote, ThreadID thread, LockLevel level, long timeout) throws InterruptedException, GarbageLockException {
        long lastTime = System.currentTimeMillis();
        LockStateNode.PendingTryLockHold node = new LockStateNode.PendingTryLockHold(thread, level, timeout);
        this.addLast(node);
        try {
            LockAcquireResult result;
            while (!node.isRefused()) {
                result = this.tryAcquire(remote, thread, level, timeout, node);
                if (result.isShared()) {
                    this.unparkNextQueuedAcquire(node);
                } else {
                    this.unparkSubsequentTryLocks(node);
                }
                if (result.isSuccess()) {
                    this.remove(node);
                    return true;
                }
                if (result.isFailure() && timeout <= 0L) {
                    this.abortAndRemove(remote, node);
                    return false;
                }
                if (node.canDelegate() && timeout <= 0L) {
                    this.abortAndRemove(remote, node);
                    return false;
                }
                if (!node.canDelegate()) {
                    node.park();
                } else {
                    node.park(timeout);
                }
                if (Thread.interrupted()) {
                    this.abortAndRemove(remote, node);
                    throw new InterruptedException();
                }
                long now = System.currentTimeMillis();
                timeout -= now - lastTime;
                lastTime = now;
            }
            this.remove(node);
            result = this.tryAcquireLocally(remote, thread, level);
            if (result.isShared()) {
                this.unparkFirstQueuedAcquire();
            }
            return result.isSuccess();
        }
        catch (RuntimeException ex) {
            this.abortAndRemove(remote, node);
            this.unparkFirstQueuedAcquire();
            throw ex;
        }
        catch (TCLockUpgradeNotSupportedError e) {
            this.abortAndRemove(remote, node);
            this.unparkFirstQueuedAcquire();
            throw e;
        }
    }

    private synchronized void abortAndRemove(RemoteLockManager remote, LockStateNode.PendingLockHold node) {
        if ((node = this.remove(node)) != null && node.isAwarded()) {
            this.resetPinIfNecessary();
            remote.unlock(this.lock, node.getOwner(), ServerLockLevel.fromClientLockLevel(node.getLockLevel()));
        }
    }

    private void unparkFirstQueuedAcquire() {
        LockStateNode.PendingLockHold firstAcquire = this.getFirstQueuedAcquire();
        if (firstAcquire != null) {
            firstAcquire.unpark();
        }
    }

    private void unparkNextQueuedAcquire(LockStateNode node) {
        LockStateNode.PendingLockHold nextAcquire = this.getNextQueuedAcquire(node);
        if (nextAcquire != null) {
            nextAcquire.unpark();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void unparkSubsequentTryLocks(LockStateNode node) {
        ArrayList<LockStateNode.PendingTryLockHold> pending = new ArrayList<LockStateNode.PendingTryLockHold>();
        ClientLockImpl clientLockImpl = this;
        synchronized (clientLockImpl) {
            void var4_5;
            LockStateNode.PendingLockHold pendingLockHold = this.getNextQueuedAcquire(node);
            while (var4_5 != null) {
                if (var4_5 instanceof LockStateNode.PendingTryLockHold) {
                    pending.add((LockStateNode.PendingTryLockHold)var4_5);
                }
                LockStateNode.PendingLockHold pendingLockHold2 = this.getNextQueuedAcquire((LockStateNode)var4_5);
            }
        }
        for (LockStateNode.PendingTryLockHold pendingTryLockHold : pending) {
            pendingTryLockHold.unpark();
        }
    }

    private synchronized LockStateNode.PendingLockHold getFirstQueuedAcquire() {
        for (LockStateNode current : this) {
            if (!(current instanceof LockStateNode.PendingLockHold)) continue;
            return (LockStateNode.PendingLockHold)current;
        }
        return null;
    }

    private synchronized LockStateNode.PendingLockHold getNextQueuedAcquire(LockStateNode node) {
        for (LockStateNode current = node.getNext(); current != null; current = current.getNext()) {
            if (!(current instanceof LockStateNode.PendingLockHold)) continue;
            return (LockStateNode.PendingLockHold)current;
        }
        return null;
    }

    private synchronized LockStateNode.PendingLockHold getQueuedAcquire(ThreadID thread, ServerLockLevel level) {
        for (LockStateNode s : this) {
            if (!(s instanceof LockStateNode.PendingLockHold) || !s.getOwner().equals(thread) || !level.equals((Object)ServerLockLevel.fromClientLockLevel(((LockStateNode.PendingLockHold)s).getLockLevel()))) continue;
            return (LockStateNode.PendingLockHold)s;
        }
        return null;
    }

    private synchronized ClientGreediness doRecall(RemoteLockManager remote, boolean batch) {
        if (this.canRecallNow()) {
            ServerLockLevel flushLevel = this.greediness.getFlushLevel();
            RecallCallback callback = new RecallCallback(remote, batch, flushLevel);
            this.resetPinIfNecessary();
            if (remote.asyncFlush(this.lock, callback)) {
                return this.recallCommit(remote, batch);
            }
            return this.greediness.recallInProgress();
        }
        return this.greediness;
    }

    private synchronized ClientGreediness recallCommit(RemoteLockManager remote, boolean batch) {
        if (this.greediness.isFree()) {
            return this.greediness;
        }
        Collection<ClientServerExchangeLockContext> contexts = this.getRecallCommitStateSnapshot(remote.getClientID());
        ClientGreediness postRecallCommitGreediness = this.greediness.recallCommitted();
        for (LockStateNode node : this) {
            if (!(node instanceof LockStateNode.PendingLockHold)) continue;
            if (postRecallCommitGreediness.isGreedy()) {
                ((LockStateNode.PendingLockHold)node).allowDelegation();
                continue;
            }
            ((LockStateNode.PendingLockHold)node).delegated("Attached To Recall Commit Message...");
        }
        remote.recallCommit(this.lock, contexts, batch);
        this.resetPinIfNecessary();
        this.greediness = this.greediness.recallCommitted();
        if (this.greediness.isGreedy()) {
            this.unparkFirstQueuedAcquire();
        }
        return this.greediness;
    }

    private synchronized boolean canRecallNow() {
        for (LockStateNode s : this) {
            if (!(s instanceof LockStateNode.LockHold) || !((LockStateNode.LockHold)s).getLockLevel().isWrite()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean tryMarkAsGarbage(RemoteLockManager remote) {
        if (this.pinned == 0 && this.isEmpty() && this.gcCycleCount > 0) {
            this.greediness = this.greediness.markAsGarbage();
            if (this.greediness.isGarbage()) {
                return true;
            }
            this.recall(remote, ServerLockLevel.WRITE, -1, false);
            return false;
        }
        byte by = this.gcCycleCount;
        this.gcCycleCount = (byte)(by + 1);
        this.gcCycleCount = (byte)Math.max(127, by);
        return false;
    }

    private void markUsed() {
        this.gcCycleCount = 0;
    }

    @Override
    public synchronized void initializeHandshake(ClientID client, ClientHandshakeMessage message) {
        Collection<ClientServerExchangeLockContext> contexts = this.getFilteredStateSnapshot(client, true);
        for (LockStateNode node : this) {
            if (!(node instanceof LockStateNode.PendingLockHold)) continue;
            ((LockStateNode.PendingLockHold)node).delegated("Attached To Handshake Message...");
        }
        for (ClientServerExchangeLockContext c : contexts) {
            message.addLockContext(c);
        }
    }

    private synchronized Collection<ClientServerExchangeLockContext> getFilteredStateSnapshot(ClientID client, boolean greedy) {
        ArrayList<ClientServerExchangeLockContext> legacyState = new ArrayList<ClientServerExchangeLockContext>();
        HashMap<ThreadID, ClientServerExchangeLockContext> holds = new HashMap<ThreadID, ClientServerExchangeLockContext>();
        HashMap<ThreadID, ClientServerExchangeLockContext> pends = new HashMap<ThreadID, ClientServerExchangeLockContext>();
        block8: for (ClientServerExchangeLockContext context : this.getStateSnapshot(client)) {
            switch (context.getState()) {
                case HOLDER_READ: {
                    if (holds.get(context.getThreadID()) != null) continue block8;
                    holds.put(context.getThreadID(), context);
                    continue block8;
                }
                case HOLDER_WRITE: {
                    holds.put(context.getThreadID(), context);
                    continue block8;
                }
                case PENDING_READ: 
                case TRY_PENDING_READ: {
                    if (pends.get(context.getThreadID()) != null) continue block8;
                    pends.put(context.getThreadID(), context);
                    continue block8;
                }
                case PENDING_WRITE: 
                case TRY_PENDING_WRITE: {
                    pends.put(context.getThreadID(), context);
                    continue block8;
                }
                case WAITER: {
                    legacyState.add(context);
                    continue block8;
                }
                case GREEDY_HOLDER_READ: 
                case GREEDY_HOLDER_WRITE: {
                    if (!greedy) continue block8;
                    return Collections.singletonList(context);
                }
            }
            throw new AssertionError((Object)context.getState());
        }
        legacyState.addAll(holds.values());
        legacyState.addAll(pends.values());
        return legacyState;
    }

    private synchronized Collection<ClientServerExchangeLockContext> getRecallCommitStateSnapshot(ClientID client) {
        ClientGreediness postRecallGreediness = this.greediness.recallCommitted();
        if (postRecallGreediness.isGreedy()) {
            ArrayList<ClientServerExchangeLockContext> contexts = new ArrayList<ClientServerExchangeLockContext>();
            contexts.add(postRecallGreediness.toContext(this.lock, client));
            return contexts;
        }
        return this.getFilteredStateSnapshot(client, false);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClientLockImpl : ").append(this.lock).append('\n');
        sb.append("GC Cycle Count : ").append(this.gcCycleCount).append('\n');
        sb.append("Greediness : ").append((Object)this.greediness).append('\n');
        sb.append("State:").append('\n');
        for (LockStateNode s : this) {
            sb.append('\t').append(s).append('\n');
        }
        return sb.toString();
    }

    @Override
    public synchronized boolean isAwardValid(long awardIDParam) {
        return this.awardId != NULL_AWARD_ID && this.awardId == awardIDParam;
    }

    @Override
    public synchronized long getAwardID() {
        if (this.awardId == NULL_AWARD_ID) {
            throw new IllegalStateException();
        }
        return this.awardId;
    }

    final synchronized void setAwardID(long awardId) {
        this.awardId = awardId;
    }

    private class RecallCallback
    implements LockFlushCallback {
        private final RemoteLockManager remote;
        private final boolean batch;
        private final ServerLockLevel expectedFlushLevel;

        public RecallCallback(RemoteLockManager remote, boolean batch, ServerLockLevel flushLevel) {
            this.remote = remote;
            this.batch = batch;
            this.expectedFlushLevel = flushLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transactionsForLockFlushed(LockID id) {
            ClientLockImpl clientLockImpl = ClientLockImpl.this;
            synchronized (clientLockImpl) {
                if (ClientLockImpl.this.greediness.isRecallInProgress()) {
                    ServerLockLevel flushLevel = ClientLockImpl.this.greediness.getFlushLevel();
                    if (this.expectedFlushLevel.equals((Object)flushLevel)) {
                        ClientLockImpl.this.greediness = ClientLockImpl.this.recallCommit(this.remote, this.batch);
                    } else {
                        LOGGER.info("Retrying flush on " + ClientLockImpl.this.lock + " as flush level moved from " + (Object)((Object)this.expectedFlushLevel) + " to " + (Object)((Object)flushLevel) + " during flush operation");
                        RecallCallback callback = new RecallCallback(this.remote, this.batch, flushLevel);
                        if (this.remote.asyncFlush(id, callback)) {
                            ClientLockImpl.this.greediness = ClientLockImpl.this.recallCommit(this.remote, this.batch);
                        }
                    }
                }
            }
        }
    }

    private class UnlockCallback
    implements LockFlushCallback {
        private final RemoteLockManager remote;
        private final ServerLockLevel expectedFlushLevel;
        private final LockStateNode.LockHold unlock;

        public UnlockCallback(RemoteLockManager remote, ServerLockLevel flushLevel, LockStateNode.LockHold unlock) {
            this.remote = remote;
            this.expectedFlushLevel = flushLevel;
            this.unlock = unlock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transactionsForLockFlushed(LockID id) {
            ClientLockImpl clientLockImpl = ClientLockImpl.this;
            synchronized (clientLockImpl) {
                if (this.expectedFlushLevel.equals((Object)ClientLockImpl.this.greediness.getFlushLevel())) {
                    this.releaseOnFlush();
                } else {
                    UnlockCallback callback = new UnlockCallback(this.remote, ClientLockImpl.this.greediness.getFlushLevel(), this.unlock);
                    if (this.remote.asyncFlush(id, callback)) {
                        this.releaseOnFlush();
                    }
                }
            }
        }

        private void releaseOnFlush() {
            this.unlock.flushCompleted();
            ClientLockImpl.this.notifyAll();
            ClientLockImpl.this.release(this.remote, this.unlock);
            ClientLockImpl.this.unparkFirstQueuedAcquire();
        }
    }

    static enum LockAcquireResult {
        SHARED_SUCCESS,
        SUCCESS,
        FAILURE,
        USED_SERVER,
        WAIT_FOR_FLUSH,
        UNKNOWN;


        public boolean isShared() {
            return this != SUCCESS;
        }

        public boolean isSuccess() {
            return this == SUCCESS | this == SHARED_SUCCESS;
        }

        public boolean isFailure() {
            return this == FAILURE;
        }

        public boolean usedServer() {
            return this == USED_SERVER;
        }

        public boolean isKnownResult() {
            return this.isSuccess() || this.isFailure() || this.isWaitingForFlush();
        }

        public boolean isWaitingForFlush() {
            return this == WAIT_FOR_FLUSH;
        }
    }
}

