/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.handshakemanager;

import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.net.ClientID;
import com.tc.object.handshakemanager.ClientHandshakeCallback;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.ClientHandshakeMessageFactory;
import com.tc.object.session.SessionManager;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.Util;
import com.tc.util.version.Version;
import com.tc.util.version.VersionCompatibility;
import com.tcclient.cluster.ClusterInternalEventsGun;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ClientHandshakeManagerImpl
implements ClientHandshakeManager {
    private static final TCLogger CONSOLE_LOGGER = CustomerLogging.getConsoleLogger();
    private final Collection<ClientHandshakeCallback> callBacks;
    private final ClientHandshakeMessageFactory chmf;
    private final TCLogger logger;
    private final SessionManager sessionManager;
    private final String clientVersion;
    private final String uuid;
    private final String name;
    private State state;
    private volatile boolean disconnected;
    private volatile boolean serverIsPersistent = false;
    private volatile boolean isShutdown = false;
    private final Lock lock = new ReentrantLock();
    private final ClusterInternalEventsGun clusterEventsGun;

    public ClientHandshakeManagerImpl(TCLogger logger, ClientHandshakeMessageFactory chmf, SessionManager sessionManager, ClusterInternalEventsGun clusterEventsGun, String uuid, String name, String clientVersion, Collection<ClientHandshakeCallback> callbacks) {
        this.logger = logger;
        this.chmf = chmf;
        this.sessionManager = sessionManager;
        this.clusterEventsGun = clusterEventsGun;
        this.uuid = uuid;
        this.name = name;
        this.clientVersion = clientVersion;
        this.callBacks = callbacks;
        this.state = State.PAUSED;
        this.disconnected = true;
        this.pauseCallbacks();
    }

    @Override
    public synchronized void shutdown(boolean fromShutdownHook) {
        this.isShutdown = true;
        this.notifyAll();
        this.shutdownCallbacks(fromShutdownHook);
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    private boolean checkShutdown() {
        if (this.isShutdown) {
            this.logger.warn("Drop handshaking due to client shutting down...");
        }
        return this.isShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateHandshake() {
        ClientHandshakeMessage handshakeMessage;
        this.logger.debug("Initiating handshake...");
        this.lock.lock();
        try {
            this.changeToStarting();
            handshakeMessage = this.chmf.newClientHandshakeMessage(this.uuid, this.name, this.clientVersion, this.isEnterpriseClient());
            this.notifyCallbackOnHandshake(handshakeMessage);
        }
        finally {
            this.lock.unlock();
        }
        this.logger.info("Sending handshake message");
        handshakeMessage.send();
    }

    protected boolean isEnterpriseClient() {
        return false;
    }

    @Override
    public void fireNodeError() {
        String msg = "Reconnection was rejected from server. This client will never be able to join the cluster again.";
        this.logger.error("Reconnection was rejected from server. This client will never be able to join the cluster again.");
        CONSOLE_LOGGER.error("Reconnection was rejected from server. This client will never be able to join the cluster again.");
        this.clusterEventsGun.fireNodeError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected() {
        if (!this.checkShutdown()) {
            this.lock.lock();
            try {
                boolean isPaused = this.changeToPaused();
                if (isPaused) {
                    this.pauseCallbacks();
                    this.sessionManager.newSession();
                    this.logger.info("ClientHandshakeManager moves to " + this.sessionManager.getSessionID());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void connected() {
        this.logger.info("Connected: Unpausing from " + (Object)((Object)this.getState()));
        if (this.getState() != State.PAUSED) {
            this.logger.warn("Ignoring unpause while " + (Object)((Object)this.getState()));
        } else if (!this.checkShutdown()) {
            this.initiateHandshake();
        }
    }

    @Override
    public void acknowledgeHandshake(ClientHandshakeAckMessage handshakeAck) {
        this.acknowledgeHandshake(handshakeAck.getPersistentServer(), handshakeAck.getThisNodeId(), handshakeAck.getAllNodes(), handshakeAck.getServerVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acknowledgeHandshake(boolean persistentServer, ClientID thisNodeId, ClientID[] clusterMembers, String serverVersion) {
        this.logger.info("Received Handshake ack");
        if (this.getState() != State.STARTING) {
            this.logger.warn("Ignoring handshake acknowledgement while " + (Object)((Object)this.getState()));
        } else {
            this.checkClientServerVersionCompatibility(serverVersion);
            this.serverIsPersistent = persistentServer;
            this.lock.lock();
            try {
                this.changeToRunning();
                this.unpauseCallbacks();
            }
            finally {
                this.lock.unlock();
            }
            this.clusterEventsGun.fireThisNodeJoined(thisNodeId, clusterMembers);
        }
    }

    protected void checkClientServerVersionCompatibility(String serverVersion) {
        boolean check = TCPropertiesImpl.getProperties().getBoolean("version.compatibility.check");
        if (check && !new VersionCompatibility().isCompatibleClientServer(new Version(this.clientVersion), new Version(serverVersion))) {
            String msg = "Client/Server versions are not compatibile: Client Version: " + this.clientVersion + ", Server Version: " + serverVersion + ".  Terminating client now.";
            CONSOLE_LOGGER.error(msg);
            throw new IllegalStateException(msg);
        }
    }

    private void shutdownCallbacks(boolean fromShutdownHook) {
        for (ClientHandshakeCallback c : this.callBacks) {
            c.shutdown(fromShutdownHook);
        }
    }

    private void pauseCallbacks() {
        for (ClientHandshakeCallback c : this.callBacks) {
            c.pause();
        }
    }

    private void notifyCallbackOnHandshake(ClientHandshakeMessage handshakeMessage) {
        for (ClientHandshakeCallback c : this.callBacks) {
            c.initializeHandshake(handshakeMessage);
        }
    }

    private void unpauseCallbacks() {
        for (ClientHandshakeCallback c : this.callBacks) {
            c.unpause();
        }
    }

    @Override
    public boolean serverIsPersistent() {
        return this.serverIsPersistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void waitForHandshake() {
        boolean isInterrupted = false;
        try {
            while (this.disconnected && !this.isShutdown()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.logger.error("Interrupted while waiting for handshake");
                    isInterrupted = true;
                }
            }
        }
        finally {
            Util.selfInterruptIfNeeded(isInterrupted);
        }
    }

    private synchronized boolean changeToPaused() {
        State old = this.state;
        boolean didChangeToPaused = false;
        if (old != State.PAUSED) {
            this.state = State.PAUSED;
            didChangeToPaused = true;
            this.logger.info("Disconnected: Pausing from " + (Object)((Object)old) + ". Disconnect count: " + this.disconnected);
            if (old == State.RUNNING) {
                this.disconnected = true;
                this.notifyAll();
            }
            this.clusterEventsGun.fireOperationsDisabled();
        }
        return didChangeToPaused;
    }

    private synchronized void changeToStarting() {
        Assert.assertEquals((Object)this.state, (Object)State.PAUSED);
        this.state = State.STARTING;
    }

    private synchronized void changeToRunning() {
        Assert.assertEquals((Object)this.state, (Object)State.STARTING);
        this.state = State.RUNNING;
        this.disconnected = false;
        this.notifyAll();
    }

    private synchronized State getState() {
        return this.state;
    }

    private static enum State {
        PAUSED,
        STARTING,
        RUNNING;

    }
}

