/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dna.impl;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.EntityID;
import com.tc.object.LogicalOperation;
import com.tc.object.ObjectID;
import com.tc.object.dna.api.DNA;
import com.tc.object.dna.api.DNACursor;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.api.DNAEncodingInternal;
import com.tc.object.dna.api.LiteralAction;
import com.tc.object.dna.api.LogicalAction;
import com.tc.object.dna.api.LogicalChangeID;
import com.tc.object.dna.api.PhysicalAction;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.StorageDNAEncodingImpl;
import com.tc.util.Assert;
import com.tc.util.Conversion;
import java.io.IOException;

public class DNAImpl
implements DNA,
DNACursor,
TCSerializable<DNAImpl> {
    private static final LogicalOperation[] LOGICAL_OPERATION_VALUES = LogicalOperation.values();
    private static final DNAEncodingInternal DNA_STORAGE_ENCODING = new StorageDNAEncodingImpl();
    private final ObjectStringSerializer serializer;
    private final boolean createOutput;
    protected TCByteBufferInput input;
    protected TCByteBuffer[] dataOut;
    private int actionCount = 0;
    private int origActionCount;
    private boolean isDelta;
    private EntityID id;
    private int arrayLength;
    private long version;
    private int dnaLength;
    private Object currentAction;
    private boolean wasDeserialized = false;

    public DNAImpl(ObjectStringSerializer serializer, boolean createOutput) {
        this.serializer = serializer;
        this.createOutput = createOutput;
    }

    @Override
    public DNACursor getCursor() {
        return this;
    }

    @Override
    public boolean next() throws IOException {
        try {
            return this.next(DNA_STORAGE_ENCODING);
        }
        catch (ClassNotFoundException e) {
            throw Assert.failure("Internal error");
        }
    }

    @Override
    public boolean next(DNAEncoding encoding) throws IOException, ClassNotFoundException {
        boolean hasNext;
        DNAEncodingInternal encodingInternal = (DNAEncodingInternal)encoding;
        boolean bl = hasNext = this.actionCount > 0;
        if (hasNext) {
            this.parseNext(encodingInternal);
            --this.actionCount;
        } else if (this.input.available() != 0) {
            throw new IOException(this.input.available() + " bytes remaining (expect " + 0 + ")");
        }
        return hasNext;
    }

    private void parseNext(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        byte recordType = this.input.readByte();
        switch (recordType) {
            case 2: {
                this.parsePhysical(encoding, false);
                return;
            }
            case 6: {
                this.parsePhysical(encoding, true);
                return;
            }
            case 1: {
                this.parseLogical(encoding);
                return;
            }
            case 3: {
                this.parseArrayElement(encoding);
                return;
            }
            case 4: {
                this.parseEntireArray(encoding);
                return;
            }
            case 5: {
                this.parseLiteralValue(encoding);
                return;
            }
            case 7: {
                this.parseSubArray(encoding);
                return;
            }
        }
        throw new IOException("Invalid record type: " + recordType);
    }

    private void parseSubArray(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        int startPos = this.input.readInt();
        Object subArray = encoding.decode(this.input);
        this.currentAction = new PhysicalAction(subArray, startPos);
    }

    private void parseEntireArray(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        Object array = encoding.decode(this.input);
        this.currentAction = new PhysicalAction(array);
    }

    private void parseLiteralValue(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        Object value = encoding.decode(this.input);
        this.currentAction = new LiteralAction(value);
    }

    private void parseArrayElement(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        int index = this.input.readInt();
        Object value = encoding.decode(this.input);
        this.currentAction = new PhysicalAction(index, value, value instanceof ObjectID);
    }

    private void parsePhysical(DNAEncodingInternal encoding, boolean isReference) throws IOException, ClassNotFoundException {
        Object value;
        String fieldName = this.serializer.readFieldName(this.input);
        this.currentAction = new PhysicalAction(fieldName, value, (value = encoding.decode(this.input)) instanceof ObjectID || isReference);
    }

    private void parseLogical(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        LogicalChangeID logicalChangeID = LogicalChangeID.NULL_ID;
        if (!this.input.readBoolean()) {
            logicalChangeID = new LogicalChangeID(this.input.readLong());
        }
        LogicalOperation method = LOGICAL_OPERATION_VALUES[this.input.readInt()];
        int paramCount = this.input.read();
        if (paramCount < 0) {
            throw new AssertionError((Object)("Invalid param count:" + paramCount));
        }
        Object[] params = new Object[paramCount];
        for (int i = 0; i < params.length; ++i) {
            params[i] = encoding.decode(this.input, this.serializer);
        }
        this.currentAction = new LogicalAction(method, params, logicalChangeID);
    }

    @Override
    public LogicalAction getLogicalAction() {
        return (LogicalAction)this.currentAction;
    }

    @Override
    public PhysicalAction getPhysicalAction() {
        return (PhysicalAction)this.currentAction;
    }

    @Override
    public Object getAction() {
        return this.currentAction;
    }

    public String toString() {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("DNAImpl\n");
            buf.append("{\n");
            buf.append("  id->" + this.getEntityID() + "\n");
            buf.append("  version->" + this.getVersion() + "\n");
            buf.append("  isDelta->" + this.isDelta() + "\n");
            buf.append("  actionCount->" + this.actionCount + "\n");
            buf.append("  actionCount (orig)->" + this.origActionCount + "\n");
            buf.append("  deserialized?->" + this.wasDeserialized + "\n");
            buf.append("}\n");
            return buf.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public int getArraySize() {
        return this.arrayLength;
    }

    @Override
    public boolean hasLength() {
        return this.getArraySize() >= 0;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public synchronized void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.write(this.dataOut);
    }

    @Override
    public DNAImpl deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.wasDeserialized = true;
        TCByteBufferInput.Mark mark = serialInput.mark();
        this.dnaLength = serialInput.readInt();
        if (this.dnaLength <= 0) {
            throw new IOException("Invalid length:" + this.dnaLength);
        }
        serialInput.tcReset(mark);
        this.input = serialInput.duplicateAndLimit(this.dnaLength);
        serialInput.skip(this.dnaLength);
        if (this.createOutput) {
            this.dataOut = this.input.toArray();
        }
        this.input.readInt();
        this.origActionCount = this.actionCount = this.input.readInt();
        if (this.actionCount < 0) {
            throw new IOException("Invalid action count:" + this.actionCount);
        }
        byte flags = this.input.readByte();
        this.id = EntityID.readFrom(this.input);
        this.isDelta = Conversion.getFlag(flags, 2);
        this.version = Conversion.getFlag(flags, 4) ? this.input.readLong() : -1L;
        this.arrayLength = Conversion.getFlag(flags, 1) ? this.input.readInt() : -1;
        return this;
    }

    @Override
    public int getActionCount() {
        return this.actionCount;
    }

    @Override
    public boolean isDelta() {
        return this.isDelta;
    }

    @Override
    public EntityID getEntityID() {
        return this.id;
    }

    @Override
    public void reset() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Reset is not supported by this class");
    }
}

