/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import java.util.Arrays;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityUserException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.exception.PermanentEntityException;

public class ExceptionUtils {
    public static EntityException addLocalStackTraceToEntityException(EntityException e) {
        EntityException wrappedException;
        if (e instanceof EntityUserException) {
            wrappedException = new EntityUserException(e.getClassName(), e.getEntityName(), e);
        } else if (e instanceof EntityNotFoundException) {
            wrappedException = new EntityNotFoundException(e.getClassName(), e.getEntityName(), e);
        } else if (e instanceof PermanentEntityException) {
            wrappedException = new PermanentEntityException(e.getClassName(), e.getEntityName(), e);
        } else if (e instanceof EntityNotProvidedException) {
            wrappedException = new EntityNotProvidedException(e.getClassName(), e.getEntityName(), e);
        } else if (e instanceof EntityVersionMismatchException) {
            EntityVersionMismatchException vme = (EntityVersionMismatchException)e;
            wrappedException = new EntityVersionMismatchException(e.getClassName(), e.getEntityName(), vme.getExpectedVersion(), vme.getAttemptedVersion(), e);
        } else {
            wrappedException = e instanceof EntityAlreadyExistsException ? new EntityAlreadyExistsException(e.getClassName(), e.getEntityName(), e) : new EntityException(e.getClassName(), e.getClassName(), e.getDescription(), e){};
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        wrappedException.setStackTrace(Arrays.copyOfRange(stackTrace, 2, stackTrace.length));
        return wrappedException;
    }
}

