/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.GroupID;
import com.tc.net.StripeID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.util.Assert;
import java.io.IOException;

public class StripeIDGroupMessage
extends AbstractGroupMessage {
    public static final int STRIPEID_MESSAGE = 1;
    private GroupID groupID;
    private StripeID stripeID;
    private boolean isActive;
    private boolean remap;

    public StripeIDGroupMessage() {
        super(-1);
    }

    public StripeIDGroupMessage(int type, GroupID groupID, StripeID stripeID, boolean isActive, boolean isRemap) {
        super(type);
        this.groupID = groupID;
        this.stripeID = stripeID;
        this.isActive = isActive;
        this.remap = isRemap;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        Assert.assertEquals(1, this.getType());
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer();
        nodeIDSerializer.deserializeFrom(in);
        this.groupID = (GroupID)nodeIDSerializer.getNodeID();
        nodeIDSerializer = new NodeIDSerializer();
        nodeIDSerializer.deserializeFrom(in);
        this.stripeID = (StripeID)nodeIDSerializer.getNodeID();
        this.isActive = in.readBoolean();
        this.remap = in.readBoolean();
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        Assert.assertEquals(1, this.getType());
        new NodeIDSerializer(this.groupID).serializeTo(out);
        new NodeIDSerializer(this.stripeID).serializeTo(out);
        out.writeBoolean(this.isActive);
        out.writeBoolean(this.remap);
    }

    public String toString() {
        return "StripeIDGroupMessage [ " + this.stripeID + " " + this.groupID + " isActive: " + this.isActive + " isRemap:" + this.remap + " ]";
    }

    public GroupID getGroupID() {
        return this.groupID;
    }

    public StripeID getStripeID() {
        return this.stripeID;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isRemap() {
        return this.remap;
    }
}

