/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management;

import com.tc.management.ManagementResources;
import com.tc.management.beans.L2MBeanNames;
import com.tc.management.beans.MBeanNames;
import com.tc.net.TCSocketAddress;
import com.tc.util.UUID;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;

public abstract class TerracottaManagement {
    private static final ManagementResources MANAGEMENT_RESOURCES = new ManagementResources();
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String EQUALS = "=";
    private static final String UNDERSCORE = "_";
    private static final String NODE_PREFIX_KEY = "clients";
    private static final String NODE_PREFIX = "clients=Clients";
    private static final String NODE_NAME = System.getProperty(MANAGEMENT_RESOURCES.getNodeNameSystemProperty());

    public static ObjectName createObjectName(Type type, Subsystem subsystem, TCSocketAddress remoteBeanHome, String uiFriendlyName, MBeanDomain domain) throws MalformedObjectNameException {
        StringBuffer objName = new StringBuffer(null == domain ? MBeanDomain.INTERNAL.toString() : domain.toString());
        objName.append(COLON);
        if (NODE_NAME != null || remoteBeanHome != null) {
            objName.append(NODE_PREFIX);
            if (NODE_NAME != null) {
                objName.append(COMMA).append("node-name").append(EQUALS).append(NODE_NAME);
            }
            if (remoteBeanHome != null) {
                TerracottaManagement.addNodeInfo(objName, remoteBeanHome);
            }
            objName.append(COMMA);
        }
        objName.append("type").append(EQUALS).append(type);
        if (subsystem != Subsystem.None) {
            objName.append(COMMA).append("subsystem").append(EQUALS).append(subsystem);
        }
        objName.append(COMMA).append("name").append(EQUALS).append(uiFriendlyName);
        return new ObjectName(objName.toString());
    }

    private static void addNodeInfo(StringBuffer objName, TCSocketAddress addr) {
        objName.append(COMMA).append("node").append(EQUALS).append(TerracottaManagement.buildNodeId(addr));
    }

    public static String buildNodeId(TCSocketAddress addr) {
        String remoteHost = addr.getAddress().getCanonicalHostName();
        int remotePort = addr.getPort();
        return remoteHost + UNDERSCORE + remotePort;
    }

    public static ObjectName addNodeInfo(ObjectName objName, TCSocketAddress addr) throws MalformedObjectNameException {
        if (objName.getKeyProperty("node") != null) {
            Hashtable<String, String> kpl = objName.getKeyPropertyList();
            kpl.remove("node");
            objName = ObjectName.getInstance(objName.getDomain(), kpl);
        }
        StringBuffer sb = new StringBuffer(objName.getCanonicalName());
        if (objName.getKeyProperty(NODE_PREFIX_KEY) == null) {
            sb.append(COMMA).append(NODE_PREFIX);
        }
        TerracottaManagement.addNodeInfo(sb, addr);
        return new ObjectName(sb.toString());
    }

    private static void addNodeInfo(StringBuffer objName, UUID id) {
        objName.append(COMMA).append("node").append(EQUALS).append(id);
    }

    public static ObjectName addNodeInfo(ObjectName objName, UUID id) throws MalformedObjectNameException {
        if (objName.getKeyProperty("node") != null) {
            Hashtable<String, String> kpl = objName.getKeyPropertyList();
            kpl.remove("node");
            objName = ObjectName.getInstance(objName.getDomain(), kpl);
        }
        StringBuffer sb = new StringBuffer(objName.getCanonicalName());
        if (objName.getKeyProperty(NODE_PREFIX_KEY) == null) {
            sb.append(COMMA).append(NODE_PREFIX);
        }
        TerracottaManagement.addNodeInfo(sb, id);
        return new ObjectName(sb.toString());
    }

    public abstract Object findMBean(ObjectName var1, Class<?> var2) throws Exception;

    public static final Object findMBean(ObjectName objectName, Class<?> mBeanInterface, MBeanServerConnection mBeanServer) throws IOException {
        Set<ObjectInstance> matchingBeans = mBeanServer.queryMBeans(objectName, null);
        Iterator<ObjectInstance> beanPos = matchingBeans.iterator();
        if (beanPos.hasNext()) {
            return MBeanServerInvocationHandler.newProxyInstance(mBeanServer, objectName, mBeanInterface, false);
        }
        return null;
    }

    public static final QueryExp matchAllTerracottaMBeans(UUID id) {
        try {
            QueryExp query = Query.or(new ObjectName((Object)((Object)MBeanDomain.PUBLIC) + ":*,node=" + id), new ObjectName((Object)((Object)MBeanDomain.INTERNAL) + ":*,node=" + id));
            return query;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static final QueryExp matchAllTimMBeans() {
        try {
            return new ObjectName((Object)((Object)MBeanDomain.TIM) + ":*");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String quoteIfNecessary(String objectNamePart) {
        if (objectNamePart.matches("[,=:*?\"']")) {
            return ObjectName.quote(objectNamePart);
        }
        return objectNamePart;
    }

    public static final Set<ObjectName> getAllL1DumperMBeans(MBeanServerConnection mbs) throws MalformedObjectNameException, NullPointerException, IOException {
        return mbs.queryNames(new ObjectName(MBeanNames.L1DUMPER_INTERNAL.getCanonicalName() + ",*"), null);
    }

    public static final Set<ObjectName> getAllL2DumperMBeans(MBeanServerConnection mbs) throws MalformedObjectNameException, NullPointerException, IOException {
        return mbs.queryNames(new ObjectName(L2MBeanNames.DUMPER.getCanonicalName() + ",*"), null);
    }

    static /* synthetic */ ManagementResources access$000() {
        return MANAGEMENT_RESOURCES;
    }

    public static enum MBeanDomain {
        PUBLIC(TerracottaManagement.access$000().getPublicMBeanDomain()),
        INTERNAL(TerracottaManagement.access$000().getInternalMBeanDomain()),
        TIM(TerracottaManagement.access$000().getTimMBeanDomain());

        private final String value;

        private MBeanDomain(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static interface MBeanKeys {
        public static final String TYPE = "type";
        public static final String MBEAN_NODE = "node";
        public static final String MBEAN_NODE_NAME = "node-name";
        public static final String SUBSYSTEM = "subsystem";
        public static final String NAME = "name";
    }

    public static class Subsystem {
        private static final Map<String, Subsystem> subsystemByName = Collections.synchronizedMap(new HashMap());
        public static final Subsystem Tx = new Subsystem(TerracottaManagement.access$000().getTransactionSubsystem());
        public static final Subsystem Locking = new Subsystem(TerracottaManagement.access$000().getLockingSubsystem());
        public static final Subsystem ObjectManagement = new Subsystem(TerracottaManagement.access$000().getObjectManagementSubsystem());
        public static final Subsystem Logging = new Subsystem(TerracottaManagement.access$000().getLoggingSubsystem());
        public static final Subsystem Statistics = new Subsystem(TerracottaManagement.access$000().getStatisticsSubsystem());
        public static final Subsystem None = new Subsystem(TerracottaManagement.access$000().getNoneSubsystem());
        private final String subsystem;

        private Subsystem(String subsystem) {
            this.subsystem = subsystem;
            subsystemByName.put(subsystem, this);
        }

        public String toString() {
            return this.subsystem;
        }

        static Subsystem getSubsystem(String name) {
            return subsystemByName.get(name);
        }
    }

    public static class Type {
        private static final Map<String, Type> typesByName = Collections.synchronizedMap(new HashMap());
        public static final Type DsoClient = new Type(TerracottaManagement.access$000().getDsoClientType());
        public static final Type Sessions = new Type(TerracottaManagement.access$000().getSessionsType());
        public static final Type Server = new Type(TerracottaManagement.access$000().getTerracottaServerType());
        public static final Type Cluster = new Type(TerracottaManagement.access$000().getTerracottaClusterType());
        public static final Type Agent = new Type(TerracottaManagement.access$000().getTerracottaAgentType());
        public static final Type Tim = new Type(TerracottaManagement.access$000().getTerracottaTimType());
        public static final Type TcOperatorEvents = new Type(TerracottaManagement.access$000().getTerracottaOperatorEventType());
        private final String type;

        private Type(String type) {
            this.type = type;
            typesByName.put(type, this);
        }

        public String toString() {
            return this.type;
        }

        static Type getType(String name) {
            return typesByName.get(name);
        }
    }
}

