/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.runtime.validation;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.ResultWithFailure;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xsemantics.runtime.validation.XsemanticsValidatorFilter;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class XsemanticsValidatorErrorGenerator {
    @Inject
    XsemanticsValidatorFilter filter;

    public void generateErrors(ValidationMessageAcceptor validationMessageAcceptor, ResultWithFailure resultWithFailure, EObject originalSource) {
        this.generateErrors(validationMessageAcceptor, resultWithFailure.getRuleFailedException(), originalSource);
    }

    protected void generateErrors(ValidationMessageAcceptor validationMessageAcceptor, RuleFailedException ruleFailedException, EObject originalSource) {
        if (ruleFailedException == null) {
            return;
        }
        Iterable<RuleFailedException> allFailures = this.filter.filterRuleFailedExceptions(ruleFailedException);
        ErrorInformation lastErrorInformationWithSource = null;
        for (RuleFailedException ruleFailedException2 : allFailures) {
            lastErrorInformationWithSource = this.generateErrors(validationMessageAcceptor, ruleFailedException2.getMessage(), ruleFailedException2.getIssue(), this.filter.filterErrorInformation(ruleFailedException2), lastErrorInformationWithSource, originalSource);
        }
    }

    protected ErrorInformation generateErrors(ValidationMessageAcceptor validationMessageAcceptor, String errorMessage, String issue, Iterable<ErrorInformation> filteredErrorInformation, ErrorInformation lastErrorInformationWithSource, EObject originalSource) {
        ErrorInformation errorInformationToReturn = lastErrorInformationWithSource;
        if (filteredErrorInformation.iterator().hasNext()) {
            for (ErrorInformation errorInformation : filteredErrorInformation) {
                this.error(validationMessageAcceptor, errorMessage, errorInformation.getSource(), errorInformation.getFeature(), issue, new String[0]);
                errorInformationToReturn = errorInformation;
            }
        } else if (lastErrorInformationWithSource != null) {
            this.error(validationMessageAcceptor, errorMessage, lastErrorInformationWithSource.getSource(), lastErrorInformationWithSource.getFeature(), issue, new String[0]);
        } else {
            this.error(validationMessageAcceptor, errorMessage, originalSource, null, issue, new String[0]);
        }
        return errorInformationToReturn;
    }

    protected void error(ValidationMessageAcceptor validationMessageAcceptor, String message, EObject source, EStructuralFeature feature, String code, String ... issueData) {
        validationMessageAcceptor.acceptError(message, source, feature, -1, code, issueData);
    }
}

