/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.http.HttpResponse;
import java.util.Set;
import org.eclipse.sw360.http.Response;

class NewResponseImpl<T extends Serializable>
implements Response {
    private static final InputStream EMPTY_STREAM = new ByteArrayInputStream(new byte[0]);
    private final HttpResponse response;

    NewResponseImpl(HttpResponse response) {
        this.response = response;
    }

    @Override
    public int statusCode() {
        return this.response.statusCode();
    }

    @Override
    public boolean isSuccess() {
        return String.valueOf(this.response.statusCode()).startsWith("2");
    }

    @Override
    public Set<String> headerNames() {
        return this.response.headers().map().keySet();
    }

    @Override
    public String header(String name) {
        return this.response.headers().firstValue(name).orElse("");
    }

    @Override
    public InputStream bodyStream() {
        String responseInString = this.response.body().toString();
        return responseInString.equals("") ? EMPTY_STREAM : new ByteArrayInputStream(responseInString.getBytes());
    }
}

