/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.function.Consumer;
import org.eclipse.sw360.http.NewRequestBodyBuilderImpl;
import org.eclipse.sw360.http.RequestBodyBuilder;
import org.eclipse.sw360.http.RequestBuilder;

class NewRequestBuilderImpl
implements RequestBuilder {
    private final ObjectMapper mapper;
    private final HttpRequest.Builder requestBuilder;
    private String httpMethod;
    private HttpRequest.BodyPublisher body;

    public NewRequestBuilderImpl(ObjectMapper mapper) {
        this.mapper = mapper;
        this.requestBuilder = HttpRequest.newBuilder();
        this.httpMethod = RequestBuilder.Method.GET.name();
    }

    @Override
    public RequestBuilder method(RequestBuilder.Method method) {
        this.httpMethod = method.name();
        return this;
    }

    @Override
    public RequestBuilder uri(String uri) {
        try {
            this.requestBuilder.uri(new URI(uri));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public RequestBuilder header(String name, String value) {
        this.requestBuilder.header(name, value);
        return this;
    }

    @Override
    public RequestBuilder body(Consumer<RequestBodyBuilder> bodyProducer) {
        if (this.getBody() != null) {
            throw new IllegalStateException("A request can only have a single body");
        }
        NewRequestBodyBuilderImpl bodyBuilder = new NewRequestBodyBuilderImpl(this.mapper);
        bodyProducer.accept(bodyBuilder);
        this.body = bodyBuilder.getBody();
        return this;
    }

    @Override
    public RequestBuilder multiPart(String name, Consumer<RequestBodyBuilder> partProducer) {
        if (this.getBody() != null) {
            throw new IllegalStateException("The request already has a normal body. You can either have a body or a multipart request, but not both.");
        }
        NewRequestBodyBuilderImpl bodyBuilder = new NewRequestBodyBuilderImpl(this.mapper);
        partProducer.accept(bodyBuilder);
        return this;
    }

    public HttpRequest build() {
        HttpRequest.BodyPublisher requestBody = this.getBody();
        return this.requestBuilder.method(this.httpMethod, requestBody).header("Content-Type", "application/json").build();
    }

    HttpRequest.BodyPublisher getBody() {
        return this.body;
    }
}

