/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.net.http.HttpRequest;
import java.nio.file.Path;
import org.eclipse.sw360.http.RequestBodyBuilder;

class NewRequestBodyBuilderImpl
implements RequestBodyBuilder {
    private final ObjectMapper mapper;
    private HttpRequest.BodyPublisher body;

    public NewRequestBodyBuilderImpl(ObjectMapper mapper) {
        this.mapper = mapper;
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
    }

    @Override
    public void string(String str, String mediaType) {
        this.initBody(HttpRequest.BodyPublishers.ofString(str));
    }

    @Override
    public void file(Path path, String mediaType) {
    }

    @Override
    public void json(Object payload) {
        try {
            this.string(this.mapper.writeValueAsString(payload), "application/json");
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public HttpRequest.BodyPublisher getBody() {
        if (this.body == null) {
            throw new IllegalStateException("A RequestBodyBuilder was requested, but no body was defined.");
        }
        return this.body;
    }

    private void initBody(HttpRequest.BodyPublisher b) {
        if (this.body != null) {
            throw new IllegalStateException("Multiple body definitions. Only a single request body can be defined using a RequestBodyBuilder.");
        }
        this.body = b;
    }
}

