/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.eclipse.sw360.http.HttpClient;
import org.eclipse.sw360.http.NewRequestBuilderImpl;
import org.eclipse.sw360.http.NewResponseImpl;
import org.eclipse.sw360.http.RequestBuilder;
import org.eclipse.sw360.http.ResponseProcessor;

public class NewHttpClientImpl
implements HttpClient {
    private final java.net.http.HttpClient client;
    private final ObjectMapper mapper;

    public NewHttpClientImpl(java.net.http.HttpClient client, ObjectMapper mapper) {
        this.client = client;
        this.mapper = mapper;
    }

    @Override
    public <T> CompletableFuture<T> execute(Consumer<? super RequestBuilder> producer, ResponseProcessor<? extends T> processor) {
        CompletableFuture<HttpResponse<String>> asyncResponse = null;
        CompletableFuture<T> resultFuture = new CompletableFuture<T>();
        NewRequestBuilderImpl builder = new NewRequestBuilderImpl(this.getMapper());
        producer.accept(builder);
        HttpRequest request = builder.build();
        asyncResponse = this.getClient().sendAsync(request, HttpResponse.BodyHandlers.ofString());
        try {
            HttpResponse<String> response = asyncResponse.get();
            T result = processor.process(new NewResponseImpl(response));
            resultFuture.complete(result);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            resultFuture.completeExceptionally(e);
        }
        return resultFuture;
    }

    ObjectMapper getMapper() {
        return this.mapper;
    }

    java.net.http.HttpClient getClient() {
        return this.client;
    }
}

