/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import okhttp3.OkHttpClient;
import org.eclipse.sw360.http.HttpClient;
import org.eclipse.sw360.http.HttpClientFactory;
import org.eclipse.sw360.http.HttpClientImpl;
import org.eclipse.sw360.http.NewHttpClientImpl;
import org.eclipse.sw360.http.config.HttpClientConfig;
import org.eclipse.sw360.http.config.ProxySettings;

public class HttpClientFactoryImpl
implements HttpClientFactory {
    static final String CLIENT_ACCESS_UNVERIFIED_PROPERTY = "client.access.unverified";

    @Override
    public HttpClient newHttpClient(HttpClientConfig config) {
        return new HttpClientImpl(HttpClientFactoryImpl.createClient(config), config.getOrCreateObjectMapper());
    }

    @Override
    public HttpClient newHttpClientAlt(HttpClientConfig config) {
        return new NewHttpClientImpl(HttpClientFactoryImpl.createClientAlt(config), config.getOrCreateObjectMapper());
    }

    private static OkHttpClient createClient(HttpClientConfig config) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (!config.proxySettings().isDefaultProxySelectorUse()) {
            Proxy proxy = config.proxySettings().isNoProxy() ? Proxy.NO_PROXY : HttpClientFactoryImpl.createProxy(config.proxySettings());
            builder.proxy(proxy);
        }
        if (HttpClientFactoryImpl.unverifiedSSLCertificate()) {
            builder.hostnameVerifier((s, sslSession) -> true);
        }
        return builder.build();
    }

    private static java.net.http.HttpClient createClientAlt(HttpClientConfig config) {
        java.net.http.HttpClient client = java.net.http.HttpClient.newHttpClient();
        return client;
    }

    private static boolean unverifiedSSLCertificate() {
        return Boolean.parseBoolean(System.getProperty(CLIENT_ACCESS_UNVERIFIED_PROPERTY));
    }

    private static Proxy createProxy(ProxySettings settings) {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(settings.getProxyHost(), settings.getProxyPort()));
    }
}

