/*
 * Copyright (c) Bosch.IO GmbH 2020.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.sw360.http;

import java.io.IOException;

/**
 * <p>
 * An interface for components that process the response of an HTTP request and
 * generate a result object.
 * </p>
 * <p>
 * An object implementing this interface must be passed to {@link HttpClient}
 * in order to execute a request. It is invoked when the response arrives. It
 * has full access to all response data. This information can be used to either
 * generate an arbitrary result object or fail with an appropriate exception.
 * </p>
 *
 * @param <T> the type of the result generated by this processor
 */
@FunctionalInterface
public interface ResponseProcessor<T> {
    /**
     * Processes the response of a request to produce a result.
     *
     * @param response the response to be processed
     * @return the result object to be propagated to the caller
     * @throws IOException if an I/O error occurs
     */
    T process(Response response) throws IOException;
}
