/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryPersistence;
import org.eclipse.serializer.persistence.binary.types.BinaryValueSetter;
import org.eclipse.serializer.persistence.binary.types.BinaryValueStorer;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;

public final class BinaryValueFunctions {
    private static final BinaryValueStorer STORE_byte = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_byte((long)trgAddress, (byte)XMemory.get_byte((Object)source, (long)srcOffset));
            return trgAddress + 1L;
        }
    };
    private static final BinaryValueStorer STORE_boolean = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_boolean((long)trgAddress, (boolean)XMemory.get_boolean((Object)source, (long)srcOffset));
            return trgAddress + 1L;
        }
    };
    private static final BinaryValueStorer STORE_short = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_short((long)trgAddress, (short)XMemory.get_short((Object)source, (long)srcOffset));
            return trgAddress + 2L;
        }
    };
    private static final BinaryValueStorer STORE_char = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_char((long)trgAddress, (char)XMemory.get_char((Object)source, (long)srcOffset));
            return trgAddress + 2L;
        }
    };
    private static final BinaryValueStorer STORE_int = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_int((long)trgAddress, (int)XMemory.get_int((Object)source, (long)srcOffset));
            return trgAddress + 4L;
        }
    };
    private static final BinaryValueStorer STORE_float = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_float((long)trgAddress, (float)XMemory.get_float((Object)source, (long)srcOffset));
            return trgAddress + 4L;
        }
    };
    private static final BinaryValueStorer STORE_long = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_long((long)trgAddress, (long)XMemory.get_long((Object)source, (long)srcOffset));
            return trgAddress + 8L;
        }
    };
    private static final BinaryValueStorer STORE_double = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_double((long)trgAddress, (double)XMemory.get_double((Object)source, (long)srcOffset));
            return trgAddress + 8L;
        }
    };
    private static final BinaryValueStorer STORE_REFERENCE = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_long((long)trgAddress, (long)handler.apply(XMemory.getObject((Object)source, (long)srcOffset)));
            return trgAddress + (long)Binary.objectIdByteLength();
        }
    };
    private static final BinaryValueStorer STORE_REFERENCE_EAGER = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_long((long)trgAddress, (long)handler.applyEager(XMemory.getObject((Object)source, (long)srcOffset)));
            return trgAddress + (long)Binary.objectIdByteLength();
        }
    };
    private static final BinaryValueStorer STORE_short_REVERSED = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_short((long)trgAddress, (short)Short.reverseBytes(XMemory.get_short((Object)source, (long)srcOffset)));
            return trgAddress + 2L;
        }
    };
    private static final BinaryValueStorer STORE_char_REVERSED = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_char((long)trgAddress, (char)Character.reverseBytes(XMemory.get_char((Object)source, (long)srcOffset)));
            return trgAddress + 2L;
        }
    };
    private static final BinaryValueStorer STORE_int_REVERSED = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_int((long)trgAddress, (int)Integer.reverseBytes(XMemory.get_int((Object)source, (long)srcOffset)));
            return trgAddress + 4L;
        }
    };
    private static final BinaryValueStorer STORE_float_REVERSED = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            int rawBits = Float.floatToRawIntBits(XMemory.get_float((Object)source, (long)srcOffset));
            int reversed = Integer.reverseBytes(rawBits);
            XMemory.set_int((long)trgAddress, (int)reversed);
            return trgAddress + 4L;
        }
    };
    private static final BinaryValueStorer STORE_long_REVERSED = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_long((long)trgAddress, (long)Long.reverseBytes(XMemory.get_long((Object)source, (long)srcOffset)));
            return trgAddress + 8L;
        }
    };
    private static final BinaryValueStorer STORE_double_REVERSED = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            long rawBits = Double.doubleToRawLongBits(XMemory.get_double((Object)source, (long)srcOffset));
            long reversed = Long.reverseBytes(rawBits);
            XMemory.set_long((long)trgAddress, (long)reversed);
            return trgAddress + 8L;
        }
    };
    private static final BinaryValueStorer STORE_REFERENCE_REVERSED = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_long((long)trgAddress, (long)Long.reverseBytes(handler.apply(XMemory.getObject((Object)source, (long)srcOffset))));
            return trgAddress + (long)Binary.objectIdByteLength();
        }
    };
    private static final BinaryValueStorer STORE_REFERENCE_EAGER_REVERSED = new BinaryValueStorer(){

        @Override
        public long storeValueFromMemory(Object source, long srcOffset, long trgAddress, PersistenceStoreHandler<Binary> handler) {
            XMemory.set_long((long)trgAddress, (long)Long.reverseBytes(handler.applyEager(XMemory.getObject((Object)source, (long)srcOffset))));
            return trgAddress + (long)Binary.objectIdByteLength();
        }
    };
    private static final BinaryValueSetter SETTER_byte = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_byte((Object)target, (long)trgOffset, (byte)XMemory.get_byte((long)srcAddress));
            return srcAddress + 1L;
        }
    };
    private static final BinaryValueSetter SETTER_boolean = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_boolean((Object)target, (long)trgOffset, (boolean)XMemory.get_boolean((long)srcAddress));
            return srcAddress + 1L;
        }
    };
    private static final BinaryValueSetter SETTER_char = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_char((Object)target, (long)trgOffset, (char)XMemory.get_char((long)srcAddress));
            return srcAddress + 2L;
        }
    };
    private static final BinaryValueSetter SETTER_short = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_short((Object)target, (long)trgOffset, (short)XMemory.get_short((long)srcAddress));
            return srcAddress + 2L;
        }
    };
    private static final BinaryValueSetter SETTER_int = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_int((Object)target, (long)trgOffset, (int)XMemory.get_int((long)srcAddress));
            return srcAddress + 4L;
        }
    };
    private static final BinaryValueSetter SETTER_float = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_float((Object)target, (long)trgOffset, (float)XMemory.get_float((long)srcAddress));
            return srcAddress + 4L;
        }
    };
    private static final BinaryValueSetter SETTER_long = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_long((Object)target, (long)trgOffset, (long)XMemory.get_long((long)srcAddress));
            return srcAddress + 8L;
        }
    };
    private static final BinaryValueSetter SETTER_double = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_double((Object)target, (long)trgOffset, (double)XMemory.get_double((long)srcAddress));
            return srcAddress + 8L;
        }
    };
    private static final BinaryValueSetter SETTER_REF = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.setObject((Object)target, (long)trgOffset, (Object)handler.lookupObject(XMemory.get_long((long)srcAddress)));
            return srcAddress + (long)Binary.objectIdByteLength();
        }
    };
    private static final BinaryValueSetter SETTER_short_REVERSED = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_short((Object)target, (long)trgOffset, (short)Short.reverseBytes(XMemory.get_short((long)srcAddress)));
            return srcAddress + 2L;
        }
    };
    private static final BinaryValueSetter SETTER_char_REVERSED = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_char((Object)target, (long)trgOffset, (char)Character.reverseBytes(XMemory.get_char((long)srcAddress)));
            return srcAddress + 2L;
        }
    };
    private static final BinaryValueSetter SETTER_int_REVERSED = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_int((Object)target, (long)trgOffset, (int)Integer.reverseBytes(XMemory.get_int((long)srcAddress)));
            return srcAddress + 4L;
        }
    };
    private static final BinaryValueSetter SETTER_float_REVERSED = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            int reversed = Integer.reverseBytes(XMemory.get_int((long)srcAddress));
            XMemory.set_float((Object)target, (long)trgOffset, (float)Float.intBitsToFloat(reversed));
            return srcAddress + 4L;
        }
    };
    private static final BinaryValueSetter SETTER_long_REVERSED = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.set_long((Object)target, (long)trgOffset, (long)Long.reverseBytes(XMemory.get_long((long)srcAddress)));
            return srcAddress + 8L;
        }
    };
    private static final BinaryValueSetter SETTER_double_REVERSED = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            long reversed = Long.reverseBytes(XMemory.get_long((long)srcAddress));
            XMemory.set_double((Object)target, (long)trgOffset, (double)Double.longBitsToDouble(reversed));
            return srcAddress + 8L;
        }
    };
    private static final BinaryValueSetter SETTER_REF_REVERSED = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            XMemory.setObject((Object)target, (long)trgOffset, (Object)handler.lookupObject(Long.reverseBytes(XMemory.get_long((long)srcAddress))));
            return srcAddress + (long)Binary.objectIdByteLength();
        }
    };
    private static final BinaryValueSetter SETTER_SKIP_1 = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            return srcAddress + 1L;
        }
    };
    private static final BinaryValueSetter SETTER_SKIP_2 = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            return srcAddress + 2L;
        }
    };
    private static final BinaryValueSetter SETTER_SKIP_4 = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            return srcAddress + 4L;
        }
    };
    private static final BinaryValueSetter SETTER_SKIP_8 = new BinaryValueSetter(){

        @Override
        public long setValueToMemory(long srcAddress, Object target, long trgOffset, PersistenceLoadHandler handler) {
            return srcAddress + 8L;
        }
    };

    public static BinaryValueStorer getObjectValueStorer(Class<?> type, boolean isEager, boolean switchByteOrder) throws IllegalArgumentException {
        if (switchByteOrder) {
            return BinaryValueFunctions.getObjectValueStorerReversed(type, isEager);
        }
        if (type.isPrimitive()) {
            if (type == Byte.TYPE) {
                return STORE_byte;
            }
            if (type == Boolean.TYPE) {
                return STORE_boolean;
            }
            if (type == Short.TYPE) {
                return STORE_short;
            }
            if (type == Character.TYPE) {
                return STORE_char;
            }
            if (type == Integer.TYPE) {
                return STORE_int;
            }
            if (type == Float.TYPE) {
                return STORE_float;
            }
            if (type == Long.TYPE) {
                return STORE_long;
            }
            if (type == Double.TYPE) {
                return STORE_double;
            }
            throw new IllegalArgumentException();
        }
        return isEager ? STORE_REFERENCE_EAGER : STORE_REFERENCE;
    }

    public static BinaryValueStorer getObjectValueStorerReversed(Class<?> type, boolean isEager) throws IllegalArgumentException {
        if (type.isPrimitive()) {
            if (type == Byte.TYPE) {
                return STORE_byte;
            }
            if (type == Boolean.TYPE) {
                return STORE_boolean;
            }
            if (type == Short.TYPE) {
                return STORE_short_REVERSED;
            }
            if (type == Character.TYPE) {
                return STORE_char_REVERSED;
            }
            if (type == Integer.TYPE) {
                return STORE_int_REVERSED;
            }
            if (type == Float.TYPE) {
                return STORE_float_REVERSED;
            }
            if (type == Long.TYPE) {
                return STORE_long_REVERSED;
            }
            if (type == Double.TYPE) {
                return STORE_double_REVERSED;
            }
            throw new IllegalArgumentException();
        }
        return isEager ? STORE_REFERENCE_EAGER_REVERSED : STORE_REFERENCE_REVERSED;
    }

    public static BinaryValueSetter getObjectValueSetter(Class<?> type, boolean switchByteOrder) {
        if (switchByteOrder) {
            return BinaryValueFunctions.getObjectValueSetterReversed(type);
        }
        if (type.isPrimitive()) {
            if (type == Byte.TYPE) {
                return SETTER_byte;
            }
            if (type == Boolean.TYPE) {
                return SETTER_boolean;
            }
            if (type == Short.TYPE) {
                return SETTER_short;
            }
            if (type == Character.TYPE) {
                return SETTER_char;
            }
            if (type == Integer.TYPE) {
                return SETTER_int;
            }
            if (type == Float.TYPE) {
                return SETTER_float;
            }
            if (type == Long.TYPE) {
                return SETTER_long;
            }
            if (type == Double.TYPE) {
                return SETTER_double;
            }
            throw new IllegalArgumentException();
        }
        return SETTER_REF;
    }

    public static BinaryValueSetter getObjectValueSetterReversed(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Byte.TYPE) {
                return SETTER_byte;
            }
            if (type == Boolean.TYPE) {
                return SETTER_boolean;
            }
            if (type == Short.TYPE) {
                return SETTER_short_REVERSED;
            }
            if (type == Character.TYPE) {
                return SETTER_char_REVERSED;
            }
            if (type == Integer.TYPE) {
                return SETTER_int_REVERSED;
            }
            if (type == Float.TYPE) {
                return SETTER_float_REVERSED;
            }
            if (type == Long.TYPE) {
                return SETTER_long_REVERSED;
            }
            if (type == Double.TYPE) {
                return SETTER_double_REVERSED;
            }
            throw new IllegalArgumentException();
        }
        return SETTER_REF_REVERSED;
    }

    public static BinaryValueSetter getObjectValueSettingSkipper(Class<?> type) {
        switch (BinaryPersistence.binaryValueSize(type)) {
            case 1: {
                return SETTER_SKIP_1;
            }
            case 2: {
                return SETTER_SKIP_2;
            }
            case 4: {
                return SETTER_SKIP_4;
            }
            case 8: {
                return SETTER_SKIP_8;
            }
        }
        throw new IllegalArgumentException();
    }

    private BinaryValueFunctions() {
        throw new UnsupportedOperationException();
    }
}

