/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.java.util;

import java.util.OptionalInt;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustomValueFixedLength;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerOptionalInt
extends AbstractBinaryHandlerCustomValueFixedLength<OptionalInt, Integer> {
    static final long BINARY_OFFSET_IS_PRESENT = 0L;
    static final long BINARY_OFFSET_VALUE = 1L;
    static final long BINARY_LENGTH = 5L;

    public static BinaryHandlerOptionalInt New() {
        return new BinaryHandlerOptionalInt();
    }

    BinaryHandlerOptionalInt() {
        super(OptionalInt.class, (XGettingSequence<? extends PersistenceTypeDefinitionMember>)BinaryHandlerOptionalInt.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerOptionalInt.CustomField(Boolean.TYPE, "isPresent"), BinaryHandlerOptionalInt.CustomField(Integer.TYPE, "value")}));
    }

    private static int instanceState(OptionalInt instance) {
        return instance.orElse(0);
    }

    private static int binaryState(Binary data) {
        return data.read_int(1L);
    }

    @Override
    public void store(Binary data, OptionalInt instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeEntityHeader(5L, this.typeId(), objectId);
        data.store_boolean(0L, instance.isPresent());
        data.store_int(1L, BinaryHandlerOptionalInt.instanceState(instance));
    }

    @Override
    public OptionalInt create(Binary data, PersistenceLoadHandler handler) {
        boolean isPresent = data.read_boolean(0L);
        return isPresent ? OptionalInt.of(data.read_int(1L)) : (OptionalInt)XMemory.instantiateBlank(OptionalInt.class);
    }

    @Override
    public Integer getValidationStateFromInstance(OptionalInt instance) {
        return BinaryHandlerOptionalInt.instanceState(instance);
    }

    @Override
    public Integer getValidationStateFromBinary(Binary data) {
        return BinaryHandlerOptionalInt.binaryState(data);
    }

    @Override
    public void validateState(Binary data, OptionalInt instance, PersistenceLoadHandler handler) {
        int binaryState;
        int instanceState = BinaryHandlerOptionalInt.instanceState(instance);
        if (instanceState == (binaryState = BinaryHandlerOptionalInt.binaryState(data))) {
            return;
        }
        this.throwInconsistentStateException(instance, instanceState, binaryState);
    }
}

