/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.EqConstHashEnum;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.HashEnum;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XImmutableEnum;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerReflective;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldHandlerProvider;
import org.eclipse.serializer.persistence.binary.types.BinaryValueFunctions;
import org.eclipse.serializer.persistence.binary.types.BinaryValueSetter;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceEagerStoringFieldEvaluator;
import org.eclipse.serializer.persistence.types.PersistenceFieldLengthResolver;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberEnumConstant;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldReflective;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.reflect.XReflect;
import org.eclipse.serializer.typing.XTypes;

public final class BinaryHandlerGenericEnum<T extends Enum<T>>
extends AbstractBinaryHandlerReflective<T> {
    private final long binaryOffsetName;
    private final long binaryOffsetOrdinal;
    private XImmutableEnum<PersistenceTypeDefinitionMemberEnumConstant> enumConstants;
    private final XImmutableEnum<PersistenceTypeDefinitionMember> allMembers = this.deriveAllMembers((XGettingSequence<? extends PersistenceTypeDefinitionMember>)this.instanceMembers());

    public static boolean isJavaLangEnumMember(PersistenceTypeDefinitionMember member) {
        return member != null && Enum.class.getName().equals(member.runtimeQualifier());
    }

    public static boolean isJavaLangEnumName(PersistenceTypeDefinitionMember member) {
        return BinaryHandlerGenericEnum.isJavaLangEnumMember(member) && member.type() == String.class;
    }

    public static boolean isJavaLangEnumOrdinal(PersistenceTypeDefinitionMember member) {
        return BinaryHandlerGenericEnum.isJavaLangEnumMember(member) && member.type() == Integer.TYPE;
    }

    public static long calculateBinaryOffsetOrdinal(PersistenceTypeDefinition typeDefinition) {
        return BinaryHandlerGenericEnum.calculateBinaryOffset((XGettingCollection<? extends PersistenceTypeDefinitionMember>)typeDefinition.instanceMembers(), BinaryHandlerGenericEnum::isJavaLangEnumOrdinal);
    }

    public static long calculateBinaryOffsetName(PersistenceTypeDefinition typeDefinition) {
        return BinaryHandlerGenericEnum.calculateBinaryOffset((XGettingCollection<? extends PersistenceTypeDefinitionMember>)typeDefinition.instanceMembers(), BinaryHandlerGenericEnum::isJavaLangEnumName);
    }

    public static long calculateBinaryOffset(XGettingCollection<? extends PersistenceTypeDefinitionMember> fields, Predicate<? super PersistenceTypeDefinitionMember> fieldSelector) {
        long binaryOffset = 0L;
        for (PersistenceTypeDefinitionMember f : fields) {
            if (fieldSelector.test((PersistenceTypeDefinitionMember)f)) {
                return binaryOffset;
            }
            binaryOffset += BinaryHandlerGenericEnum.equal(f.persistentMinimumLength(), f.persistentMaximumLength());
        }
        throw new PersistenceException("Member not found in member list.");
    }

    public static XImmutableEnum<PersistenceTypeDefinitionMemberEnumConstant> deriveEnumConstantMembers(Class<?> enumType) {
        XReflect.validateIsEnum(enumType);
        HashEnum enumConstants = HashEnum.New();
        ?[] enumConstantsArray = enumType.getEnumConstants();
        if (enumConstantsArray != null) {
            for (Object enumInstance : enumConstantsArray) {
                enumConstants.add((Object)PersistenceTypeDefinitionMemberEnumConstant.New((String)((Enum)enumInstance).name()));
            }
        }
        return enumConstants.immure();
    }

    public static <T extends Enum<T>> BinaryHandlerGenericEnum<T> New(Class<T> type, String typeName, XGettingEnum<Field> persistableFields, XGettingEnum<Field> persisterFields, PersistenceFieldLengthResolver lengthResolver, PersistenceEagerStoringFieldEvaluator eagerStoringFieldEvaluator, BinaryFieldHandlerProvider fieldHandlerProvider, boolean switchByteOrder) {
        return new BinaryHandlerGenericEnum<T>(type, typeName, persistableFields, persisterFields, lengthResolver, eagerStoringFieldEvaluator, fieldHandlerProvider, switchByteOrder);
    }

    protected BinaryHandlerGenericEnum(Class<T> type, String typeName, XGettingEnum<Field> persistableFields, XGettingEnum<Field> persisterFields, PersistenceFieldLengthResolver lengthResolver, PersistenceEagerStoringFieldEvaluator eagerStoringFieldEvaluator, BinaryFieldHandlerProvider fieldHandlerProvider, boolean switchByteOrder) {
        super(type, typeName, persistableFields, persisterFields, lengthResolver, eagerStoringFieldEvaluator, fieldHandlerProvider, switchByteOrder);
        this.binaryOffsetName = BinaryHandlerGenericEnum.calculateBinaryOffsetName((PersistenceTypeDefinition)this);
        this.binaryOffsetOrdinal = BinaryHandlerGenericEnum.calculateBinaryOffsetOrdinal((PersistenceTypeDefinition)this);
    }

    @Override
    protected BinaryValueSetter deriveSetter(PersistenceTypeDefinitionMemberFieldReflective member) {
        return this.isUnsettableField(member) ? BinaryValueFunctions.getObjectValueSettingSkipper(member.type()) : BinaryValueFunctions.getObjectValueSetter(member.type(), this.isSwitchedByteOrder());
    }

    @Override
    protected EqConstHashEnum<PersistenceTypeDefinitionMember> deriveAllMembers(XGettingSequence<? extends PersistenceTypeDefinitionMember> instanceMembers) {
        EqHashEnum allMembers = BinaryHandlerGenericEnum.MemberEnum().addAll(this.enumConstants()).addAll(instanceMembers);
        return allMembers.immure();
    }

    public XImmutableEnum<PersistenceTypeDefinitionMemberEnumConstant> enumConstants() {
        if (this.enumConstants == null) {
            this.enumConstants = BinaryHandlerGenericEnum.deriveEnumConstantMembers(this.type());
        }
        return this.enumConstants;
    }

    protected final boolean isUnsettableField(PersistenceTypeDefinitionMemberFieldReflective m) {
        return this.isJavaLangEnumField(m) || this.isFinalPrimitiveField(m) || this.isFinalValueTypeField(m);
    }

    protected final boolean isJavaLangEnumField(PersistenceTypeDefinitionMemberFieldReflective m) {
        if (m.declaringClass() != Enum.class) {
            return false;
        }
        if (BinaryHandlerGenericEnum.isJavaLangEnumName((PersistenceTypeDefinitionMember)m) || BinaryHandlerGenericEnum.isJavaLangEnumOrdinal((PersistenceTypeDefinitionMember)m)) {
            return true;
        }
        throw new PersistenceException("Unknown " + Enum.class.getName() + " field: " + m.name());
    }

    protected final boolean isFinalPrimitiveField(PersistenceTypeDefinitionMemberFieldReflective m) {
        return XReflect.isFinal((Member)m.field()) && m.field().getType().isPrimitive();
    }

    protected final boolean isFinalValueTypeField(PersistenceTypeDefinitionMemberFieldReflective m) {
        return XReflect.isFinal((Member)m.field()) && XTypes.isValueType(m.field().getType());
    }

    @Override
    public final XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
        return this.allMembers;
    }

    public Object[] collectEnumConstants() {
        return Persistence.collectEnumConstants((PersistenceTypeHandler)this);
    }

    @Override
    public final T create(Binary data, PersistenceLoadHandler handler) {
        return (T)((Enum)XReflect.resolveEnumConstantInstanceTyped((Class)this.type(), (int)this.getPersistedEnumOrdinal(data)));
    }

    public int getPersistedEnumOrdinal(Binary data) {
        return data.read_int(this.binaryOffsetOrdinal);
    }

    public String getName(Binary data, PersistenceLoadHandler handler) {
        return (String)data.readReference(this.binaryOffsetName, handler);
    }

    private void validate(Binary data, T instance, PersistenceLoadHandler handler) {
        int persistentOrdinal = this.getPersistedEnumOrdinal(data);
        if (persistentOrdinal != ((Enum)instance).ordinal()) {
            throw new PersistenceException("Inconcistency for " + ((Enum)instance).getDeclaringClass().getName() + "." + ((Enum)instance).name());
        }
        String persistentName = this.getName(data, handler);
        if (!((Enum)instance).name().equals(persistentName)) {
            throw new PersistenceException("Enum constant inconsistency: in type " + this.type().getName() + " persisted instance with ordinal " + persistentOrdinal + ", name \"" + persistentName + "\" does not match JVM-created instance with ordinal " + ((Enum)instance).ordinal() + ", name \"" + ((Enum)instance).name() + "\"");
        }
    }

    @Override
    public void updateState(Binary data, T instance, PersistenceLoadHandler handler) {
        this.validate(data, instance, handler);
        super.updateState(data, instance, handler);
    }
}

