/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.lang.reflect.Field;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldSetter;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldSetterCreator;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldStorer;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldStorerCreator;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldStorerThrowableStackTraceCreator;
import org.eclipse.serializer.persistence.binary.types.BinaryValueStorer;
import org.eclipse.serializer.util.logging.Logging;
import org.slf4j.Logger;

public interface BinaryFieldHandlerProvider {
    public void registerFieldStorerCreator(BinaryFieldStorerCreator<?> var1);

    public BinaryFieldStorerCreator<?> unregisterFieldStorerCreator(Field var1);

    public BinaryValueStorer lookupFieldStorer(Field var1, boolean var2, boolean var3);

    public void registerFieldSetterCreator(BinaryFieldSetterCreator<?> var1);

    public BinaryFieldSetterCreator<?> removeFieldSetterCreator(Field var1);

    public BinaryFieldSetter<?> lookupFieldSetter(Field var1, boolean var2);

    public static BinaryFieldHandlerProvider New() {
        return new Default();
    }

    public static class Default
    implements BinaryFieldHandlerProvider {
        private static final Logger logger = Logging.getLogger(BinaryFieldHandlerProvider.class);
        private final EqHashTable<Field, BinaryFieldStorerCreator<?>> fieldStorerCreators = EqHashTable.New();
        private final EqHashTable<Field, BinaryFieldSetterCreator<?>> fieldSetterCreators = EqHashTable.New();

        public Default() {
            this.registerFieldStorerCreator(new BinaryFieldStorerThrowableStackTraceCreator());
        }

        @Override
        public void registerFieldStorerCreator(BinaryFieldStorerCreator<?> fieldStorerCreator) {
            this.fieldStorerCreators.add((Object)fieldStorerCreator.getField(), fieldStorerCreator);
        }

        @Override
        public BinaryFieldStorerCreator<?> unregisterFieldStorerCreator(Field field) {
            return (BinaryFieldStorerCreator)this.fieldStorerCreators.removeFor((Object)field);
        }

        @Override
        public BinaryFieldStorer<?> lookupFieldStorer(Field field, boolean isEager, boolean switchByteOrder) {
            BinaryFieldStorerCreator storerCreator = (BinaryFieldStorerCreator)this.fieldStorerCreators.get((Object)field);
            if (storerCreator != null) {
                BinaryFieldStorer<?> storer = storerCreator.create(isEager, switchByteOrder);
                logger.debug("lookup custom field storer: " + field.getName() + " => " + (storer != null ? storer.getClass().getName() : "none"));
                return storer;
            }
            return null;
        }

        @Override
        public void registerFieldSetterCreator(BinaryFieldSetterCreator<?> fieldSetterCreator) {
            this.fieldSetterCreators.add((Object)fieldSetterCreator.getField(), fieldSetterCreator);
        }

        @Override
        public BinaryFieldSetterCreator<?> removeFieldSetterCreator(Field field) {
            return (BinaryFieldSetterCreator)this.fieldSetterCreators.removeFor((Object)field);
        }

        @Override
        public BinaryFieldSetter<?> lookupFieldSetter(Field field, boolean switchByteOrder) {
            BinaryFieldSetterCreator setterCreator = (BinaryFieldSetterCreator)this.fieldSetterCreators.get((Object)field);
            if (setterCreator != null) {
                BinaryFieldSetter<?> setter = setterCreator.create(switchByteOrder);
                logger.debug("lookup custom field setter: " + field.getName() + " => " + (setter != null ? setter.getClass().getName() : "none"));
                return setter;
            }
            return null;
        }
    }
}

