/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XImmutableEnum;
import org.eclipse.serializer.collections.types.XImmutableSequence;
import org.eclipse.serializer.collections.types.XList;
import org.eclipse.serializer.exceptions.NoSuchFieldRuntimeException;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryPersistence;
import org.eclipse.serializer.persistence.binary.types.BinaryTypeHandler;
import org.eclipse.serializer.persistence.binary.types.CustomBinaryHandler;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGenericComplex;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGenericSimple;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGenericVariableLength;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import org.eclipse.serializer.reflect.XReflect;
import org.eclipse.serializer.util.X;

public abstract class AbstractBinaryHandlerCustom<T>
extends BinaryTypeHandler.Abstract<T> {
    private XImmutableEnum<? extends PersistenceTypeDefinitionMember> members;
    private long binaryLengthMinimum;
    private long binaryLengthMaximum;
    private boolean hasPersistedReferences;
    private boolean hasVaryingPersistedLengthInstances;

    public static final XImmutableSequence<PersistenceTypeDefinitionMemberFieldGeneric> defineValueType(Class<?> valueType) {
        return X.Constant((Object)AbstractBinaryHandlerCustom.CustomField(valueType, "value"));
    }

    public static final PersistenceTypeDefinitionMemberFieldGenericSimple CustomField(Class<?> type, String name) {
        return AbstractBinaryHandlerCustom.CustomField(type, null, name);
    }

    public static final PersistenceTypeDefinitionMemberFieldGenericSimple CustomField(Class<?> type, String qualifier, String name) {
        return PersistenceTypeDefinitionMemberFieldGenericSimple.New((String)type.getName(), (String)qualifier, (String)name, type, (!type.isPrimitive() ? 1 : 0) != 0, (long)BinaryPersistence.resolveFieldBinaryLength(type), (long)BinaryPersistence.resolveFieldBinaryLength(type));
    }

    public static final PersistenceTypeDefinitionMemberFieldGeneric chars(String name) {
        return PersistenceTypeDefinitionMemberFieldGenericVariableLength.Chars((String)name, (long)Binary.binaryListMinimumLength(), (long)Binary.binaryListMaximumLength());
    }

    public static final PersistenceTypeDefinitionMemberFieldGeneric bytes(String name) {
        return PersistenceTypeDefinitionMemberFieldGenericVariableLength.Bytes((String)name, (long)Binary.binaryListMinimumLength(), (long)Binary.binaryListMaximumLength());
    }

    public static final XImmutableSequence<PersistenceTypeDefinitionMemberFieldGeneric> CustomFields(PersistenceTypeDefinitionMemberFieldGeneric ... customFields) {
        return X.ConstList((Object[])customFields);
    }

    public static final XImmutableSequence<PersistenceTypeDefinitionMemberFieldGeneric> CustomFields(PersistenceTypeDefinitionMemberFieldGeneric[] customFields, PersistenceTypeDefinitionMemberFieldGeneric[] additionalCustomFields) {
        if (additionalCustomFields == null) {
            return AbstractBinaryHandlerCustom.CustomFields(customFields);
        }
        return X.List((Object[])customFields).addAll((Object[])additionalCustomFields).immure();
    }

    public static final XImmutableSequence<PersistenceTypeDefinitionMemberFieldGeneric> CustomFields(PersistenceTypeDefinitionMemberFieldGeneric[] customFields, Iterable<? extends PersistenceTypeDefinitionMemberFieldGeneric> additionalCustomFields) {
        if (additionalCustomFields == null) {
            return AbstractBinaryHandlerCustom.CustomFields(customFields);
        }
        XList merged = X.List((Object[])customFields);
        for (PersistenceTypeDefinitionMemberFieldGeneric persistenceTypeDefinitionMemberFieldGeneric : additionalCustomFields) {
            merged.add((Object)persistenceTypeDefinitionMemberFieldGeneric);
        }
        return merged.immure();
    }

    public static final PersistenceTypeDefinitionMemberFieldGenericComplex Complex(String name, PersistenceTypeDescriptionMemberFieldGeneric ... customFields) {
        return PersistenceTypeDefinitionMemberFieldGenericComplex.New((String)name, (XGettingSequence)X.ConstList((Object[])customFields), (long)Binary.binaryListMinimumLength(), (long)Binary.binaryListMaximumLength());
    }

    public static final XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric> SizedArrayFields(PersistenceTypeDefinitionMemberFieldGeneric ... preHeaderFields) {
        return AbstractBinaryHandlerCustom.SimpleArrayFields((PersistenceTypeDefinitionMemberFieldGeneric[])XArrays.add((Object[])preHeaderFields, (Object)AbstractBinaryHandlerCustom.CustomField(Long.TYPE, "capacity")));
    }

    public static final XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric> SimpleArrayFields(PersistenceTypeDefinitionMemberFieldGeneric ... preHeaderFields) {
        return AbstractBinaryHandlerCustom.CustomFields((PersistenceTypeDefinitionMemberFieldGeneric[])XArrays.add((Object[])preHeaderFields, (Object)AbstractBinaryHandlerCustom.Complex("elements", new PersistenceTypeDescriptionMemberFieldGeneric[]{AbstractBinaryHandlerCustom.CustomField(Object.class, "element")})));
    }

    public static final XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric> keyValuesFields(PersistenceTypeDefinitionMemberFieldGeneric ... preHeaderFields) {
        return AbstractBinaryHandlerCustom.CustomFields((PersistenceTypeDefinitionMemberFieldGeneric[])XArrays.add((Object[])preHeaderFields, (Object)AbstractBinaryHandlerCustom.Complex("elements", new PersistenceTypeDescriptionMemberFieldGeneric[]{AbstractBinaryHandlerCustom.CustomField(Object.class, "key"), AbstractBinaryHandlerCustom.CustomField(Object.class, "value")})));
    }

    protected static final Field getInstanceFieldOfType(Class<?> declaringType, Class<?> fieldType) throws NoSuchFieldRuntimeException {
        return XReflect.setAccessible((Field)XReflect.getInstanceFieldOfType(declaringType, fieldType));
    }

    protected AbstractBinaryHandlerCustom(Class<T> type) {
        this(type, (XGettingSequence<PersistenceTypeDefinitionMember>)null);
    }

    protected AbstractBinaryHandlerCustom(Class<T> type, XGettingSequence<? extends PersistenceTypeDefinitionMember> members) {
        this(type, AbstractBinaryHandlerCustom.deriveTypeName(type), members);
    }

    protected AbstractBinaryHandlerCustom(Class<T> type, String typeName, XGettingSequence<? extends PersistenceTypeDefinitionMember> members) {
        super(type, typeName);
        this.initializeFields(members);
    }

    protected void initializeFields(XGettingSequence<? extends PersistenceTypeDefinitionMember> members) {
        if (members == null) {
            return;
        }
        this.members = AbstractBinaryHandlerCustom.validateAndImmure(members);
        this.hasPersistedReferences = PersistenceTypeDescriptionMember.determineHasReferences(members);
        this.hasVaryingPersistedLengthInstances = PersistenceTypeDefinition.determineVariableLength(members);
        this.calculcateBinaryLengths();
    }

    protected static boolean determineHasPersistedReferences(XGettingSequence<? extends PersistenceTypeDefinitionMember> members) {
        for (PersistenceTypeDefinitionMember member : members) {
            if (!member.hasReferences()) continue;
            return true;
        }
        return false;
    }

    protected static Field getClassDeclaredField(Class<?> declaringClass, String fieldName) {
        return XReflect.getDeclaredField(declaringClass, (String)fieldName);
    }

    protected static long getClassDeclaredFieldOffset(Class<?> declaringClass, String fieldName) {
        return XMemory.objectFieldOffset((Field)AbstractBinaryHandlerCustom.getClassDeclaredField(declaringClass, fieldName));
    }

    protected void calculcateBinaryLengths() {
        if (this.members == null) {
            return;
        }
        this.binaryLengthMinimum = PersistenceTypeDescriptionMember.calculatePersistentMinimumLength((long)0L, this.members);
        this.binaryLengthMaximum = PersistenceTypeDescriptionMember.calculatePersistentMaximumLength((long)0L, this.members);
    }

    public boolean hasPersistedReferences() {
        return this.hasPersistedReferences;
    }

    public boolean hasVaryingPersistedLengthInstances() {
        return this.hasVaryingPersistedLengthInstances;
    }

    public boolean isPrimitiveType() {
        return false;
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
        return this.instanceMembers();
    }

    public synchronized XGettingEnum<? extends PersistenceTypeDefinitionMember> instanceMembers() {
        this.ensureInitializeInstanceMembers();
        return this.members;
    }

    protected final void ensureInitializeInstanceMembers() {
        if (this.members != null) {
            return;
        }
        this.initializeFields(this.initializeInstanceMembers());
    }

    protected XGettingSequence<? extends PersistenceTypeDefinitionMember> initializeInstanceMembers() {
        throw new PersistenceException("type definition members may not be null for non-" + CustomBinaryHandler.class.getSimpleName() + "-implementations");
    }

    public long membersPersistedLengthMinimum() {
        return this.binaryLengthMinimum;
    }

    public long membersPersistedLengthMaximum() {
        return this.binaryLengthMaximum;
    }

    public abstract void store(Binary var1, T var2, long var3, PersistenceStoreHandler<Binary> var5);

    public void iterateInstanceReferences(T instance, PersistenceFunction iterator) {
    }

    public abstract T create(Binary var1, PersistenceLoadHandler var2);

    public void complete(Binary data, T instance, PersistenceLoadHandler handler) {
    }

    public <C extends Consumer<? super Class<?>>> C iterateMemberTypes(C logic) {
        return logic;
    }
}

