/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.persistence.binary.exceptions.BinaryPersistenceException;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustom;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceObjectRegistry;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceRootReference;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerRootReferenceDefault
extends AbstractBinaryHandlerCustom<PersistenceRootReference.Default> {
    final PersistenceRootReference.Default rootReference;
    final PersistenceObjectRegistry globalRegistry;

    BinaryHandlerRootReferenceDefault(PersistenceRootReference.Default rootReference, PersistenceObjectRegistry globalRegistry) {
        super(PersistenceRootReference.Default.class, (XGettingSequence<? extends PersistenceTypeDefinitionMember>)BinaryHandlerRootReferenceDefault.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerRootReferenceDefault.CustomField(Object.class, "root")}));
        this.rootReference = rootReference;
        this.globalRegistry = globalRegistry;
    }

    @Override
    public final boolean hasVaryingPersistedLengthInstances() {
        return false;
    }

    @Override
    public final boolean hasPersistedReferences() {
        return true;
    }

    public final boolean hasPersistedVariableLength() {
        return false;
    }

    static long getRootObjectId(Binary data) {
        return data.read_long(0L);
    }

    @Override
    public final void store(Binary data, PersistenceRootReference.Default instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        Object rootInstance = instance.get();
        long contentLength = Binary.objectIdByteLength();
        long rootObjectId = handler.apply(rootInstance);
        data.storeEntityHeader(contentLength, this.typeId(), objectId);
        data.store_long(rootObjectId);
    }

    @Override
    public final PersistenceRootReference.Default create(Binary data, PersistenceLoadHandler handler) {
        Object rootInstance = this.rootReference.get();
        if (rootInstance != null) {
            long rootObjectId = BinaryHandlerRootReferenceDefault.getRootObjectId(data);
            handler.requireRoot(rootInstance, rootObjectId);
        }
        return this.rootReference;
    }

    public final void updateState(Binary data, PersistenceRootReference.Default instance, PersistenceLoadHandler handler) {
        if (instance != this.rootReference) {
            throw new BinaryPersistenceException("Initialized root reference and loaded root reference are not the same: initialized = " + XChars.systemString((Object)this.rootReference) + " <-> loaded = " + XChars.systemString((Object)instance));
        }
        long rootObjectId = BinaryHandlerRootReferenceDefault.getRootObjectId(data);
        Object loadedRoot = handler.lookupObject(rootObjectId);
        Object rootInstance = this.rootReference.get();
        if (rootInstance == null) {
            this.rootReference.setRoot(loadedRoot);
            return;
        }
        if (rootInstance == loadedRoot) {
            return;
        }
        throw new BinaryPersistenceException("Initialized root instance and loaded root instance are not the same: initialized = " + XChars.systemString((Object)rootInstance) + " <-> loaded = " + XChars.systemString((Object)loadedRoot));
    }

    @Override
    public final void iterateInstanceReferences(PersistenceRootReference.Default instance, PersistenceFunction iterator) {
        instance.iterate(iterator);
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        long rootObjectId = BinaryHandlerRootReferenceDefault.getRootObjectId(data);
        iterator.requireReferenceEager(rootObjectId);
    }
}

