/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.java.lang;

import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustomValueFixedLength;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;

public final class BinaryHandlerDouble
extends AbstractBinaryHandlerCustomValueFixedLength<Double, Double> {
    public static BinaryHandlerDouble New() {
        return new BinaryHandlerDouble();
    }

    BinaryHandlerDouble() {
        super(Double.class, (XGettingSequence<? extends PersistenceTypeDefinitionMember>)BinaryHandlerDouble.defineValueType(Double.TYPE));
    }

    private static double instanceState(Double instance) {
        return instance;
    }

    private static double binaryState(Binary data) {
        return data.read_double(0L);
    }

    @Override
    public void store(Binary data, Double instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeDouble(this.typeId(), objectId, instance);
    }

    @Override
    public Double create(Binary data, PersistenceLoadHandler handler) {
        return data.buildDouble();
    }

    @Override
    public Double getValidationStateFromInstance(Double instance) {
        return instance;
    }

    @Override
    public Double getValidationStateFromBinary(Binary data) {
        return BinaryHandlerDouble.binaryState(data);
    }

    @Override
    public void validateState(Binary data, Double instance, PersistenceLoadHandler handler) {
        double binaryState;
        double instanceState = BinaryHandlerDouble.instanceState(instance);
        if (instanceState == (binaryState = BinaryHandlerDouble.binaryState(data))) {
            return;
        }
        this.throwInconsistentStateException(instance, instanceState, binaryState);
    }
}

