/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.types.XAddingMap;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.exceptions.BinaryPersistenceException;
import org.eclipse.serializer.persistence.binary.exceptions.BinaryPersistenceExceptionInvalidList;
import org.eclipse.serializer.persistence.binary.exceptions.BinaryPersistenceExceptionInvalidListElements;
import org.eclipse.serializer.persistence.binary.exceptions.BinaryPersistenceExceptionStateArrayLength;
import org.eclipse.serializer.persistence.binary.types.BinaryElementReader;
import org.eclipse.serializer.persistence.binary.types.BinaryEntityDataReader;
import org.eclipse.serializer.persistence.binary.types.BinaryField;
import org.eclipse.serializer.persistence.binary.types.BinaryReferenceTraverser;
import org.eclipse.serializer.persistence.binary.types.BinaryTypeHandler;
import org.eclipse.serializer.persistence.binary.types.BinaryValueSetter;
import org.eclipse.serializer.persistence.binary.types.BinaryValueStorer;
import org.eclipse.serializer.persistence.binary.types.Chunk;
import org.eclipse.serializer.persistence.binary.types.CustomBinaryHandler;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeInstantiator;
import org.eclipse.serializer.reference.Swizzling;
import org.eclipse.serializer.reflect.Getter;
import org.eclipse.serializer.reflect.Getter_boolean;
import org.eclipse.serializer.reflect.Getter_byte;
import org.eclipse.serializer.reflect.Getter_char;
import org.eclipse.serializer.reflect.Getter_double;
import org.eclipse.serializer.reflect.Getter_float;
import org.eclipse.serializer.reflect.Getter_int;
import org.eclipse.serializer.reflect.Getter_long;
import org.eclipse.serializer.reflect.Getter_short;
import org.eclipse.serializer.reflect.Setter;
import org.eclipse.serializer.reflect.Setter_boolean;
import org.eclipse.serializer.reflect.Setter_byte;
import org.eclipse.serializer.reflect.Setter_char;
import org.eclipse.serializer.reflect.Setter_double;
import org.eclipse.serializer.reflect.Setter_float;
import org.eclipse.serializer.reflect.Setter_int;
import org.eclipse.serializer.reflect.Setter_long;
import org.eclipse.serializer.reflect.Setter_short;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;

public abstract class Binary
implements Chunk {
    private static final int LENGTH_LEN = 8;
    private static final int LENGTH_OID = 8;
    private static final int LENGTH_TID = 8;
    private static final long OFFSET_LEN = 0L;
    private static final long OFFSET_TID = 8L;
    private static final long OFFSET_OID = 16L;
    private static final long OFFSET_DAT = 24L;
    private static final int LENGTH_ENTITY_HEADER = 24;
    private static final int LIST_OFFSET_BYTE_LENGTH = 0;
    private static final int LIST_OFFSET_ELEMENT_COUNT = 8;
    private static final int LIST_OFFSET_ELEMENTS = 16;
    private static final int LIST_HEADER_LENGTH = 16;
    private static final long SIZED_ARRAY_OFFSET_LENGTH = 0L;
    private static final long SIZED_ARRAY_LENGTH_HEADER = 8L;
    private static final long SIZED_ARRAY_OFFSET_ELEMENTS = 8L;
    private static final long KEY_VALUE_REFERENCE_COUNT = 2L;
    private static final long KEY_VALUE_BINARY_LENGTH = 16L;
    long address;
    private HelperEntry helperEntry;
    private static final long OFFSET_ROOTS_OID_LIST = 0L;

    public static long keyValueReferenceCount(long elementCount) {
        return 2L * elementCount;
    }

    public static long keyValueBinaryLength() {
        return 16L;
    }

    public static long binaryListMinimumLength() {
        return 16L;
    }

    public static long binaryListMaximumLength() {
        return Long.MAX_VALUE;
    }

    public static long toBinaryListTotalByteLength(long binaryListElementsByteLength) {
        return binaryListElementsByteLength + 16L;
    }

    public static long toBinaryListContentByteLength(long binaryListTotalByteLength) {
        return binaryListTotalByteLength - 16L;
    }

    public static int lengthLength() {
        return 8;
    }

    public static boolean isValidGapLength(long gapLength) {
        System.out.println();
        return gapLength >= 8L;
    }

    public static boolean isValidEntityLength(long entityLength) {
        return entityLength >= 24L;
    }

    public static int entityHeaderLength() {
        return 24;
    }

    public static long entityTotalLength(long entityContentLength) {
        return entityContentLength + 24L;
    }

    public static long entityContentLength(long entityTotalLength) {
        return entityTotalLength - 24L;
    }

    public static long toEntityContentOffset(long entityOffset) {
        return entityOffset + 24L;
    }

    public static final long toBinaryListByteLengthOffset(long binaryListOffset) {
        return binaryListOffset + 0L;
    }

    public static final long toBinaryListElementCountOffset(long binaryListOffset) {
        return binaryListOffset + 8L;
    }

    public static long toBinaryListElementsOffset(long binaryListOffset) {
        return binaryListOffset + 16L;
    }

    public static int objectIdByteLength() {
        return 8;
    }

    public static long referenceBinaryLength(long referenceCount) {
        return referenceCount * 8L;
    }

    public static long calculateReferenceListTotalBinaryLength(long count) {
        return Binary.toBinaryListTotalByteLength(Binary.referenceBinaryLength(count));
    }

    public static long calculateStringListContentBinaryLength(String[] strings) {
        long listContentBinaryLength = 0L;
        for (String string : strings) {
            listContentBinaryLength += Binary.calculateBinaryLengthChars(string.length());
        }
        return listContentBinaryLength;
    }

    public static long calculateBinaryLengthChars(long count) {
        return Binary.toBinaryListTotalByteLength(count << 1);
    }

    public static final long getEntityLengthRawValue(long entityAddress) {
        return XMemory.get_long((long)(entityAddress + 0L));
    }

    public static final long getEntityTypeIdRawValue(long entityAddress) {
        return XMemory.get_long((long)(entityAddress + 8L));
    }

    public static final long getEntityObjectIdRawValue(long entityAddress) {
        return XMemory.get_long((long)(entityAddress + 16L));
    }

    static final long entityAddressFromContentAddress(long entityContentAddress) {
        return entityContentAddress - 24L;
    }

    static final void setEntityHeaderRawValuesToAddress(long entityAddress, long entityTotalLength, long entityTypeId, long entityObjectId) {
        XMemory.set_long((long)(entityAddress + 0L), (long)entityTotalLength);
        XMemory.set_long((long)(entityAddress + 8L), (long)entityTypeId);
        XMemory.set_long((long)(entityAddress + 16L), (long)entityObjectId);
    }

    Binary() {
    }

    @Override
    public abstract ByteBuffer[] buffers();

    public boolean isSwitchedByteOrder() {
        return false;
    }

    public final long getBuildItemTotalLength() {
        return this.isSkipItem() ? -1L : this.internalBuildItemTotalLength();
    }

    public final long getBuildItemContentLength() {
        return this.isSkipItem() ? -1L : this.internalBuildItemTotalLength() - 24L;
    }

    private long internalBuildItemTotalLength() {
        return this.get_longFromAddress(this.loadItemEntityAddress() + 0L);
    }

    public final long getBuildItemTypeId() {
        return this.isSkipItem() ? Swizzling.notFoundId() : this.get_longFromAddress(this.loadItemEntityAddress() + 8L);
    }

    public final long getBuildItemObjectId() {
        return this.isSkipItem() ? -this.loadItemEntityContentAddress() : this.get_longFromAddress(this.loadItemEntityAddress() + 16L);
    }

    public abstract long storeEntityHeader(long var1, long var3, long var5);

    public final long getListElementCountKeyValue(long listStartOffset) {
        return this.getBinaryListElementCountValidating(listStartOffset, Binary.keyValueBinaryLength());
    }

    public final byte read_byte(long offset) {
        return this.get_byteFromAddress(this.loadItemEntityContentAddress() + offset);
    }

    public final boolean read_boolean(long offset) {
        return this.get_booleanFromAddress(this.loadItemEntityContentAddress() + offset);
    }

    public final short read_short(long offset) {
        return this.get_shortfromAddress(this.loadItemEntityContentAddress() + offset);
    }

    public final char read_char(long offset) {
        return this.get_charFromAddress(this.loadItemEntityContentAddress() + offset);
    }

    public final int read_int(long offset) {
        return this.get_intFromAddress(this.loadItemEntityContentAddress() + offset);
    }

    public final float read_float(long offset) {
        return this.get_floatFromAddress(this.loadItemEntityContentAddress() + offset);
    }

    public final long read_long(long offset) {
        return this.get_longFromAddress(this.loadItemEntityContentAddress() + offset);
    }

    public final long readObjectId(long offset) {
        return this.get_longFromAddress(this.loadItemEntityContentAddress() + offset);
    }

    public final double read_double(long offset) {
        return this.get_doubleFromAddress(this.loadItemEntityContentAddress() + offset);
    }

    public final Object readReference(long offset, PersistenceLoadHandler loadHandler) {
        return loadHandler.lookupObject(this.get_longFromAddress(this.loadItemEntityContentAddress() + offset));
    }

    public abstract Binary channelChunk(int var1);

    public abstract int channelCount();

    public abstract void iterateChannelChunks(Consumer<? super Binary> var1);

    public abstract void iterateEntityData(BinaryEntityDataReader var1);

    public final void storeKeyValuesAsEntries(long typeId, long objectId, long headerOffset, Iterable<? extends KeyValue<?, ?>> keyValues, long size, PersistenceFunction persister) {
        this.storeEntityHeader(headerOffset + Binary.calculateReferenceListTotalBinaryLength(Binary.keyValueReferenceCount(size)), typeId, objectId);
        this.storeKeyValuesAsEntries(headerOffset, persister, keyValues, size);
    }

    public final <K, V> void storeMapEntrySet(long typeId, long objectId, long headerOffset, Set<Map.Entry<K, V>> entrySet, PersistenceFunction persister) {
        long a;
        int size = entrySet.size();
        this.storeEntityHeader(headerOffset + Binary.calculateReferenceListTotalBinaryLength(Binary.keyValueReferenceCount(size)), typeId, objectId);
        long referenceLength = Binary.referenceBinaryLength(1L);
        long entryLength = Binary.referenceBinaryLength(2L);
        long elementsBinaryRange = (long)size * entryLength;
        long elementsDataAddress = this.address + headerOffset + 16L;
        long elementsBinaryBound = elementsDataAddress + elementsBinaryRange;
        this.storeListHeader(headerOffset, elementsBinaryRange, size);
        Iterator<Map.Entry<K, V>> iterator = entrySet.iterator();
        for (a = elementsDataAddress; a < elementsBinaryBound && iterator.hasNext(); a += entryLength) {
            Map.Entry<K, V> element = iterator.next();
            this.set_longToAddress(a, persister.apply(element.getKey()));
            this.set_longToAddress(a + referenceLength, persister.apply(element.getValue()));
        }
        Binary.validatePostIterationState(a, elementsBinaryBound, iterator, size, entryLength);
    }

    public final void storeSizedArray(long tid, long oid, long headerOffset, Object[] array, int size, PersistenceFunction persister) {
        this.storeSizedArray(tid, oid, headerOffset, array, 0, size, persister);
    }

    public final void storeSizedArray(long tid, long oid, long headerOffset, Object[] array, int offset, int size, PersistenceFunction persister) {
        this.storeEntityHeader(headerOffset + 8L + Binary.calculateReferenceListTotalBinaryLength(size), tid, oid);
        this.store_long(headerOffset + 0L, array.length);
        this.storeReferencesAsList(headerOffset + 8L, persister, array, offset, size);
    }

    public final void storeRoots(long typeId, long objectId, XGettingTable<String, Object> entries, PersistenceFunction persister) {
        String[] identifiers = (String[])entries.keys().toArray(String.class);
        Object[] instances = entries.values().toArray();
        int instanceCount = instances.length;
        long instancesTotalBinLength = Binary.calculateReferenceListTotalBinaryLength(instanceCount);
        long identifiersContentBinLength = Binary.calculateStringListContentBinaryLength(identifiers);
        long totalContentLength = instancesTotalBinLength + Binary.toBinaryListTotalByteLength(identifiersContentBinLength);
        this.storeEntityHeader(totalContentLength, typeId, objectId);
        this.storeReferencesAsList(0L, persister, instances, 0, instanceCount);
        this.storeStringsAsList(instancesTotalBinLength, identifiersContentBinLength, identifiers);
    }

    public final <T extends XAddingMap<String, Long>> T buildRootMapping(T mapping) {
        long oidListBinaryLength;
        long identifiersBinaryOffset;
        String[] identifiers;
        long[] objectIds = this.build_longs(0L);
        if (objectIds.length != (identifiers = this.buildStrings(identifiersBinaryOffset = 0L + (oidListBinaryLength = Binary.toBinaryListTotalByteLength(objectIds.length * 8)))).length) {
            throw new BinaryPersistenceException("Amount mismatch between object ids and identifiers, " + objectIds.length + " != " + identifiers.length);
        }
        EqHashEnum objectIdUniquenessChecker = EqHashEnum.New();
        for (int i = 0; i < objectIds.length; ++i) {
            if (!objectIdUniquenessChecker.add((Object)objectIds[i])) {
                throw new BinaryPersistenceException("Persisted root entries have a duplicate root objectId for entry (" + identifiers[i] + " -> " + objectIds[i] + ")");
            }
            if (mapping.add((Object)identifiers[i], (Object)objectIds[i])) continue;
            throw new BinaryPersistenceException("Persisted root entries have a duplicate root identifiers for entry (" + identifiers[i] + " -> " + objectIds[i] + ")");
        }
        return mapping;
    }

    public final void storeIterableAsList(long tid, long oid, long headerOffset, Iterable<?> elements, long size, PersistenceFunction persister) {
        this.storeEntityHeader(headerOffset + Binary.calculateReferenceListTotalBinaryLength(size), tid, oid);
        this.storeIterableContentAsList(headerOffset, persister, elements, size);
    }

    public int getSizedArrayElementCount(long headerOffset) {
        return X.checkArrayRange((long)this.getBinaryListElementCountValidating(headerOffset + 8L, 8L));
    }

    public final int getSizedArrayLength(long sizedArrayOffset) {
        return X.checkArrayRange((long)this.get_longFromAddress(this.loadItemEntityContentAddress() + sizedArrayOffset + 0L));
    }

    public final long getSizedArrayElementsAddress(long headerOffset) {
        return this.binaryListElementsAddress(headerOffset + 8L);
    }

    public final void validateArrayLength(Object[] array, long headerOffset) {
        if ((long)array.length == this.getListElementCountReferences(headerOffset)) {
            return;
        }
        throw new BinaryPersistenceExceptionStateArrayLength(array, X.checkArrayRange((long)this.getListElementCountReferences(headerOffset)));
    }

    public final long getBinaryListTotalByteLength(long listOffset) {
        long listTotalByteLength = this.get_longFromAddress(this.loadItemEntityContentAddress() + listOffset);
        if (this.loadItemEntityContentAddress() + listOffset + listTotalByteLength > this.getEntityBoundAddress()) {
            throw new BinaryPersistenceExceptionInvalidList(this.getBuildItemTotalLength(), this.getBuildItemObjectId(), this.getBuildItemTypeId(), listOffset, listTotalByteLength);
        }
        return listTotalByteLength;
    }

    public final long getLoadItemAvailableContentLength() {
        return Binary.entityContentLength(this.get_longFromAddress(this.loadItemEntityAddress() + 0L));
    }

    public final long getBinaryListElementCountValidating(long listOffset, long elementLength) {
        long listTotalByteLength = this.getBinaryListTotalByteLength(listOffset);
        long listElementCount = this.getBinaryListElementCountUnvalidating(listOffset);
        if (!this.isValidLoadItemContentLength(listOffset + listTotalByteLength) || Binary.toBinaryListTotalByteLength(listElementCount * elementLength) != listTotalByteLength) {
            throw new BinaryPersistenceExceptionInvalidListElements(this.getBuildItemTotalLength(), this.getBuildItemObjectId(), this.getBuildItemTypeId(), listOffset, listTotalByteLength, listElementCount, elementLength);
        }
        return listElementCount;
    }

    public final long getBinaryListElementCountUnvalidating(long listOffset) {
        return this.get_longFromAddress(this.loadItemEntityContentAddress() + Binary.toBinaryListElementCountOffset(listOffset));
    }

    public final long getListElementCount(long listStartOffset, int elementLength) {
        return this.getBinaryListElementCountValidating(listStartOffset, elementLength);
    }

    public final long getListElementCountReferences(long listStartOffset) {
        return this.getBinaryListElementCountValidating(listStartOffset, 8L);
    }

    public final long iterateListStructureElements(long listOffset, BinaryElementReader reader) {
        long listElementCount = this.getBinaryListElementCountUnvalidating(listOffset);
        if (listElementCount == 0L) {
            return 0L;
        }
        long listTotalByteLength = this.getBinaryListTotalByteLength(listOffset);
        long listContentLength = Binary.toBinaryListContentByteLength(listTotalByteLength);
        long bytesPerElement = listContentLength / listElementCount;
        if (bytesPerElement * listElementCount != listContentLength) {
            throw new BinaryPersistenceException("Non-constant binary list element length.");
        }
        long startAddress = this.binaryListElementsAddress(listOffset);
        long boundAddress = startAddress + listContentLength;
        for (long address = startAddress; address < boundAddress; address += bytesPerElement) {
            reader.readElement(this, address);
        }
        return listElementCount;
    }

    public final void iterateListElementReferences(long listOffset, PersistenceObjectIdAcceptor iterator) {
        this.iterateListStructureReferenceRange(listOffset, 1, iterator);
    }

    public final void iterateSizedArrayElementReferences(long offset, PersistenceObjectIdAcceptor iterator) {
        this.iterateListStructureReferenceRange(offset + 8L, 1, iterator);
    }

    public final void iterateListStructureReferenceRange(long listOffset, int referencesPerElement, PersistenceObjectIdAcceptor iterator) {
        long elementCount = this.getBinaryListElementCountValidating(listOffset, referencesPerElement * 8);
        long elementsStartOffset = Binary.toBinaryListElementsOffset(listOffset);
        long elementsBoundOffset = elementsStartOffset + elementCount * (long)referencesPerElement * 8L;
        this.iterateReferenceRangeUnvalidated(elementsStartOffset, elementsBoundOffset, iterator);
    }

    public static void iterateListStructureCompositeElements(Binary data, long elementsListOffset, int elementReferencesOffset, int elementReferenceCount, int elementTrailingBytes, PersistenceReferenceLoader iterator) {
        long elementLength = (long)elementReferencesOffset + Binary.referenceBinaryLength(elementReferenceCount) + (long)elementTrailingBytes;
        long elementCount = data.getBinaryListElementCountValidating(elementsListOffset, elementLength);
        long elementsStartOffset = Binary.toBinaryListElementsOffset(elementsListOffset);
        long elementsBoundOffset = elementsStartOffset + elementCount * elementLength;
        long startAddress = data.loadItemEntityContentAddress() + elementsStartOffset;
        long boundAddress = data.loadItemEntityContentAddress() + elementsBoundOffset;
        for (long address = startAddress; address < boundAddress; address += elementLength) {
            long referencesStartAddress = address + (long)elementReferencesOffset;
            for (int r = 0; r < elementReferenceCount; ++r) {
                long referenceAddress = referencesStartAddress + Binary.referenceBinaryLength(r);
                iterator.acceptObjectId(data.get_longFromAddress(referenceAddress));
            }
        }
    }

    public final void iterateKeyValueEntriesReferences(long listOffset, PersistenceObjectIdAcceptor iterator) {
        this.iterateListStructureReferenceRange(listOffset, 2, iterator);
    }

    public final void iterateReferenceRange(long startOffset, long boundOffset, PersistenceObjectIdAcceptor iterator) {
        this.iterateReferenceRangeUnvalidated(startOffset, boundOffset, iterator);
    }

    public final void iterateReferenceRangeUnvalidated(long startOffset, long boundOffset, PersistenceObjectIdAcceptor iterator) {
        long startAddress = this.loadItemEntityContentAddress() + startOffset;
        long boundAddress = this.loadItemEntityContentAddress() + boundOffset;
        for (long address = startAddress; address < boundAddress; address += 8L) {
            iterator.acceptObjectId(this.get_longFromAddress(address));
        }
    }

    public final void store_bytes(long typeId, long objectId, byte[] array) {
        long totalByteLength = Binary.toBinaryListTotalByteLength(array.length);
        this.storeEntityHeader(totalByteLength, typeId, objectId);
        this.store_long(0L, totalByteLength);
        this.store_long(8L, array.length);
        this.store_bytesToAddress(Binary.toBinaryListElementsOffset(this.address), array);
    }

    public final void store_bytes(byte[] array, long offset) {
        long totalByteLength = Binary.toBinaryListTotalByteLength(array.length);
        this.store_long(offset + 0L, totalByteLength);
        this.store_long(offset + 8L, array.length);
        this.store_bytesToAddress(Binary.toBinaryListElementsOffset(offset + this.address), array);
    }

    public final void store_booleans(long typeId, long objectId, boolean[] array) {
        long totalByteLength = Binary.toBinaryListTotalByteLength(array.length);
        this.storeEntityHeader(totalByteLength, typeId, objectId);
        this.store_long(0L, totalByteLength);
        this.store_long(8L, array.length);
        this.store_booleansToAddress(Binary.toBinaryListElementsOffset(this.address), array);
    }

    public final void store_booleans(boolean[] array, long offset) {
        long totalByteLength = Binary.toBinaryListTotalByteLength(array.length);
        this.store_long(offset + 0L, totalByteLength);
        this.store_long(offset + 8L, array.length);
        this.store_booleansToAddress(Binary.toBinaryListElementsOffset(offset + this.address), array);
    }

    public final void store_shorts(long typeId, long objectId, short[] array) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 2L);
        this.storeEntityHeader(totalByteLength, typeId, objectId);
        this.store_long(0L, totalByteLength);
        this.store_long(8L, array.length);
        this.store_shortsToAddress(Binary.toBinaryListElementsOffset(this.address), array);
    }

    public final void store_shorts(short[] array, long offset) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 2L);
        this.store_long(offset + 0L, totalByteLength);
        this.store_long(offset + 8L, array.length);
        this.store_shortsToAddress(Binary.toBinaryListElementsOffset(offset + this.address), array);
    }

    public final void store_chars(long typeId, long objectId, char[] array) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 2L);
        this.storeEntityHeader(totalByteLength, typeId, objectId);
        this.store_long(0L, totalByteLength);
        this.store_long(8L, array.length);
        this.store_charsToAddress(Binary.toBinaryListElementsOffset(this.address), array);
    }

    public final void store_chars(char[] array, long offset) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 2L);
        this.store_long(offset + 0L, totalByteLength);
        this.store_long(offset + 8L, array.length);
        this.store_charsToAddress(Binary.toBinaryListElementsOffset(offset + this.address), array);
    }

    public final void store_ints(long typeId, long objectId, int[] array) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 4L);
        this.storeEntityHeader(totalByteLength, typeId, objectId);
        this.store_long(0L, totalByteLength);
        this.store_long(8L, array.length);
        this.store_intsToAddress(Binary.toBinaryListElementsOffset(this.address), array);
    }

    public final void store_ints(int[] array, long offset) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 4L);
        this.store_long(offset + 0L, totalByteLength);
        this.store_long(offset + 8L, array.length);
        this.store_intsToAddress(Binary.toBinaryListElementsOffset(offset + this.address), array);
    }

    public final void store_floats(long typeId, long objectId, float[] array) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 4L);
        this.storeEntityHeader(totalByteLength, typeId, objectId);
        this.store_long(0L, totalByteLength);
        this.store_long(8L, array.length);
        this.store_floatsToAddress(Binary.toBinaryListElementsOffset(this.address), array);
    }

    public final void store_floats(float[] array, long offset) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 4L);
        this.store_long(offset + 0L, totalByteLength);
        this.store_long(offset + 8L, array.length);
        this.store_floatsToAddress(Binary.toBinaryListElementsOffset(offset + this.address), array);
    }

    public final void store_longs(long typeId, long objectId, long[] array) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 8L);
        this.storeEntityHeader(totalByteLength, typeId, objectId);
        this.store_long(0L, totalByteLength);
        this.store_long(8L, array.length);
        this.store_longsToAddress(Binary.toBinaryListElementsOffset(this.address), array);
    }

    public final void store_longs(long[] array, long offset) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 8L);
        this.store_long(offset + 0L, totalByteLength);
        this.store_long(offset + 8L, array.length);
        this.store_longsToAddress(Binary.toBinaryListElementsOffset(offset + this.address), array);
    }

    public final void store_doubles(long typeId, long objectId, double[] array) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 8L);
        this.storeEntityHeader(totalByteLength, typeId, objectId);
        this.store_long(0L, totalByteLength);
        this.store_long(8L, array.length);
        this.store_doublesToAddress(Binary.toBinaryListElementsOffset(this.address), array);
    }

    public final void store_doubles(double[] array, long offset) {
        long totalByteLength = Binary.toBinaryListTotalByteLength((long)array.length * 8L);
        this.store_long(offset + 0L, totalByteLength);
        this.store_long(offset + 8L, array.length);
        this.store_doublesToAddress(Binary.toBinaryListElementsOffset(offset + this.address), array);
    }

    public final void storeByte(long typeId, long objectId, byte value) {
        this.storeEntityHeader(1L, typeId, objectId);
        this.store_byte(value);
    }

    public final void storeBoolean(long typeId, long objectId, boolean value) {
        this.storeEntityHeader(1L, typeId, objectId);
        this.store_boolean(value);
    }

    public final void storeShort(long typeId, long objectId, short value) {
        this.storeEntityHeader(2L, typeId, objectId);
        this.store_short(value);
    }

    public final void storeCharacter(long typeId, long objectId, char value) {
        this.storeEntityHeader(2L, typeId, objectId);
        this.store_char(value);
    }

    public final void storeInteger(long typeId, long objectId, int value) {
        this.storeEntityHeader(4L, typeId, objectId);
        this.store_int(value);
    }

    public final void storeFloat(long typeId, long objectId, float value) {
        this.storeEntityHeader(4L, typeId, objectId);
        this.store_float(value);
    }

    public final void storeLong(long typeId, long objectId, long value) {
        this.storeEntityHeader(8L, typeId, objectId);
        this.store_long(value);
    }

    public final void storeDouble(long typeId, long objectId, double value) {
        this.storeEntityHeader(8L, typeId, objectId);
        this.store_double(value);
    }

    public final void storeStateless(long typeId, long objectId) {
        this.storeEntityHeader(0L, typeId, objectId);
    }

    public final void storeStringSingleValue(long typeId, long objectId, String string) {
        this.storeStringSingleValue(typeId, objectId, XChars.readChars((String)string));
    }

    public final void storeStringSingleValue(long typeId, long objectId, char[] chars) {
        this.storeStringSingleValue(typeId, objectId, chars, 0, chars.length);
    }

    public final void storeStringSingleValue(long typeId, long objectId, char[] chars, int offset, int length) {
        this.storeEntityHeader(Binary.calculateBinaryLengthChars(chars.length), typeId, objectId);
        this.storeCharsAsList(0L, chars, offset, length);
    }

    public final void storeStringValue(long binaryOffset, String string) {
        this.storeStringValue(binaryOffset, XChars.readChars((String)string));
    }

    public final void storeStringValue(long binaryOffset, char[] chars) {
        this.storeCharsAsList(binaryOffset, chars, 0, chars.length);
    }

    public final void storeStringValue(long binaryOffset, char[] chars, int offset, int length) {
        this.storeCharsAsList(binaryOffset, chars, offset, length);
    }

    public final void storeReferences(long typeId, long objectId, long binaryOffset, PersistenceFunction persister, Object[] array) {
        this.storeReferences(typeId, objectId, binaryOffset, persister, array, 0, array.length);
    }

    public final void storeReferences(long typeId, long objectId, long binaryOffset, PersistenceFunction persister, Object[] array, int arrayOffset, int arrayLength) {
        this.storeEntityHeader(binaryOffset + Binary.calculateReferenceListTotalBinaryLength(arrayLength), typeId, objectId);
        this.storeReferencesAsList(binaryOffset, persister, array, arrayOffset, arrayLength);
    }

    public final void storeFixedSize(PersistenceStoreHandler<Binary> handler, long contentLength, long typeId, long objectId, Object instance, long[] memoryOffsets, BinaryValueStorer[] storers) {
        this.storeEntityHeader(contentLength, typeId, objectId);
        long address = this.address;
        for (int i = 0; i < memoryOffsets.length; ++i) {
            address = storers[i].storeValueFromMemory(instance, memoryOffsets[i], address, handler);
        }
    }

    public final String[] buildStrings(long stringsListOffset) {
        long stringsCount = this.getBinaryListElementCountUnvalidating(stringsListOffset);
        String[] array = new String[X.checkArrayRange((long)stringsCount)];
        long stringsOffset = Binary.toBinaryListElementsOffset(stringsListOffset);
        for (int i = 0; i < array.length; ++i) {
            array[i] = String.valueOf(this.build_chars(stringsOffset));
            stringsOffset += this.getBinaryListTotalByteLength(stringsOffset);
        }
        return array;
    }

    public final Byte buildByte() {
        return this.buildByte(0L);
    }

    public final Byte buildByte(long offset) {
        return new Byte(this.read_byte(offset));
    }

    public final Boolean buildBoolean() {
        return this.buildBoolean(0L);
    }

    public final Boolean buildBoolean(long offset) {
        return new Boolean(this.read_boolean(offset));
    }

    public final Short buildShort() {
        return this.buildShort(0L);
    }

    public final Short buildShort(long offset) {
        return new Short(this.read_short(offset));
    }

    public final Character buildCharacter() {
        return this.buildCharacter(0L);
    }

    public final Character buildCharacter(long offset) {
        return new Character(this.read_char(offset));
    }

    public final Integer buildInteger() {
        return this.buildInteger(0L);
    }

    public final Integer buildInteger(long offset) {
        return new Integer(this.read_int(offset));
    }

    public final Float buildFloat() {
        return this.buildFloat(0L);
    }

    public final Float buildFloat(long offset) {
        return Float.valueOf(this.read_float(offset));
    }

    public final Long buildLong() {
        return this.buildLong(0L);
    }

    public final Long buildLong(long offset) {
        return new Long(this.read_long(offset));
    }

    public final Double buildDouble() {
        return this.buildDouble(0L);
    }

    public final Double buildDouble(long offset) {
        return this.read_double(offset);
    }

    public final Object buildPrimitiveWrapper(Class<?> primitiveValueType) {
        return this.buildPrimitiveWrapper(primitiveValueType, 0L);
    }

    public final Object buildPrimitiveWrapper(Class<?> primitiveValueType, long offset) {
        if (primitiveValueType == Integer.TYPE) {
            return this.buildInteger(offset);
        }
        if (primitiveValueType == Long.TYPE) {
            return this.buildLong(offset);
        }
        if (primitiveValueType == Double.TYPE) {
            return this.buildDouble(offset);
        }
        if (primitiveValueType == Character.TYPE) {
            return this.buildCharacter(offset);
        }
        if (primitiveValueType == Boolean.TYPE) {
            return this.buildBoolean(offset);
        }
        if (primitiveValueType == Byte.TYPE) {
            return this.buildByte(offset);
        }
        if (primitiveValueType == Float.TYPE) {
            return this.buildFloat(offset);
        }
        if (primitiveValueType == Short.TYPE) {
            return this.buildShort(offset);
        }
        throw new IllegalArgumentException();
    }

    public final String buildString() {
        return this.buildString(0L);
    }

    public final String buildString(long offset) {
        return String.valueOf(this.build_chars(offset));
    }

    public final byte[] create_bytes() {
        return this.create_bytes(0L);
    }

    public final byte[] create_bytes(long listOffset) {
        return new byte[X.checkArrayRange((long)this.getBinaryListElementCountValidating(listOffset, 1L))];
    }

    public final boolean[] create_booleans() {
        return this.create_booleans(0L);
    }

    public final boolean[] create_booleans(long listOffset) {
        return new boolean[X.checkArrayRange((long)this.getBinaryListElementCountValidating(listOffset, 1L))];
    }

    public final short[] create_shorts() {
        return this.create_shorts(0L);
    }

    public final short[] create_shorts(long listOffset) {
        return new short[X.checkArrayRange((long)this.getBinaryListElementCountValidating(listOffset, 2L))];
    }

    public final char[] create_chars() {
        return this.create_chars(0L);
    }

    public final char[] create_chars(long listOffset) {
        return new char[X.checkArrayRange((long)this.getBinaryListElementCountValidating(listOffset, 2L))];
    }

    public final int[] create_ints() {
        return this.create_ints(0L);
    }

    public final int[] create_ints(long listOffset) {
        return new int[X.checkArrayRange((long)this.getBinaryListElementCountValidating(listOffset, 4L))];
    }

    public final float[] create_floats() {
        return this.create_floats(0L);
    }

    public final float[] create_floats(long listOffset) {
        return new float[X.checkArrayRange((long)this.getBinaryListElementCountValidating(listOffset, 4L))];
    }

    public final long[] create_longs() {
        return this.create_longs(0L);
    }

    public final long[] create_longs(long listOffset) {
        return new long[X.checkArrayRange((long)this.getBinaryListElementCountValidating(listOffset, 8L))];
    }

    public final double[] create_doubles() {
        return this.create_doubles(0L);
    }

    public final double[] create_doubles(long listOffset) {
        return new double[X.checkArrayRange((long)this.getBinaryListElementCountValidating(listOffset, 8L))];
    }

    public final byte[] build_bytes() {
        return this.build_bytes(0L);
    }

    public final byte[] build_bytes(long listOffset) {
        byte[] array = this.create_bytes(listOffset);
        this.unvalidatingUpdate_bytes(listOffset, array);
        return array;
    }

    public final boolean[] build_booleans() {
        return this.build_booleans(0L);
    }

    public final boolean[] build_booleans(long listOffset) {
        boolean[] array = this.create_booleans(listOffset);
        this.unvalidatingUpdate_booleans(listOffset, array);
        return array;
    }

    public final short[] build_shorts() {
        return this.build_shorts(0L);
    }

    public final short[] build_shorts(long listOffset) {
        short[] array = this.create_shorts(listOffset);
        this.unvalidatingUpdate_shorts(listOffset, array);
        return array;
    }

    public final char[] build_chars() {
        return this.build_chars(0L);
    }

    public final char[] build_chars(long listOffset) {
        char[] array = this.create_chars(listOffset);
        this.unvalidatingUpdate_chars(listOffset, array);
        return array;
    }

    public final int[] build_ints() {
        return this.build_ints(0L);
    }

    public final int[] build_ints(long listOffset) {
        int[] array = this.create_ints(listOffset);
        this.unvalidatingUpdate_ints(listOffset, array);
        return array;
    }

    public final float[] build_floats() {
        return this.build_floats(0L);
    }

    public final float[] build_floats(long listOffset) {
        float[] array = this.create_floats(listOffset);
        this.unvalidatingUpdate_floats(listOffset, array);
        return array;
    }

    public final long[] build_longs() {
        return this.build_longs(0L);
    }

    public final long[] build_longs(long listOffset) {
        long[] array = this.create_longs(listOffset);
        this.unvalidatingUpdate_longs(listOffset, array);
        return array;
    }

    public final double[] build_doubles() {
        return this.build_doubles(0L);
    }

    public final double[] build_doubles(long listOffset) {
        double[] array = this.create_doubles(listOffset);
        this.unvalidatingUpdate_doubles(listOffset, array);
        return array;
    }

    public final long collectElementsIntoArray(long binaryOffset, PersistenceLoadHandler handler, Object[] target) {
        long nonNullCount = 0L;
        long binaryElementsStartAddress = this.binaryListElementsAddress(binaryOffset);
        for (int i = 0; i < target.length; ++i) {
            long oid = this.get_longFromAddress(binaryElementsStartAddress + Binary.referenceBinaryLength(i));
            target[i] = handler.lookupObject(oid);
            if (target[i] == null) continue;
            ++nonNullCount;
        }
        return nonNullCount;
    }

    public final int collectListObjectReferences(long binaryOffset, PersistenceLoadHandler handler, Consumer<Object> collector) {
        int size = X.checkArrayRange((long)this.getListElementCountReferences(binaryOffset));
        this.collectObjectReferences(binaryOffset, size, handler, collector);
        return size;
    }

    public final void collectObjectReferences(long binaryOffset, int length, PersistenceLoadHandler handler, Consumer<Object> collector) {
        long binaryElementsStartAddress = this.binaryListElementsAddress(binaryOffset);
        for (int i = 0; i < length; ++i) {
            collector.accept(handler.lookupObject(this.get_longFromAddress(binaryElementsStartAddress + Binary.referenceBinaryLength(i))));
        }
    }

    public final int collectKeyValueReferences(long binaryOffset, int length, PersistenceLoadHandler handler, BiConsumer<Object, Object> collector) {
        long binaryElementsStartAddress = this.binaryListElementsAddress(binaryOffset);
        for (int i = 0; i < length; ++i) {
            collector.accept(handler.lookupObject(this.get_longFromAddress(binaryElementsStartAddress + Binary.referenceBinaryLength(i << 1))), handler.lookupObject(this.get_longFromAddress(binaryElementsStartAddress + Binary.referenceBinaryLength(i << 1) + 8L)));
        }
        return length;
    }

    public abstract long iterateReferences(BinaryReferenceTraverser[] var1, PersistenceObjectIdAcceptor var2);

    public abstract void mark();

    public abstract void reset();

    public final long storeCharsAsList(long memoryOffset, char[] chars, int offset, int length) {
        long elementsBinaryLength = length * 2;
        long elementsDataAddress = this.address + memoryOffset + 16L;
        this.storeListHeader(memoryOffset, elementsBinaryLength, length);
        int bound = offset + length;
        for (int i = offset; i < bound; ++i) {
            this.set_charToAddress(elementsDataAddress + (long)(i << 1), chars[i]);
        }
        return elementsDataAddress + elementsBinaryLength;
    }

    public final void copyMemory(ByteBuffer directByteBuffer, long offset, BinaryValueSetter[] setters, long[] targetOffsets) {
        long targetAddress = this.calculateAddress(directByteBuffer, offset);
        long address = this.loadItemEntityContentAddress();
        for (int i = 0; i < setters.length; ++i) {
            address = setters[i].setValueToMemory(address, null, targetAddress + targetOffsets[i], null);
        }
    }

    public final void copyToAddress(long entityContentAddressOffset, long targetAddress, long length) {
        XMemory.copyRange((long)(this.address + entityContentAddressOffset), (long)targetAddress, (long)length);
    }

    public final void storeListHeader(long offset, long elementsBinaryLength, long elementsCount) {
        this.store_long(offset + 0L, Binary.toBinaryListTotalByteLength(elementsBinaryLength));
        this.store_long(offset + 8L, elementsCount);
    }

    public final void storeIterableContentAsList(long offset, PersistenceFunction persister, Iterable<?> elements, long elementCount) {
        long a;
        long referenceLength = Binary.referenceBinaryLength(1L);
        long elementsBinaryRange = elementCount * referenceLength;
        long elementsDataAddress = this.address + offset + 16L;
        long elementsBinaryBound = elementsDataAddress + elementsBinaryRange;
        this.storeListHeader(offset, elementsBinaryRange, elementCount);
        Iterator<?> iterator = elements.iterator();
        for (a = elementsDataAddress; a < elementsBinaryBound && iterator.hasNext(); a += referenceLength) {
            Object element = iterator.next();
            this.set_longToAddress(a, persister.apply(element));
        }
        Binary.validatePostIterationState(a, elementsBinaryBound, iterator, elementCount, referenceLength);
    }

    public final void storeStringsAsList(long memoryOffset, long precalculatedContentBinaryLength, String[] strings) {
        this.storeStringsAsList(memoryOffset, precalculatedContentBinaryLength, strings, 0, strings.length);
    }

    public final void storeStringsAsList(long memoryOffset, long precalculatedContentBinaryLength, String[] strings, int offset, int length) {
        this.storeListHeader(memoryOffset, precalculatedContentBinaryLength, length);
        long elementsDataAddress = this.address + memoryOffset + 16L;
        int bound = offset + length;
        for (int i = offset; i < bound; ++i) {
            elementsDataAddress = this.storeCharsAsListToAddress(elementsDataAddress, XChars.readChars((String)strings[i]));
        }
    }

    public final void storeKeyValuesAsEntries(long offset, PersistenceFunction persister, Iterable<? extends KeyValue<?, ?>> elements, long elementCount) {
        long a;
        long referenceLength = Binary.referenceBinaryLength(1L);
        long entryLength = Binary.referenceBinaryLength(2L);
        long elementsBinaryRange = elementCount * entryLength;
        long elementsDataAddress = this.address + offset + 16L;
        long elementsBinaryBound = elementsDataAddress + elementsBinaryRange;
        this.storeListHeader(offset, elementsBinaryRange, elementCount);
        Iterator<KeyValue<?, ?>> iterator = elements.iterator();
        for (a = elementsDataAddress; a < elementsBinaryBound && iterator.hasNext(); a += entryLength) {
            KeyValue<?, ?> element = iterator.next();
            this.set_longToAddress(a, persister.apply(element.key()));
            this.set_longToAddress(a + referenceLength, persister.apply(element.value()));
        }
        Binary.validatePostIterationState(a, elementsBinaryBound, iterator, elementCount, entryLength);
    }

    public final void storeReferencesAsList(long memoryOffset, PersistenceFunction persister, Object[] array, int offset, int length) {
        this.storeListHeader(memoryOffset, Binary.referenceBinaryLength(length), length);
        long elementsDataAddress = this.address + memoryOffset + 16L;
        int bound = offset + length;
        for (int i = offset; i < bound; ++i) {
            this.set_longToAddress(elementsDataAddress + Binary.referenceBinaryLength(i), persister.apply(array[i]));
        }
    }

    public final void store_byte(long offset, byte value) {
        this.set_byteToAddress(this.address + offset, value);
    }

    public final void store_boolean(long offset, boolean value) {
        this.set_booleanToAddress(this.address + offset, value);
    }

    public final void store_short(long offset, short value) {
        this.set_shortToAddress(this.address + offset, value);
    }

    public final void store_char(long offset, char value) {
        this.set_charToAddress(this.address + offset, value);
    }

    public final void store_int(long offset, int value) {
        this.set_intToAddress(this.address + offset, value);
    }

    public final void store_float(long offset, float value) {
        this.set_floatToAddress(this.address + offset, value);
    }

    public final void store_long(long offset, long value) {
        this.set_longToAddress(this.address + offset, value);
    }

    public final void store_double(long offset, double value) {
        this.set_doubleToAddress(this.address + offset, value);
    }

    public final void store_byte(byte value) {
        this.set_byteToAddress(this.address, value);
    }

    public final void store_boolean(boolean value) {
        this.set_booleanToAddress(this.address, value);
    }

    public final void store_short(short value) {
        this.set_shortToAddress(this.address, value);
    }

    public final void store_char(char value) {
        this.set_charToAddress(this.address, value);
    }

    public final void store_int(int value) {
        this.set_intToAddress(this.address, value);
    }

    public final void store_float(float value) {
        this.set_floatToAddress(this.address, value);
    }

    public final void store_long(long value) {
        this.set_longToAddress(this.address, value);
    }

    public final void store_double(double value) {
        this.set_doubleToAddress(this.address, value);
    }

    final long getEntityBoundAddress() {
        return this.loadItemEntityAddress() + this.get_longFromAddress(this.loadItemEntityAddress() + 0L);
    }

    void storeEntityHeaderToAddress(long entityAddress, long entityTotalLength, long entityTypeId, long entityObjectId) {
        Binary.setEntityHeaderRawValuesToAddress(entityAddress, entityTotalLength, entityTypeId, entityObjectId);
    }

    final long binaryListElementsAddress(long binaryListOffset) {
        return this.loadItemEntityContentAddress() + Binary.toBinaryListElementsOffset(binaryListOffset);
    }

    public abstract long loadItemEntityContentAddress();

    private boolean isSkipItem() {
        return this.address < 0L;
    }

    protected final boolean isDummyItem() {
        return this.address == 0L;
    }

    protected final boolean isProper() {
        return this.address > 0L;
    }

    private long loadItemEntityAddress() {
        return Binary.entityAddressFromContentAddress(this.loadItemEntityContentAddress());
    }

    public abstract void modifyLoadItem(ByteBuffer var1, long var2, long var4, long var6, long var8);

    private boolean isValidLoadItemContentLength(long contentLength) {
        return contentLength <= this.getLoadItemAvailableContentLength();
    }

    private static void validatePostIterationState(long address, long elementsBinaryBound, Iterator<?> iterator, long elementCount, long entryLength) {
        if (address != elementsBinaryBound || iterator.hasNext()) {
            throw new BinaryPersistenceException("Inconsistent element count: specified " + elementCount + " vs. iterated " + elementsBinaryBound / entryLength);
        }
    }

    final long storeCharsAsListToAddress(long address, char[] chars) {
        return this.storeCharsAsListToAddress(address, chars, 0, chars.length);
    }

    final long storeCharsAsListToAddress(long address, char[] chars, int offset, int length) {
        long elementsBinaryLength = length * 2;
        long elementsDataAddress = address + 16L;
        this.set_longToAddress(address + 0L, Binary.toBinaryListTotalByteLength(elementsBinaryLength));
        this.set_longToAddress(address + 8L, length);
        int bound = offset + length;
        for (int i = offset; i < bound; ++i) {
            this.set_charToAddress(elementsDataAddress + (long)(i << 1), chars[i]);
        }
        return elementsDataAddress + elementsBinaryLength;
    }

    public final void updateFixedSize(Object instance, BinaryValueSetter[] setters, long[] memoryOffsets, PersistenceLoadHandler handler) {
        long address = this.loadItemEntityContentAddress();
        for (int i = 0; i < setters.length; ++i) {
            address = setters[i].setValueToMemory(address, instance, memoryOffsets[i], handler);
        }
    }

    public final int updateSizedArrayObjectReferences(long binaryOffset, PersistenceLoadHandler handler, Object[] array) {
        int size = this.getSizedArrayElementCount(binaryOffset);
        if (array.length < size) {
            throw new IllegalArgumentException("Array length smaller than size, " + array.length + " < " + size);
        }
        this.updateArrayObjectReferences(binaryOffset + 8L, handler, array, 0, size);
        return size;
    }

    public final void updateArrayObjectReferences1(long binaryListStartOffset, PersistenceLoadHandler handler, Object[] array) {
        this.updateArrayObjectReferences(binaryListStartOffset, handler, array, 0, array.length);
    }

    public final void updateArrayObjectReferences(long binaryListStartOffset, PersistenceLoadHandler handler, Object[] array, int arrayOffset, int arrayLength) {
        long elementCount = this.getListElementCountReferences(binaryListStartOffset);
        if (elementCount > (long)arrayLength) {
            throw new BinaryPersistenceExceptionStateArrayLength(array, X.checkArrayRange((long)elementCount));
        }
        long binaryElementsStartAddress = this.binaryListElementsAddress(binaryListStartOffset);
        for (int i = 0; i < arrayLength; ++i) {
            array[arrayOffset + i] = handler.lookupObject(this.get_longFromAddress(binaryElementsStartAddress + Binary.referenceBinaryLength(i)));
        }
    }

    private void validateLoadItemRequiredContentLength(long requiredContentLength) {
        XMath.notNegative((long)requiredContentLength);
        if (this.isValidLoadItemContentLength(requiredContentLength)) {
            return;
        }
        throw new BinaryPersistenceException("Binary load item bounds violation: " + requiredContentLength + " > " + this.getLoadItemAvailableContentLength());
    }

    private void validateLoadItemRequiredContentLengthArray(long entityContentOffset, long arrayLength, int arrayElementLength) {
        XMath.notNegative((long)entityContentOffset);
        XMath.notNegative((long)arrayLength);
        XMath.positive((int)arrayElementLength);
        long totalEntityContentLength = Binary.toBinaryListTotalByteLength(entityContentOffset + arrayLength * (long)arrayElementLength);
        this.validateLoadItemRequiredContentLength(totalEntityContentLength);
    }

    public final void update_bytes(byte[] array) {
        this.validateLoadItemRequiredContentLengthArray(0L, array.length, 1);
        this.unvalidatingUpdate_bytes(0L, array);
    }

    public final void update_bytes(long offset, byte[] array) {
        this.validateLoadItemRequiredContentLengthArray(offset, array.length, 1);
        this.unvalidatingUpdate_bytes(offset, array);
    }

    public final void update_booleans(boolean[] array) {
        this.validateLoadItemRequiredContentLengthArray(0L, array.length, 1);
        this.unvalidatingUpdate_booleans(0L, array);
    }

    public final void update_booleans(long offset, boolean[] array) {
        this.validateLoadItemRequiredContentLengthArray(offset, array.length, 1);
        this.unvalidatingUpdate_booleans(offset, array);
    }

    public final void update_shorts(short[] array) {
        this.validateLoadItemRequiredContentLengthArray(0L, array.length, 2);
        this.unvalidatingUpdate_shorts(0L, array);
    }

    public final void update_shorts(long offset, short[] array) {
        this.validateLoadItemRequiredContentLengthArray(offset, array.length, 2);
        this.unvalidatingUpdate_shorts(offset, array);
    }

    public final void update_chars(char[] array) {
        this.validateLoadItemRequiredContentLengthArray(0L, array.length, 2);
        this.unvalidatingUpdate_chars(0L, array);
    }

    public final void update_chars(long offset, char[] array) {
        this.validateLoadItemRequiredContentLengthArray(offset, array.length, 2);
        this.unvalidatingUpdate_chars(offset, array);
    }

    public final void update_ints(int[] array) {
        this.validateLoadItemRequiredContentLengthArray(0L, array.length, 4);
        this.unvalidatingUpdate_ints(0L, array);
    }

    public final void update_ints(long offset, int[] array) {
        this.validateLoadItemRequiredContentLengthArray(offset, array.length, 4);
        this.unvalidatingUpdate_ints(offset, array);
    }

    public final void update_floats(float[] array) {
        this.validateLoadItemRequiredContentLengthArray(0L, array.length, 4);
        this.unvalidatingUpdate_floats(0L, array);
    }

    public final void update_floats(long offset, float[] array) {
        this.validateLoadItemRequiredContentLengthArray(offset, array.length, 4);
        this.unvalidatingUpdate_floats(offset, array);
    }

    public final void update_longs(long[] array) {
        this.validateLoadItemRequiredContentLengthArray(0L, array.length, 8);
        this.unvalidatingUpdate_longs(0L, array);
    }

    public final void update_longs(long offset, long[] array) {
        this.validateLoadItemRequiredContentLengthArray(offset, array.length, 8);
        this.unvalidatingUpdate_longs(offset, array);
    }

    public final void update_doubles(double[] array) {
        this.validateLoadItemRequiredContentLengthArray(0L, array.length, 8);
        this.unvalidatingUpdate_doubles(0L, array);
    }

    public final void update_doubles(long offset, double[] array) {
        this.validateLoadItemRequiredContentLengthArray(offset, array.length, 8);
        this.unvalidatingUpdate_doubles(offset, array);
    }

    final void unvalidatingUpdate_bytes(long offset, byte[] array) {
        this.update_bytesFromAddress(this.binaryListElementsAddress(offset), array);
    }

    final void unvalidatingUpdate_booleans(long offset, boolean[] array) {
        this.update_booleansFromAddress(this.binaryListElementsAddress(offset), array);
    }

    final void unvalidatingUpdate_shorts(long offset, short[] array) {
        this.update_shortsFromAddress(this.binaryListElementsAddress(offset), array);
    }

    final void unvalidatingUpdate_chars(long offset, char[] array) {
        this.update_charsFromAddress(this.binaryListElementsAddress(offset), array);
    }

    final void unvalidatingUpdate_ints(long offset, int[] array) {
        this.update_intsFromAddress(this.binaryListElementsAddress(offset), array);
    }

    final void unvalidatingUpdate_floats(long offset, float[] array) {
        this.update_floatsFromAddress(this.binaryListElementsAddress(offset), array);
    }

    final void unvalidatingUpdate_longs(long offset, long[] array) {
        this.update_longsFromAddress(this.binaryListElementsAddress(offset), array);
    }

    final void unvalidatingUpdate_doubles(long offset, double[] array) {
        this.update_doublesFromAddress(this.binaryListElementsAddress(offset), array);
    }

    public final void copyFromAddress(long entityContentAddressOffset, long sourceAddress, long length) {
        XMemory.copyRange((long)sourceAddress, (long)(this.address + entityContentAddressOffset), (long)length);
    }

    long calculateAddress(ByteBuffer byteBuffer, long offset) {
        if (byteBuffer == null) {
            return offset;
        }
        if (offset > (long)byteBuffer.capacity()) {
            throw new BinaryPersistenceException("Specified offset exceeds buffer capacity: " + offset + " > " + byteBuffer.capacity());
        }
        return XMemory.getDirectByteBufferAddress((ByteBuffer)byteBuffer) + (long)X.checkArrayRange((long)offset);
    }

    final byte get_byteFromAddress(long address) {
        return XMemory.get_byte((long)address);
    }

    final boolean get_booleanFromAddress(long address) {
        return XMemory.get_boolean((long)address);
    }

    short get_shortfromAddress(long address) {
        return XMemory.get_short((long)address);
    }

    char get_charFromAddress(long address) {
        return XMemory.get_char((long)address);
    }

    int get_intFromAddress(long address) {
        return XMemory.get_int((long)address);
    }

    float get_floatFromAddress(long address) {
        return XMemory.get_float((long)address);
    }

    long get_longFromAddress(long address) {
        return XMemory.get_long((long)address);
    }

    double get_doubleFromAddress(long address) {
        return XMemory.get_double((long)address);
    }

    final void set_byteToAddress(long address, byte value) {
        XMemory.set_byte((long)address, (byte)value);
    }

    final void set_booleanToAddress(long address, boolean value) {
        XMemory.set_boolean((long)address, (boolean)value);
    }

    void set_shortToAddress(long address, short value) {
        XMemory.set_short((long)address, (short)value);
    }

    void set_charToAddress(long address, char value) {
        XMemory.set_char((long)address, (char)value);
    }

    void set_intToAddress(long address, int value) {
        XMemory.set_int((long)address, (int)value);
    }

    void set_floatToAddress(long address, float value) {
        XMemory.set_float((long)address, (float)value);
    }

    void set_longToAddress(long address, long value) {
        XMemory.set_long((long)address, (long)value);
    }

    void set_doubleToAddress(long address, double value) {
        XMemory.set_double((long)address, (double)value);
    }

    final void update_bytesFromAddress(long address, byte[] target) {
        XMemory.copyRangeToArray((long)address, (byte[])target);
    }

    final void update_booleansFromAddress(long address, boolean[] target) {
        XMemory.copyRangeToArray((long)address, (boolean[])target);
    }

    void update_shortsFromAddress(long address, short[] target) {
        XMemory.copyRangeToArray((long)address, (short[])target);
    }

    void update_charsFromAddress(long address, char[] target) {
        XMemory.copyRangeToArray((long)address, (char[])target);
    }

    void update_intsFromAddress(long address, int[] target) {
        XMemory.copyRangeToArray((long)address, (int[])target);
    }

    void update_floatsFromAddress(long address, float[] target) {
        XMemory.copyRangeToArray((long)address, (float[])target);
    }

    void update_longsFromAddress(long address, long[] target) {
        XMemory.copyRangeToArray((long)address, (long[])target);
    }

    void update_doublesFromAddress(long address, double[] target) {
        XMemory.copyRangeToArray((long)address, (double[])target);
    }

    final void store_bytesToAddress(long address, byte[] values) {
        XMemory.copyArrayToAddress((byte[])values, (long)address);
    }

    final void store_booleansToAddress(long address, boolean[] values) {
        XMemory.copyArrayToAddress((boolean[])values, (long)address);
    }

    void store_shortsToAddress(long address, short[] values) {
        XMemory.copyArrayToAddress((short[])values, (long)address);
    }

    void store_charsToAddress(long address, char[] values) {
        XMemory.copyArrayToAddress((char[])values, (long)address);
    }

    void store_intsToAddress(long address, int[] values) {
        XMemory.copyArrayToAddress((int[])values, (long)address);
    }

    void store_floatsToAddress(long address, float[] values) {
        XMemory.copyArrayToAddress((float[])values, (long)address);
    }

    void store_longsToAddress(long address, long[] values) {
        XMemory.copyArrayToAddress((long[])values, (long)address);
    }

    void store_doublesToAddress(long address, double[] values) {
        XMemory.copyArrayToAddress((double[])values, (long)address);
    }

    void storeReferencesToAddress(long address, PersistenceFunction persister, Object[] references) {
        this.storeReferencesToAddress(address, persister, references, 0, references.length);
    }

    void storeReferencesToAddress(long address, PersistenceFunction persister, Object[] references, int offset, int length) {
        int bound = offset + length;
        for (int i = offset; i < bound; ++i) {
            this.set_longToAddress(address + Binary.referenceBinaryLength(i), persister.apply(references[i]));
        }
    }

    public void storeReference(long contentOffset, PersistenceFunction persister, Object reference) {
        this.set_longToAddress(this.address + contentOffset, persister.apply(reference));
    }

    public void storeReferenceEager(long contentOffset, PersistenceStoreHandler<Binary> persister, Object reference) {
        this.set_longToAddress(this.address + contentOffset, persister.applyEager(reference));
    }

    void storeRangeToAddress(long address, long sourceAddress, long length) {
        XMemory.copyRange((long)sourceAddress, (long)address, (long)length);
    }

    public final synchronized void registerHelper(Object key, Object helper) {
        HelperEntry e = this.helperEntry;
        while (e != null) {
            if (e.key == key) {
                e.helper = helper;
                return;
            }
            e = e.next;
        }
        this.helperEntry = new HelperEntry(key, helper, this.helperEntry);
    }

    public final synchronized Object getHelper(Object key) {
        HelperEntry e = this.helperEntry;
        while (e != null) {
            if (e.key == key) {
                return e.helper;
            }
            e = e.next;
        }
        return null;
    }

    public static final <T> BinaryField<T> Field_byte(String name, Getter_byte<T> getter) {
        return Binary.Field_byte(name, getter, null);
    }

    public static final <T> BinaryField<T> Field_byte(String name, Getter_byte<T> getter, Setter_byte<T> setter) {
        return new BinaryField.Default_byte((String)X.notNull((Object)name), (Getter_byte)X.notNull(getter), (Setter_byte)X.mayNull(setter));
    }

    public static final <T> BinaryField<T> Field_boolean(String name, Getter_boolean<T> getter) {
        return Binary.Field_boolean(name, getter, null);
    }

    public static final <T> BinaryField<T> Field_boolean(String name, Getter_boolean<T> getter, Setter_boolean<T> setter) {
        return new BinaryField.Default_boolean((String)X.notNull((Object)name), (Getter_boolean)X.notNull(getter), (Setter_boolean)X.mayNull(setter));
    }

    public static final <T> BinaryField<T> Field_short(String name, Getter_short<T> getter) {
        return Binary.Field_short(name, getter, null);
    }

    public static final <T> BinaryField<T> Field_short(String name, Getter_short<T> getter, Setter_short<T> setter) {
        return new BinaryField.Default_short((String)X.notNull((Object)name), (Getter_short)X.notNull(getter), (Setter_short)X.mayNull(setter));
    }

    public static final <T> BinaryField<T> Field_char(String name, Getter_char<T> getter) {
        return Binary.Field_char(name, getter, null);
    }

    public static final <T> BinaryField<T> Field_char(String name, Getter_char<T> getter, Setter_char<T> setter) {
        return new BinaryField.Default_char((String)X.notNull((Object)name), (Getter_char)X.notNull(getter), (Setter_char)X.mayNull(setter));
    }

    public static final <T> BinaryField<T> Field_int(String name, Getter_int<T> getter) {
        return Binary.Field_int(name, getter, null);
    }

    public static final <T> BinaryField<T> Field_int(String name, Getter_int<T> getter, Setter_int<T> setter) {
        return new BinaryField.Default_int((String)X.notNull((Object)name), (Getter_int)X.notNull(getter), (Setter_int)X.mayNull(setter));
    }

    public static final <T> BinaryField<T> Field_float(String name, Getter_float<T> getter) {
        return Binary.Field_float(name, getter, null);
    }

    public static final <T> BinaryField<T> Field_float(String name, Getter_float<T> getter, Setter_float<T> setter) {
        return new BinaryField.Default_float((String)X.notNull((Object)name), (Getter_float)X.notNull(getter), (Setter_float)X.mayNull(setter));
    }

    public static final <T> BinaryField<T> Field_long(String name, Getter_long<T> getter) {
        return Binary.Field_long(name, getter, null);
    }

    public static final <T> BinaryField<T> Field_long(String name, Getter_long<T> getter, Setter_long<T> setter) {
        return new BinaryField.Default_long((String)X.notNull((Object)name), (Getter_long)X.notNull(getter), (Setter_long)X.mayNull(setter));
    }

    public static final <T> BinaryField<T> Field_double(String name, Getter_double<T> getter) {
        return Binary.Field_double(name, getter, null);
    }

    public static final <T> BinaryField<T> Field_double(String name, Getter_double<T> getter, Setter_double<T> setter) {
        return new BinaryField.Default_double((String)X.notNull((Object)name), (Getter_double)X.notNull(getter), (Setter_double)X.mayNull(setter));
    }

    public static final <T, R> BinaryField<T> Field(Class<R> referenceType, String name, Getter<T, R> getter) {
        return Binary.Field(referenceType, name, getter, null);
    }

    public static final <T, R> BinaryField<T> Field(Class<R> referenceType, String name, Getter<T, R> getter, Setter<T, R> setter) {
        return new BinaryField.DefaultReference((Class)X.notNull(referenceType), (String)X.notNull((Object)name), (Getter)X.notNull(getter), (Setter)X.mayNull(setter));
    }

    @SafeVarargs
    public static <T> BinaryTypeHandler<T> TypeHandler(Class<T> entityType, BinaryField<? super T> ... binaryFields) {
        return Binary.TypeHandler(entityType, PersistenceTypeInstantiator.New(entityType), binaryFields);
    }

    @SafeVarargs
    public static <T> BinaryTypeHandler<T> TypeHandler(Class<T> entityType, PersistenceTypeInstantiator<Binary, T> instantiator, BinaryField<? super T> ... binaryFields) {
        return CustomBinaryHandler.New(entityType, instantiator, X.ConstList((Object[])binaryFields));
    }

    static {
        XMemory.guaranteeUsability();
    }

    static final class HelperEntry {
        Object key;
        Object helper;
        HelperEntry next;

        HelperEntry(Object key, Object helper, HelperEntry next) {
            this.key = key;
            this.helper = helper;
            this.next = next;
        }
    }
}

