/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.EqConstHashEnum;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.exceptions.TypeCastException;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldHandlerProvider;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldSetter;
import org.eclipse.serializer.persistence.binary.types.BinaryPersistence;
import org.eclipse.serializer.persistence.binary.types.BinaryTypeHandler;
import org.eclipse.serializer.persistence.binary.types.BinaryValueFunctions;
import org.eclipse.serializer.persistence.binary.types.BinaryValueSetter;
import org.eclipse.serializer.persistence.binary.types.BinaryValueStorer;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionTypeConsistency;
import org.eclipse.serializer.persistence.types.PersistenceEagerStoringFieldEvaluator;
import org.eclipse.serializer.persistence.types.PersistenceFieldLengthResolver;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldReflective;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandlerReflective;
import org.eclipse.serializer.persistence.types.Persister;
import org.eclipse.serializer.reflect.XReflect;
import org.eclipse.serializer.util.UtilStackTrace;

public abstract class AbstractBinaryHandlerReflective<T>
extends BinaryTypeHandler.Abstract<T>
implements PersistenceTypeHandlerReflective<Binary, T> {
    private final EqConstHashEnum<PersistenceTypeDefinitionMember> membersInDeclaredOrder;
    private final EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> referenceMembers;
    private final EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> primitiveMembers;
    private final EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> storingMembers;
    private final EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> settingMembers;
    private final long[] storingMemoryOffsets;
    private final long[] settingMemoryOffsets;
    private final long[] refrnceMemoryOffsets;
    private final long refBinaryOffsetStart;
    private final long refBinaryOffsetBound;
    private final long binaryContentLength;
    private final BinaryValueStorer[] storers;
    private final BinaryValueSetter[] setters;
    private final EqConstHashEnum<Field> declOrderFields;
    private final EqConstHashEnum<Field> referenceFields;
    private final EqConstHashEnum<Field> primitiveFields;
    private final Field[] persisterFields;
    private final boolean switchByteOrder;
    private final BinaryFieldHandlerProvider fieldHandlerProvider;

    protected static <D extends PersistenceTypeDefinitionMember> EqHashEnum<D> MemberEnum() {
        return EqHashEnum.New((HashEqualator)PersistenceTypeDescriptionMember.identityHashEqualator());
    }

    protected static <D extends PersistenceTypeDefinitionMember> EqHashEnum<D> MemberEnum(XGettingCollection<D> initialMembers) {
        return AbstractBinaryHandlerReflective.MemberEnum().addAll(initialMembers);
    }

    protected static EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> deriveMembers(XGettingEnum<Field> fields, PersistenceFieldLengthResolver lengthResolver) {
        EqHashEnum members = AbstractBinaryHandlerReflective.MemberEnum();
        for (Field field : fields) {
            if (XReflect.isStatic((Member)field)) {
                throw new PersistenceExceptionTypeConsistency("static fields are not persistable.");
            }
            PersistenceTypeDefinitionMemberFieldReflective member = AbstractBinaryHandlerReflective.declaredField((Field)field, (PersistenceFieldLengthResolver)lengthResolver);
            if (members.add((Object)member)) continue;
            throw new PersistenceExceptionTypeConsistency("Duplicate member descriptions.");
        }
        return members;
    }

    protected static final EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> filter(XGettingCollection<? extends PersistenceTypeDefinitionMemberFieldReflective> fields, Predicate<? super PersistenceTypeDefinitionMemberFieldReflective> predicate) {
        return ((EqHashEnum)fields.filterTo((Consumer)EqHashEnum.New(), predicate)).immure();
    }

    protected static final <C extends Consumer<? super Field>> C unbox(XGettingCollection<? extends PersistenceTypeDefinitionMemberFieldReflective> members, C collector) {
        return (C)PersistenceTypeDefinitionMemberFieldReflective.unbox(members, collector);
    }

    protected static final long equal(long value1, long value2) throws IllegalArgumentException {
        if (value1 != value2) {
            throw (IllegalArgumentException)UtilStackTrace.cutStacktraceByOne((Throwable)new IllegalArgumentException());
        }
        return value1;
    }

    protected static void createStorers(Class<?> entityType, Iterable<PersistenceTypeDefinitionMemberFieldReflective> storingMembers, BinaryValueStorer[] storers, PersistenceEagerStoringFieldEvaluator eagerEvaluator, BinaryFieldHandlerProvider fieldHandlerProvider, boolean switchByteOrder) {
        int i = 0;
        for (PersistenceTypeDefinitionMemberFieldReflective member : storingMembers) {
            boolean isEager = eagerEvaluator.isEagerStoring(entityType, member.field());
            BinaryValueStorer customFieldStorer = fieldHandlerProvider.lookupFieldStorer(member.field(), isEager, switchByteOrder);
            if (customFieldStorer != null) {
                storers[i++] = customFieldStorer;
                continue;
            }
            storers[i++] = BinaryValueFunctions.getObjectValueStorer(member.type(), isEager, switchByteOrder);
        }
    }

    protected static long calculcateBinaryContentLength(Iterable<PersistenceTypeDefinitionMemberFieldReflective> storingMembers) {
        long binaryContentLength = 0L;
        for (PersistenceTypeDefinitionMemberFieldReflective member : storingMembers) {
            long fixedBinaryLength = AbstractBinaryHandlerReflective.equal(member.persistentMinimumLength(), member.persistentMaximumLength());
            binaryContentLength += fixedBinaryLength;
        }
        return binaryContentLength;
    }

    protected static final XGettingSequence<PersistenceTypeDefinitionMemberFieldReflective> createTypeDescriptionMembers(Field[] persistentOrderFields, PersistenceFieldLengthResolver lengthResolver) {
        BulkList members = BulkList.New();
        for (Field field : persistentOrderFields) {
            members.add((Object)AbstractBinaryHandlerReflective.declaredField((Field)field, (PersistenceFieldLengthResolver)lengthResolver));
        }
        return members;
    }

    protected static final long[] objectFieldOffsets(Class<?> entityClass, XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldReflective> members) {
        Field[] fields = (Field[])AbstractBinaryHandlerReflective.unbox(members, BulkList.New()).toArray(Field.class);
        long[] objectFieldOffsets = XMemory.objectFieldOffsets(entityClass, (Field[])fields);
        return objectFieldOffsets;
    }

    protected AbstractBinaryHandlerReflective(Class<T> type, String typeName, XGettingEnum<Field> persistableFields, XGettingEnum<Field> persisterFields, PersistenceFieldLengthResolver lengthResolver, PersistenceEagerStoringFieldEvaluator eagerEvaluator, BinaryFieldHandlerProvider fieldHandlerProvider, boolean switchByteOrder) {
        super(type, typeName);
        this.switchByteOrder = switchByteOrder;
        this.fieldHandlerProvider = fieldHandlerProvider;
        XMemory.ensureClassInitialized(type, persistableFields);
        EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> instMembersInDeclOrdr = AbstractBinaryHandlerReflective.deriveMembers(persistableFields, lengthResolver);
        this.membersInDeclaredOrder = this.deriveAllMembers((XGettingSequence<? extends PersistenceTypeDefinitionMember>)instMembersInDeclOrdr);
        this.referenceMembers = this.filterReferenceMembers((XGettingCollection<PersistenceTypeDefinitionMemberFieldReflective>)instMembersInDeclOrdr, (EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective>)AbstractBinaryHandlerReflective.MemberEnum()).immure();
        this.primitiveMembers = this.filterPrimitiveMembers((XGettingCollection<PersistenceTypeDefinitionMemberFieldReflective>)instMembersInDeclOrdr, (EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective>)AbstractBinaryHandlerReflective.MemberEnum()).immure();
        this.storingMembers = AbstractBinaryHandlerReflective.MemberEnum(this.referenceMembers).addAll(this.primitiveMembers).immure();
        this.settingMembers = this.filterSettingMembers(this.storingMembers);
        this.storingMemoryOffsets = this.initializeStoringMemoryOffsets();
        this.settingMemoryOffsets = this.initializeSettingMemoryOffsets();
        this.refrnceMemoryOffsets = this.initializeStoringRefMemOffsets();
        this.refBinaryOffsetStart = 0L;
        this.refBinaryOffsetBound = Binary.referenceBinaryLength(this.referenceMembers.size());
        this.storers = new BinaryValueStorer[this.storingMembers.intSize()];
        AbstractBinaryHandlerReflective.createStorers(type, this.storingMembers, this.storers, eagerEvaluator, fieldHandlerProvider, switchByteOrder);
        this.setters = this.deriveSetters();
        this.binaryContentLength = AbstractBinaryHandlerReflective.calculcateBinaryContentLength(this.storingMembers);
        this.declOrderFields = AbstractBinaryHandlerReflective.unbox(instMembersInDeclOrdr, EqHashEnum.New()).immure();
        this.referenceFields = AbstractBinaryHandlerReflective.unbox(this.referenceMembers, EqHashEnum.New()).immure();
        this.primitiveFields = AbstractBinaryHandlerReflective.unbox(this.primitiveMembers, EqHashEnum.New()).immure();
        this.persisterFields = persisterFields == null || persisterFields.isEmpty() ? null : (Field[])persisterFields.toArray(Field.class);
    }

    protected long[] initializeStoringMemoryOffsets() {
        return AbstractBinaryHandlerReflective.objectFieldOffsets(this.type(), this.storingMembers);
    }

    protected long[] initializeSettingMemoryOffsets() {
        return this.storingMemoryOffsets;
    }

    protected BinaryValueSetter[] deriveSetters() {
        EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> members = this.settingMembers;
        BinaryValueSetter[] setters = new BinaryValueSetter[members.intSize()];
        int i = 0;
        for (PersistenceTypeDefinitionMemberFieldReflective member : members) {
            setters[i++] = this.deriveSetter(member);
        }
        return setters;
    }

    protected BinaryValueSetter deriveSetter(PersistenceTypeDefinitionMemberFieldReflective member) {
        BinaryFieldSetter<?> customFieldSetter = this.fieldHandlerProvider.lookupFieldSetter(member.field(), this.isSwitchedByteOrder());
        if (customFieldSetter != null) {
            return customFieldSetter;
        }
        return BinaryValueFunctions.getObjectValueSetter(member.type(), this.isSwitchedByteOrder());
    }

    protected long[] initializeStoringRefMemOffsets() {
        return AbstractBinaryHandlerReflective.objectFieldOffsets(this.type(), this.referenceMembers);
    }

    protected EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> filterSettingMembers(EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> members) {
        return members;
    }

    protected EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> filterReferenceMembers(XGettingCollection<PersistenceTypeDefinitionMemberFieldReflective> members, EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> target) {
        return (EqHashEnum)members.filterTo(target, m -> m.isReference());
    }

    protected EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> filterPrimitiveMembers(XGettingCollection<PersistenceTypeDefinitionMemberFieldReflective> members, EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> target) {
        return (EqHashEnum)members.filterTo(target, m -> m.isPrimitive());
    }

    protected EqConstHashEnum<PersistenceTypeDefinitionMember> deriveAllMembers(XGettingSequence<? extends PersistenceTypeDefinitionMember> declaredOrderInstanceMembers) {
        return EqConstHashEnum.New(declaredOrderInstanceMembers);
    }

    public final boolean isSwitchedByteOrder() {
        return this.switchByteOrder;
    }

    public XGettingEnum<Field> instanceFields() {
        return this.declOrderFields;
    }

    public XGettingEnum<Field> instancePrimitiveFields() {
        return this.primitiveFields;
    }

    public XGettingEnum<Field> instanceReferenceFields() {
        return this.referenceFields;
    }

    public final boolean isPrimitiveType() {
        return false;
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
        return this.instanceMembers();
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMemberFieldReflective> instanceMembers() {
        return this.storingMembers();
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMemberFieldReflective> storingMembers() {
        return this.storingMembers;
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMemberFieldReflective> settingMembers() {
        return this.settingMembers;
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMember> membersInDeclaredOrder() {
        return this.membersInDeclaredOrder;
    }

    public final boolean hasPersistedReferences() {
        return !this.referenceMembers.isEmpty();
    }

    public final long membersPersistedLengthMinimum() {
        return this.binaryContentLength;
    }

    public final long membersPersistedLengthMaximum() {
        return this.binaryContentLength;
    }

    public final boolean hasPersistedVariableLength() {
        return false;
    }

    public final boolean hasVaryingPersistedLengthInstances() {
        return false;
    }

    public void store(Binary data, T instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeFixedSize(handler, this.binaryContentLength, this.typeId(), objectId, instance, this.storingMemoryOffsets, this.storers);
    }

    public abstract T create(Binary var1, PersistenceLoadHandler var2);

    public void updateState(Binary data, T instance, PersistenceLoadHandler handler) {
        if (!this.type().isInstance(instance)) {
            throw new TypeCastException(this.type(), instance);
        }
        data.updateFixedSize(instance, this.setters, this.settingMemoryOffsets, handler);
        this.setPersister(instance, handler);
    }

    private void setPersister(T instance, PersistenceLoadHandler handler) {
        if (this.persisterFields == null) {
            return;
        }
        Persister persister = handler.getPersister();
        for (Field field : this.persisterFields) {
            Object existingPersister;
            if (!field.getType().isAssignableFrom(persister.getClass()) || (existingPersister = XReflect.getFieldValue((Field)field, instance)) != null) continue;
            XReflect.setFieldValue((Field)field, instance, (Object)persister);
        }
    }

    public final void complete(Binary data, T instance, PersistenceLoadHandler handler) {
    }

    public void iterateInstanceReferences(T instance, PersistenceFunction iterator) {
        BinaryPersistence.iterateInstanceReferences(iterator, instance, this.refrnceMemoryOffsets);
    }

    public void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        data.iterateReferenceRange(this.refBinaryOffsetStart, this.refBinaryOffsetBound, (PersistenceObjectIdAcceptor)iterator);
    }

    public <C extends Consumer<? super Class<?>>> C iterateMemberTypes(C logic) {
        for (Field field : this.instanceFields()) {
            logic.accept(field.getType());
        }
        return logic;
    }
}

