/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections;

import java.lang.reflect.Field;
import org.eclipse.serializer.collections.ConstHashTable;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.XCollectionsInternals;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustomCollection;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;

public final class BinaryHandlerConstHashTable
extends AbstractBinaryHandlerCustomCollection<ConstHashTable<?, ?>> {
    static final long BINARY_OFFSET_KEYS = 0L;
    static final long BINARY_OFFSET_VALUES = 0L + (long)Binary.objectIdByteLength();
    static final long BINARY_OFFSET_HASH_DENSITY = BINARY_OFFSET_VALUES + (long)Binary.objectIdByteLength();
    static final long BINARY_OFFSET_ELEMENTS = BINARY_OFFSET_HASH_DENSITY + 4L;
    static final Field FIELD_KEYS = BinaryHandlerConstHashTable.getInstanceFieldOfType(ConstHashTable.class, ConstHashTable.Keys.class);
    static final Field FIELD_VALUES = BinaryHandlerConstHashTable.getInstanceFieldOfType(ConstHashTable.class, ConstHashTable.Values.class);

    private static Class<ConstHashTable<?, ?>> handledType() {
        return ConstHashTable.class;
    }

    private static int getBuildItemElementCount(Binary data) {
        return X.checkArrayRange((long)data.getListElementCountKeyValue(BINARY_OFFSET_ELEMENTS));
    }

    private static float getBuildItemHashDensity(Binary data) {
        return data.read_float(BINARY_OFFSET_HASH_DENSITY);
    }

    public static BinaryHandlerConstHashTable New() {
        return new BinaryHandlerConstHashTable();
    }

    BinaryHandlerConstHashTable() {
        super(BinaryHandlerConstHashTable.handledType(), (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerConstHashTable.keyValuesFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerConstHashTable.CustomField(ConstHashTable.Keys.class, "keys"), BinaryHandlerConstHashTable.CustomField(ConstHashTable.Values.class, "values"), BinaryHandlerConstHashTable.CustomField(Float.TYPE, "hashDensity")}));
    }

    @Override
    public final void store(Binary data, ConstHashTable<?, ?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeKeyValuesAsEntries(this.typeId(), objectId, BINARY_OFFSET_ELEMENTS, (Iterable<? extends KeyValue<?, ?>>)instance, instance.size(), (PersistenceFunction)handler);
        data.store_long(0L, handler.apply((Object)instance.keys()));
        data.store_long(BINARY_OFFSET_VALUES, handler.apply((Object)instance.values()));
        data.store_float(BINARY_OFFSET_HASH_DENSITY, instance.hashDensity());
    }

    @Override
    public final ConstHashTable<?, ?> create(Binary data, PersistenceLoadHandler handler) {
        return ConstHashTable.NewCustom((int)BinaryHandlerConstHashTable.getBuildItemElementCount(data), (float)BinaryHandlerConstHashTable.getBuildItemHashDensity(data));
    }

    public final void updateState(Binary data, ConstHashTable<?, ?> instance, PersistenceLoadHandler handler) {
        if (instance.size() != 0L) {
            throw new IllegalStateException("Instance already contains data: " + instance);
        }
        XMemory.setObject(instance, (long)XMemory.objectFieldOffset((Field)FIELD_KEYS), (Object)data.readReference(0L, handler));
        XMemory.setObject(instance, (long)XMemory.objectFieldOffset((Field)FIELD_VALUES), (Object)data.readReference(BINARY_OFFSET_VALUES, handler));
        data.collectKeyValueReferences(BINARY_OFFSET_ELEMENTS, BinaryHandlerConstHashTable.getBuildItemElementCount(data), handler, (k, v) -> XCollectionsInternals.internalAdd(instance, k, v));
    }

    @Override
    public final void iterateInstanceReferences(ConstHashTable<?, ?> instance, PersistenceFunction iterator) {
        iterator.apply((Object)instance.keys());
        iterator.apply((Object)instance.values());
        Persistence.iterateReferences((PersistenceFunction)iterator, instance);
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        iterator.acceptObjectId(data.readObjectId(0L));
        iterator.acceptObjectId(data.readObjectId(BINARY_OFFSET_VALUES));
        data.iterateKeyValueEntriesReferences(BINARY_OFFSET_ELEMENTS, (PersistenceObjectIdAcceptor)iterator);
    }
}

