package org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.lazy;

/*-
 * #%L
 * Eclipse Serializer Persistence Binary
 * %%
 * Copyright (C) 2023 MicroStream Software
 * %%
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * #L%
 */

import java.lang.reflect.Field;

import org.eclipse.serializer.collections.lazy.LazyHashMap;
import org.eclipse.serializer.collections.lazy.LazyHashSet;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustom;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.reflect.XReflect;

public final class BinaryHandlerLazyHashSet extends AbstractBinaryHandlerCustom<LazyHashSet<?>>{

	private static final Field FIELD_MAP = getMapField();
	
	///////////////////////////////////////////////////////////////////////////
	// static methods //
	///////////////////
	
	@SuppressWarnings({"unchecked",  "rawtypes"})
	private static Class<LazyHashSet<?>> handledType()
	{
		// no idea how to get ".class" to work otherwise
		return (Class)LazyHashSet.class;
	}
	
	public static BinaryHandlerLazyHashSet New()
	{
		return new BinaryHandlerLazyHashSet();
	}
	
	///////////////////////////////////////////////////////////////////////////
	// constructors //
	/////////////////
	
	public BinaryHandlerLazyHashSet()
	{
		super(
			handledType(),
			CustomFields(
				CustomField(LazyHashMap.class, "map")
			)
		);
	}
	
	///////////////////////////////////////////////////////////////////////////
	// methods //
	////////////
	
	@Override
	public boolean hasPersistedReferences() {
		return true;
	}
	
	@Override
	public void iterateLoadableReferences(final Binary data, final PersistenceReferenceLoader iterator)
	{
		iterator.acceptObjectId(data.read_long(0));
	}

	@Override
	public void updateState(final Binary data, final LazyHashSet<?> instance, final PersistenceLoadHandler handler)
	{
		final LazyHashMap<?,?> map = (LazyHashMap<?, ?>)handler.lookupObject(data.read_long(0));
		XReflect.setFieldValue(FIELD_MAP, instance, map);
	}

	@Override
	public boolean hasVaryingPersistedLengthInstances()
	{
		return false;
	}

	@Override
	public void store(final Binary data, final LazyHashSet<?> instance, final long objectId, final PersistenceStoreHandler<Binary> handler)
	{
		data.storeEntityHeader(Binary.referenceBinaryLength(1), this.typeId(), objectId);
		data.store_long(handler.applyEager(XReflect.getFieldValue(FIELD_MAP, instance)));
	}

	@Override
	public LazyHashSet<?> create(final Binary data, final PersistenceLoadHandler handler)
	{
		return new LazyHashSet<>();
	}
	
	private static Field getMapField()
	{
		final Field field = XReflect.getAnyField(LazyHashSet.class, "map");
		return XReflect.setAccessible(field);
	}
}
