/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.functional.InstanceDispatcherLogic;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.exceptions.BinaryPersistenceException;
import org.eclipse.serializer.persistence.binary.java.io.BinaryHandlerFile;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerBoolean;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerByte;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerCharacter;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerClass;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerDouble;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerFloat;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerInteger;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerLong;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerNativeArray_boolean;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerNativeArray_byte;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerNativeArray_char;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerNativeArray_double;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerNativeArray_float;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerNativeArray_int;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerNativeArray_long;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerNativeArray_short;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerObject;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerShort;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerString;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerStringBuffer;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerStringBuilder;
import org.eclipse.serializer.persistence.binary.java.lang.BinaryHandlerVoid;
import org.eclipse.serializer.persistence.binary.java.math.BinaryHandlerBigDecimal;
import org.eclipse.serializer.persistence.binary.java.math.BinaryHandlerBigInteger;
import org.eclipse.serializer.persistence.binary.java.net.BinaryHandlerInet4Address;
import org.eclipse.serializer.persistence.binary.java.net.BinaryHandlerInet6Address;
import org.eclipse.serializer.persistence.binary.java.net.BinaryHandlerInetAddress;
import org.eclipse.serializer.persistence.binary.java.net.BinaryHandlerInetSocketAddress;
import org.eclipse.serializer.persistence.binary.java.net.BinaryHandlerURI;
import org.eclipse.serializer.persistence.binary.java.net.BinaryHandlerURL;
import org.eclipse.serializer.persistence.binary.java.nio.file.BinaryHandlerPath;
import org.eclipse.serializer.persistence.binary.java.sql.BinaryHandlerSqlDate;
import org.eclipse.serializer.persistence.binary.java.sql.BinaryHandlerSqlTime;
import org.eclipse.serializer.persistence.binary.java.sql.BinaryHandlerSqlTimestamp;
import org.eclipse.serializer.persistence.binary.java.time.BinaryHandlerZoneOffset;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerArrayDeque;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerArrayList;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerCopyOnWriteArrayList;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerCopyOnWriteArraySet;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerCurrency;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerDate;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerHashMap;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerHashSet;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerHashtable;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerIdentityHashMap;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerLinkedHashMap;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerLinkedHashSet;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerLinkedList;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerLocale;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerOptionalDouble;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerOptionalInt;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerOptionalLong;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerPriorityQueue;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerProperties;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerStack;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerTreeMap;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerTreeSet;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerVector;
import org.eclipse.serializer.persistence.binary.java.util.BinaryHandlerWeakHashMap;
import org.eclipse.serializer.persistence.binary.java.util.concurrent.BinaryHandlerConcurrentHashMap;
import org.eclipse.serializer.persistence.binary.java.util.concurrent.BinaryHandlerConcurrentLinkedDeque;
import org.eclipse.serializer.persistence.binary.java.util.concurrent.BinaryHandlerConcurrentLinkedQueue;
import org.eclipse.serializer.persistence.binary.java.util.concurrent.BinaryHandlerConcurrentSkipListMap;
import org.eclipse.serializer.persistence.binary.java.util.concurrent.BinaryHandlerConcurrentSkipListSet;
import org.eclipse.serializer.persistence.binary.java.util.regex.BinaryHandlerPattern;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerBulkList;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerConstHashEnum;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerConstHashTable;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerConstList;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerEqBulkList;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerEqConstHashEnum;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerEqConstHashTable;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerEqHashEnum;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerEqHashTable;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerFixedList;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerHashEnum;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerHashTable;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerLimitList;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.BinaryHandlerSingleton;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.lazy.BinaryHandlerLazyArrayList;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.lazy.BinaryHandlerLazyHashMap;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.lazy.BinaryHandlerLazyHashMapSegmentEntryList;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.lazy.BinaryHandlerLazyHashSet;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.reference.BinaryHandlerControlledLazy;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.reference.BinaryHandlerLazyDefault;
import org.eclipse.serializer.persistence.binary.org.eclipse.serializer.util.BinaryHandlerSubstituterDefault;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustom;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldLengthResolver;
import org.eclipse.serializer.persistence.binary.types.BinaryHandlerPrimitive;
import org.eclipse.serializer.persistence.binary.types.BinaryHandlerSingletonStatelessEnum;
import org.eclipse.serializer.persistence.binary.types.BinaryHandlerStatelessConstant;
import org.eclipse.serializer.persistence.binary.types.BinaryPersistenceFoundation;
import org.eclipse.serializer.persistence.binary.types.BinaryTypeHandler;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceCustomTypeHandlerRegistry;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceSizedArrayLengthController;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionary;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryFileHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryLoader;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandlerCreator;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandlerManager;
import org.eclipse.serializer.persistence.types.PersistenceTypeIdLookup;
import org.eclipse.serializer.reference.Referencing;
import org.eclipse.serializer.reference.Swizzling;
import org.eclipse.serializer.typing.XTypes;

public final class BinaryPersistence
extends Persistence {
    public static BinaryPersistenceFoundation<?> Foundation() {
        return BinaryPersistence.Foundation(null);
    }

    public static BinaryPersistenceFoundation<?> Foundation(InstanceDispatcherLogic dispatcher) {
        BinaryPersistenceFoundation foundation = (BinaryPersistenceFoundation)BinaryPersistenceFoundation.New().setInstanceDispatcher(dispatcher);
        return foundation;
    }

    public static final PersistenceCustomTypeHandlerRegistry<Binary> createDefaultCustomTypeHandlerRegistry(Referencing<PersistenceTypeHandlerManager<Binary>> typeHandlerManager, PersistenceSizedArrayLengthController controller, PersistenceTypeHandlerCreator<Binary> typeHandlerCreator, XGettingCollection<? extends PersistenceTypeHandler<Binary, ?>> customHandlers) {
        XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> nativeHandlersValueTypes = BinaryPersistence.createNativeHandlersValueTypes(typeHandlerManager, controller, typeHandlerCreator);
        XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> nativeHandlersReferencingTypes = BinaryPersistence.createNativeHandlersReferencingTypes(typeHandlerManager, controller, typeHandlerCreator);
        PersistenceCustomTypeHandlerRegistry.Default defaultCustomTypeHandlerRegistry = PersistenceCustomTypeHandlerRegistry.New().registerTypeHandlers(nativeHandlersValueTypes).registerTypeHandlers(nativeHandlersReferencingTypes).registerTypeHandlers(BinaryPersistence.defaultCustomHandlers(controller)).registerTypeHandlers(BinaryPersistence.lazyCollectionsHandlers()).registerTypeHandlers(customHandlers);
        return defaultCustomTypeHandlerRegistry;
    }

    static final void initializeNativeTypeId(PersistenceTypeHandler<Binary, ?> typeHandler, PersistenceTypeIdLookup nativeTypeIdLookup) {
        long nativeTypeId = nativeTypeIdLookup.lookupTypeId(typeHandler.type());
        if (Swizzling.isNotFoundId((long)nativeTypeId)) {
            throw new BinaryPersistenceException("No native TypeId found for type " + typeHandler.type());
        }
        typeHandler.initialize(nativeTypeId);
    }

    public static final XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> createNativeHandlersValueTypes(Referencing<PersistenceTypeHandlerManager<Binary>> typeHandlerManager, PersistenceSizedArrayLengthController controller, PersistenceTypeHandlerCreator<Binary> typeHandlerCreator) {
        ConstList nativeHandlersValueTypes = ConstList.New((Object[])new BinaryTypeHandler.Abstract[]{BinaryHandlerPrimitive.New(Byte.TYPE), BinaryHandlerPrimitive.New(Boolean.TYPE), BinaryHandlerPrimitive.New(Short.TYPE), BinaryHandlerPrimitive.New(Character.TYPE), BinaryHandlerPrimitive.New(Integer.TYPE), BinaryHandlerPrimitive.New(Float.TYPE), BinaryHandlerPrimitive.New(Long.TYPE), BinaryHandlerPrimitive.New(Double.TYPE), BinaryHandlerClass.New(typeHandlerManager), BinaryHandlerByte.New(), BinaryHandlerBoolean.New(), BinaryHandlerShort.New(), BinaryHandlerCharacter.New(), BinaryHandlerInteger.New(), BinaryHandlerFloat.New(), BinaryHandlerLong.New(), BinaryHandlerDouble.New(), BinaryHandlerVoid.New(), BinaryHandlerObject.New(), BinaryHandlerString.New(), BinaryHandlerStringBuffer.New(), BinaryHandlerStringBuilder.New(), BinaryHandlerNativeArray_byte.New(), BinaryHandlerNativeArray_boolean.New(), BinaryHandlerNativeArray_short.New(), BinaryHandlerNativeArray_char.New(), BinaryHandlerNativeArray_int.New(), BinaryHandlerNativeArray_float.New(), BinaryHandlerNativeArray_long.New(), BinaryHandlerNativeArray_double.New(), BinaryHandlerBigInteger.New(), BinaryHandlerBigDecimal.New(), BinaryHandlerFile.New(), BinaryHandlerDate.New(), BinaryHandlerLocale.New(), BinaryHandlerCurrency.New(), BinaryHandlerPattern.New(), BinaryHandlerInetAddress.New(), BinaryHandlerInet4Address.New(), BinaryHandlerInet6Address.New(), BinaryHandlerPath.New(), BinaryHandlerInetSocketAddress.New(), BinaryHandlerURI.New(), BinaryHandlerURL.New(), BinaryHandlerZoneOffset.New(), BinaryHandlerSqlDate.New(), BinaryHandlerSqlTime.New(), BinaryHandlerSqlTimestamp.New(), BinaryHandlerOptionalInt.New(), BinaryHandlerOptionalLong.New(), BinaryHandlerOptionalDouble.New(), BinaryHandlerStatelessConstant.New(Collections.emptyNavigableSet()), BinaryHandlerStatelessConstant.New(Collections.emptyNavigableMap()), BinaryHandlerStatelessConstant.New(Collections.reverseOrder())});
        return nativeHandlersValueTypes;
    }

    public static final XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> createNativeHandlersReferencingTypes(Referencing<PersistenceTypeHandlerManager<Binary>> typeHandlerManager, PersistenceSizedArrayLengthController controller, PersistenceTypeHandlerCreator<Binary> typeHandlerCreator) {
        ConstList nativeHandlers = ConstList.New((Object[])new PersistenceTypeHandler[]{BinaryHandlerVector.New(), BinaryHandlerStack.New(), BinaryHandlerHashtable.New(), BinaryHandlerProperties.New(), BinaryHandlerArrayList.New(), BinaryHandlerHashSet.New(), BinaryHandlerHashMap.New(), BinaryHandlerWeakHashMap.New(), BinaryHandlerLinkedList.New(), BinaryHandlerTreeMap.New(), BinaryHandlerTreeSet.New(), BinaryHandlerIdentityHashMap.New(), BinaryHandlerLinkedHashMap.New(), BinaryHandlerLinkedHashSet.New(), BinaryHandlerPriorityQueue.New(), BinaryHandlerConcurrentHashMap.New(), BinaryHandlerConcurrentLinkedQueue.New(), BinaryHandlerCopyOnWriteArrayList.New(), BinaryHandlerCopyOnWriteArraySet.New(), BinaryHandlerSingletonStatelessEnum.New(Comparator.naturalOrder().getClass()), BinaryHandlerArrayDeque.New(), BinaryHandlerConcurrentSkipListMap.New(), BinaryHandlerConcurrentSkipListSet.New(), BinaryHandlerConcurrentLinkedDeque.New(), BinaryHandlerLazyDefault.New(), typeHandlerCreator.createTypeHandlerGeneric(Optional.class)});
        return nativeHandlers;
    }

    public static final XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> defaultCustomHandlers(PersistenceSizedArrayLengthController controller) {
        ConstList defaultHandlers = ConstList.New((Object[])new AbstractBinaryHandlerCustom[]{BinaryHandlerBulkList.New(controller), BinaryHandlerLimitList.New(controller), BinaryHandlerFixedList.New(), BinaryHandlerConstList.New(), BinaryHandlerEqBulkList.New(controller), BinaryHandlerHashEnum.New(), BinaryHandlerConstHashEnum.New(), BinaryHandlerEqHashEnum.New(), BinaryHandlerEqConstHashEnum.New(), BinaryHandlerHashTable.New(), BinaryHandlerConstHashTable.New(), BinaryHandlerEqHashTable.New(), BinaryHandlerEqConstHashTable.New(), BinaryHandlerSingleton.New(), BinaryHandlerSubstituterDefault.New()});
        return defaultHandlers;
    }

    public static final XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> lazyCollectionsHandlers() {
        ConstList lazyCollectionsHandlers = ConstList.New((Object[])new AbstractBinaryHandlerCustom[]{BinaryHandlerLazyArrayList.New(), BinaryHandlerLazyHashMap.New(), BinaryHandlerLazyHashMapSegmentEntryList.New(), BinaryHandlerLazyHashSet.New(), BinaryHandlerControlledLazy.New()});
        return lazyCollectionsHandlers;
    }

    public static final long resolveFieldBinaryLength(Class<?> fieldType) {
        return fieldType.isPrimitive() ? BinaryPersistence.resolvePrimitiveFieldBinaryLength(fieldType) : (long)Binary.objectIdByteLength();
    }

    public static final long resolvePrimitiveFieldBinaryLength(Class<?> primitiveType) {
        return XMemory.byteSizePrimitive(primitiveType);
    }

    public static final BinaryFieldLengthResolver createFieldLengthResolver() {
        return new BinaryFieldLengthResolver.Default();
    }

    public static PersistenceTypeDictionary provideTypeDictionaryFromFile(AFile dictionaryFile) {
        BinaryPersistenceFoundation f = (BinaryPersistenceFoundation)BinaryPersistenceFoundation.New().setTypeDictionaryLoader((PersistenceTypeDictionaryLoader)PersistenceTypeDictionaryFileHandler.New((AFile)dictionaryFile));
        return f.getTypeDictionaryProvider().provideTypeDictionary();
    }

    public static final int binaryValueSize(Class<?> type) {
        return type.isPrimitive() ? XMemory.byteSizePrimitive(type) : Binary.objectIdByteLength();
    }

    public static int[] calculateBinarySizes(XGettingSequence<Field> fields) {
        final int[] fieldOffsets = new int[XTypes.to_int((long)fields.size())];
        fields.iterateIndexed((IndexedAcceptor)new IndexedAcceptor<Field>(){

            public void accept(Field e, long index) {
                fieldOffsets[(int)index] = BinaryPersistence.binaryValueSize(e.getType());
            }
        });
        return fieldOffsets;
    }

    public static final void iterateInstanceReferences(PersistenceFunction iterator, Object instance, long[] referenceOffsets) {
        for (int i = 0; i < referenceOffsets.length; ++i) {
            if (referenceOffsets[i] == 0L) continue;
            iterator.apply(XMemory.getObject((Object)instance, (long)referenceOffsets[i]));
        }
    }

    private BinaryPersistence() {
        throw new UnsupportedOperationException();
    }
}

