/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryEntityDataReader;
import org.eclipse.serializer.persistence.binary.types.BinaryReferenceTraverser;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;

public class BinaryLoadItem
extends Binary {
    PersistenceTypeHandler<Binary, Object> handler;
    Object existingInstance;
    Object createdInstance;
    BinaryLoadItem next;
    BinaryLoadItem link;

    BinaryLoadItem(long entityContentAddress) {
        this.address = entityContentAddress;
    }

    BinaryLoadItem(long objectId, Object existingInstance) {
        this(-objectId);
        this.existingInstance = existingInstance;
    }

    public final boolean hasData() {
        return this.handler != null;
    }

    @Override
    final long loadItemEntityContentAddress() {
        return this.address;
    }

    @Override
    public final long iterateReferences(BinaryReferenceTraverser[] traversers, PersistenceObjectIdAcceptor acceptor) {
        if (!this.isProper()) {
            throw new Error("Improper items cannot iterate references.");
        }
        long a = this.address;
        for (int i = 0; i < traversers.length; ++i) {
            a = traversers[i].apply(a, acceptor);
        }
        return a;
    }

    @Override
    public final void modifyLoadItem(ByteBuffer directByteBuffer, long offset, long entityTotalLength, long entityTypeId, long entityObjectId) {
        long entityAddress = this.calculateAddress(directByteBuffer, offset);
        this.address = BinaryLoadItem.toEntityContentOffset(entityAddress);
        this.storeEntityHeaderToAddress(entityAddress, entityTotalLength, entityTypeId, entityObjectId);
    }

    public String toString() {
        return "LoadItem OID=" + (this.isDummyItem() ? " [Dummy]" : Long.toString(this.getBuildItemObjectId())) + (String)(this.handler == null ? " [no handler]" : ", Type=" + this.handler.typeId() + " " + this.handler.typeName());
    }

    @Override
    public final void storeEntityHeader(long entityContentLength, long entityTypeId, long entityObjectId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ByteBuffer[] buffers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long totalLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Binary channelChunk(int channelIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int channelCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void iterateEntityData(BinaryEntityDataReader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void iterateChannelChunks(Consumer<? super Binary> logic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mark() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }
}

