/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import org.eclipse.serializer.collections.Constant;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerTrivial;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryPersistence;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberPrimitiveDefinition;
import org.eclipse.serializer.util.X;

public final class BinaryHandlerPrimitive<T>
extends AbstractBinaryHandlerTrivial<T> {
    private final Constant<PersistenceTypeDefinitionMemberPrimitiveDefinition> member;

    public static <T> BinaryHandlerPrimitive<T> New(Class<T> type) {
        return new BinaryHandlerPrimitive<T>((Class)X.notNull(type));
    }

    BinaryHandlerPrimitive(Class<T> type) {
        super(type);
        long primitiveBinaryLength = BinaryPersistence.resolvePrimitiveFieldBinaryLength(type);
        this.member = X.Constant((Object)PersistenceTypeDefinitionMemberPrimitiveDefinition.New(type, (long)primitiveBinaryLength));
    }

    @Override
    public final XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
        return this.member;
    }

    @Override
    public final XGettingEnum<? extends PersistenceTypeDefinitionMemberPrimitiveDefinition> instanceMembers() {
        return X.empty();
    }

    @Override
    public final long membersPersistedLengthMinimum() {
        return ((PersistenceTypeDefinitionMemberPrimitiveDefinition)this.member.get()).persistentMinimumLength();
    }

    @Override
    public final long membersPersistedLengthMaximum() {
        return ((PersistenceTypeDefinitionMemberPrimitiveDefinition)this.member.get()).persistentMaximumLength();
    }

    @Override
    public final boolean isPrimitiveType() {
        return true;
    }

    public void store(Binary data, T instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        throw new UnsupportedOperationException();
    }

    public T create(Binary data, PersistenceLoadHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateState(Binary data, T instance, PersistenceLoadHandler handler) {
        throw new UnsupportedOperationException();
    }
}

