/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.org.eclipse.serializer.collections.lazy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.serializer.collections.lazy.LazyHashMap;
import org.eclipse.serializer.collections.lazy.LazySegmentUnloader;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustomCollection;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import org.eclipse.serializer.reflect.XReflect;

public final class BinaryHandlerLazyHashMap
extends AbstractBinaryHandlerCustomCollection<LazyHashMap<?, ?>> {
    static final long BINARY_OFFSET_MAXSEGMENTSIZE = 0L;
    static final long BINARY_OFFSET_SIZE = 4L;
    static final long BINARY_OFFSET_UNLOADER = 8L;
    static final long BINARY_OFFSET_SEGMENTS = 8L + Binary.referenceBinaryLength(1L);
    private static final long OFFSET_MaxSegmentSize = BinaryHandlerLazyHashMap.getFieldOffset(LazyHashMap.class, "maxSegmentSize");
    private static final long OFFSET_ArrayList_size = BinaryHandlerLazyHashMap.getFieldOffset(LazyHashMap.class, "size");
    private static final long OFFSET_ArrayList_unloader = BinaryHandlerLazyHashMap.getFieldOffset(LazyHashMap.class, "unloader");
    private static final long OFFSET_Segment_min = BinaryHandlerLazyHashMap.getFieldOffset(LazyHashMap.Segment.class, "min");
    private static final long OFFSET_Segment_max = BinaryHandlerLazyHashMap.getFieldOffset(LazyHashMap.Segment.class, "max");
    private static final long OFFSET_Segment_size = BinaryHandlerLazyHashMap.getFieldOffset(LazyHashMap.Segment.class, "segmentSize");
    private static final Method METHOD_Segment_getData = BinaryHandlerLazyHashMap.getDeclaredMethod(LazyHashMap.Segment.class, "getLazyData", new Class[0]);
    private static final Method METHOD_Segment_getLazy = BinaryHandlerLazyHashMap.getDeclaredMethod(LazyHashMap.Segment.class, "getLazy", new Class[0]);
    private static final Method METHOD_Segement_cleanDirtyFlag = BinaryHandlerLazyHashMap.getDeclaredMethod(LazyHashMap.Segment.class, "cleanModified", new Class[0]);
    private static final Method METHOD_LazyHashMap_addSegment = BinaryHandlerLazyHashMap.getDeclaredMethod(LazyHashMap.class, "addSegment", Integer.TYPE, Integer.TYPE, Integer.TYPE, Object.class);
    private static final long BINARY_MAP_FIELDS_LENGTH = 8L + Binary.referenceBinaryLength(1L);
    private static final long BINARY_SEGMENT_LENGTH = 12L + Binary.referenceBinaryLength(1L);

    private static Class<LazyHashMap<?, ?>> handledType() {
        return LazyHashMap.class;
    }

    public static BinaryHandlerLazyHashMap New() {
        return new BinaryHandlerLazyHashMap();
    }

    public BinaryHandlerLazyHashMap() {
        super(BinaryHandlerLazyHashMap.handledType(), (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerLazyHashMap.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerLazyHashMap.CustomField(Integer.TYPE, "maxSegmentSize"), BinaryHandlerLazyHashMap.CustomField(Integer.TYPE, "size"), BinaryHandlerLazyHashMap.CustomField(LazySegmentUnloader.class, "unloader"), BinaryHandlerLazyHashMap.Complex("segments", new PersistenceTypeDescriptionMemberFieldGeneric[]{BinaryHandlerLazyHashMap.CustomField(Integer.TYPE, "min"), BinaryHandlerLazyHashMap.CustomField(Integer.TYPE, "max"), BinaryHandlerLazyHashMap.CustomField(Integer.TYPE, "size"), BinaryHandlerLazyHashMap.CustomField(LazyHashMap.LazyHashMapSegmentEntryList.class, "data")})}));
    }

    @Override
    public LazyHashMap<?, ?> create(Binary data, PersistenceLoadHandler handler) {
        return new LazyHashMap();
    }

    public void updateState(Binary data, LazyHashMap<?, ?> instance, PersistenceLoadHandler handler) {
        instance.verifyLoader(handler.getObjectRetriever());
        instance.link(handler.getObjectRetriever());
        instance.clear();
        int maxSegmentSize = data.read_int(0L);
        XMemory.set_int(instance, (long)OFFSET_MaxSegmentSize, (int)maxSegmentSize);
        int size = data.read_int(4L);
        XMemory.set_int(instance, (long)OFFSET_ArrayList_size, (int)size);
        long unloderId = data.read_long(8L);
        Object unloader = handler.lookupObject(unloderId);
        XMemory.setObject(instance, (long)OFFSET_ArrayList_unloader, (Object)unloader);
        int segmentCount = (int)data.getBinaryListElementCountValidating(BINARY_OFFSET_SEGMENTS, BINARY_SEGMENT_LENGTH);
        long elementsDataOffset = Binary.toBinaryListElementsOffset(BINARY_OFFSET_SEGMENTS);
        for (int i = 0; i < segmentCount; ++i) {
            int min = data.read_int(elementsDataOffset);
            int max = data.read_int(elementsDataOffset += 4L);
            int segmentSize = data.read_int(elementsDataOffset += 4L);
            long refId = data.read_long(elementsDataOffset += 4L);
            elementsDataOffset += Binary.referenceBinaryLength(1L);
            Object ref = handler.lookupObject(refId);
            XReflect.invoke((Method)METHOD_LazyHashMap_addSegment, instance, (Object[])new Object[]{min, max, segmentSize, ref});
        }
    }

    @Override
    public void store(Binary data, LazyHashMap<?, ?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        instance.verifyLoader(handler.getObjectRetriever());
        instance.link(handler.getObjectRetriever());
        long segmentListContentLength = BINARY_SEGMENT_LENGTH * instance.getSegmentCount();
        long segmentListTotalLength = Binary.toBinaryListTotalByteLength(segmentListContentLength);
        long totalLength = BINARY_MAP_FIELDS_LENGTH + segmentListTotalLength;
        data.storeEntityHeader(totalLength, this.typeId(), objectId);
        data.store_int(0L, instance.getMaxSegmentSize());
        data.store_int(4L, instance.size());
        data.store_long(8L, handler.apply(XMemory.getObject(instance, (long)OFFSET_ArrayList_unloader)));
        data.storeListHeader(BINARY_OFFSET_SEGMENTS, segmentListContentLength, instance.getSegmentCount());
        long elementsDataOffset = Binary.toBinaryListElementsOffset(BINARY_OFFSET_SEGMENTS);
        for (LazyHashMap.Segment segment : instance.segments()) {
            data.store_int(elementsDataOffset, XMemory.get_int((Object)segment, (long)OFFSET_Segment_min));
            data.store_int(elementsDataOffset += 4L, XMemory.get_int((Object)segment, (long)OFFSET_Segment_max));
            data.store_int(elementsDataOffset += 4L, XMemory.get_int((Object)segment, (long)OFFSET_Segment_size));
            data.store_long(elementsDataOffset += 4L, handler.apply(XReflect.invoke((Method)METHOD_Segment_getLazy, (Object)segment, (Object[])new Object[0])));
            elementsDataOffset += Binary.referenceBinaryLength(1L);
            if (!segment.isLoaded() || !segment.isModified()) continue;
            handler.applyEager(XReflect.invoke((Method)METHOD_Segment_getData, (Object)segment, (Object[])new Object[0]));
            XReflect.invoke((Method)METHOD_Segement_cleanDirtyFlag, (Object)segment, (Object[])new Object[0]);
        }
    }

    @Override
    public void iterateInstanceReferences(LazyHashMap<?, ?> instance, PersistenceFunction iterator) {
        super.iterateInstanceReferences(instance, iterator);
    }

    public void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        Binary.iterateListStructureCompositeElements(data, BINARY_OFFSET_SEGMENTS, 12, 1, 0, iterator);
        iterator.acceptObjectId(data.read_long(8L));
    }

    private static final long getFieldOffset(Class<?> type, String declaredFieldName) {
        return XMemory.objectFieldOffset((Field)XReflect.getAnyField(type, (String)declaredFieldName));
    }

    private static final Method getDeclaredMethod(Class<?> c, String name, Class<?> ... parameterTypes) {
        return XReflect.setAccessible((Method)XReflect.getDeclaredMethod(c, (String)name, (Class[])parameterTypes));
    }
}

