/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.BinaryLoadItem;

public final class BinaryLoadItemByteReversing
extends BinaryLoadItem {
    BinaryLoadItemByteReversing(long entityContentAddress) {
        super(entityContentAddress);
    }

    @Override
    public final boolean isSwitchedByteOrder() {
        return true;
    }

    @Override
    final short get_shortfromAddress(long address) {
        return Short.reverseBytes(XMemory.get_short((long)address));
    }

    @Override
    final char get_charFromAddress(long address) {
        return Character.reverseBytes(XMemory.get_char((long)address));
    }

    @Override
    final int get_intFromAddress(long address) {
        return Integer.reverseBytes(XMemory.get_int((long)address));
    }

    @Override
    final float get_floatFromAddress(long address) {
        return Float.intBitsToFloat(Integer.reverseBytes(XMemory.get_int((long)address)));
    }

    @Override
    final long get_longFromAddress(long address) {
        return Long.reverseBytes(XMemory.get_long((long)address));
    }

    @Override
    final double get_doubleFromAddress(long address) {
        return Double.longBitsToDouble(Long.reverseBytes(XMemory.get_long((long)address)));
    }

    @Override
    final void set_shortToAddress(long address, short value) {
        XMemory.set_short((long)address, (short)Short.reverseBytes(value));
    }

    @Override
    final void set_charToAddress(long address, char value) {
        XMemory.set_char((long)address, (char)Character.reverseBytes(value));
    }

    @Override
    final void set_intToAddress(long address, int value) {
        XMemory.set_int((long)address, (int)Integer.reverseBytes(value));
    }

    @Override
    final void set_floatToAddress(long address, float value) {
        XMemory.set_int((long)address, (int)Integer.reverseBytes(Float.floatToRawIntBits(value)));
    }

    @Override
    final void set_longToAddress(long address, long value) {
        XMemory.set_long((long)address, (long)Long.reverseBytes(value));
    }

    @Override
    final void set_doubleToAddress(long address, double value) {
        XMemory.set_long((long)address, (long)Long.reverseBytes(Double.doubleToRawLongBits(value)));
    }

    @Override
    final void update_shortsFromAddress(long address, short[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = this.get_shortfromAddress(address + (long)(i * 2));
        }
    }

    @Override
    final void update_charsFromAddress(long address, char[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = this.get_charFromAddress(address + (long)(i * 2));
        }
    }

    @Override
    final void update_intsFromAddress(long address, int[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = this.get_intFromAddress(address + (long)(i * 4));
        }
    }

    @Override
    final void update_floatsFromAddress(long address, float[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = this.get_floatFromAddress(address + (long)(i * 4));
        }
    }

    @Override
    public final void update_longsFromAddress(long address, long[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = this.get_longFromAddress(address + (long)(i * 8));
        }
    }

    @Override
    final void update_doublesFromAddress(long address, double[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = this.get_doubleFromAddress(address + (long)(i * 8));
        }
    }

    @Override
    final void store_shortsToAddress(long address, short[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.set_shortToAddress(address + (long)(i * 2), values[i]);
        }
    }

    @Override
    final void store_charsToAddress(long address, char[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.set_charToAddress(address + (long)(i * 2), values[i]);
        }
    }

    @Override
    final void store_intsToAddress(long address, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.set_intToAddress(address + (long)(i * 4), values[i]);
        }
    }

    @Override
    final void store_floatsToAddress(long address, float[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.set_floatToAddress(address + (long)(i * 4), values[i]);
        }
    }

    @Override
    final void store_longsToAddress(long address, long[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.set_longToAddress(address + (long)(i * 8), values[i]);
        }
    }

    @Override
    final void store_doublesToAddress(long address, double[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.set_doubleToAddress(address + (long)(i * 8), values[i]);
        }
    }

    @Override
    final void storeEntityHeaderToAddress(long entityAddress, long entityTotalLength, long entityTypeId, long entityObjectId) {
        BinaryLoadItemByteReversing.setEntityHeaderRawValuesToAddress(entityAddress, Long.reverseBytes(entityTotalLength), Long.reverseBytes(entityTypeId), Long.reverseBytes(entityObjectId));
    }
}

