/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import java.util.Iterator;
import java.util.Optional;
import org.eclipse.serializer.collections.HashTable;
import org.eclipse.serializer.collections.types.XGettingMap;
import org.eclipse.serializer.configuration.types.ConfigurationValueMapper;
import org.eclipse.serializer.util.X;

public interface ConfigurationValueMapperProvider
extends Iterable<ConfigurationValueMapper<?>> {
    public <T> ConfigurationValueMapper<T> get(Class<T> var1);

    public <T> Optional<ConfigurationValueMapper<T>> opt(Class<T> var1);

    public static Builder Builder() {
        return new Builder.Default();
    }

    public static Builder Default() {
        return ConfigurationValueMapperProvider.Builder().add(ConfigurationValueMapper.Boolean()).add(ConfigurationValueMapper.Byte()).add(ConfigurationValueMapper.Short()).add(ConfigurationValueMapper.Integer()).add(ConfigurationValueMapper.Long()).add(ConfigurationValueMapper.Float()).add(ConfigurationValueMapper.Double()).add(ConfigurationValueMapper.ByteSize()).add(ConfigurationValueMapper.Duration());
    }

    public static ConfigurationValueMapperProvider New(XGettingMap<Class<?>, ConfigurationValueMapper<?>> table) {
        return new Default((XGettingMap<Class<?>, ConfigurationValueMapper<?>>)((XGettingMap)X.notNull(table)).immure());
    }

    public static class Default
    implements ConfigurationValueMapperProvider {
        private final XGettingMap<Class<?>, ConfigurationValueMapper<?>> table;

        Default(XGettingMap<Class<?>, ConfigurationValueMapper<?>> table) {
            this.table = table;
        }

        @Override
        public Iterator<ConfigurationValueMapper<?>> iterator() {
            return this.table.values().iterator();
        }

        @Override
        public <T> ConfigurationValueMapper<T> get(Class<T> type) {
            return (ConfigurationValueMapper)this.table.get(type);
        }

        @Override
        public <T> Optional<ConfigurationValueMapper<T>> opt(Class<T> type) {
            return Optional.ofNullable(this.get(type));
        }
    }

    public static interface Builder {
        public <T> Builder add(ConfigurationValueMapper<T> var1);

        public ConfigurationValueMapperProvider build();

        public static class Default
        implements Builder {
            private final HashTable<Class<?>, ConfigurationValueMapper<?>> table = HashTable.New();

            Default() {
            }

            @Override
            public <T> Builder add(ConfigurationValueMapper<T> mapper) {
                this.table.put(mapper.type(), mapper);
                return this;
            }

            @Override
            public ConfigurationValueMapperProvider build() {
                return ConfigurationValueMapperProvider.New(this.table);
            }
        }
    }
}

