/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import java.time.Duration;
import org.eclipse.serializer.configuration.exceptions.ConfigurationExceptionValueMappingFailed;
import org.eclipse.serializer.configuration.types.ByteSize;
import org.eclipse.serializer.configuration.types.ByteSizeParser;
import org.eclipse.serializer.configuration.types.ByteUnit;
import org.eclipse.serializer.configuration.types.Configuration;
import org.eclipse.serializer.configuration.types.ConfigurationValueMappingFunction;
import org.eclipse.serializer.configuration.types.DurationParser;
import org.eclipse.serializer.configuration.types.DurationUnit;
import org.eclipse.serializer.util.X;

public interface ConfigurationValueMapper<T>
extends ConfigurationValueMappingFunction<T> {
    public Class<T> type();

    public static ConfigurationValueMapper<Boolean> Boolean() {
        return ConfigurationValueMapper.New(Boolean.class, (config, key, value) -> value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value)));
    }

    public static ConfigurationValueMapper<Byte> Byte() {
        return ConfigurationValueMapper.New(Byte.class, (config, key, value) -> {
            try {
                return Byte.parseByte(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationExceptionValueMappingFailed(config, e, key, value);
            }
        });
    }

    public static ConfigurationValueMapper<Short> Short() {
        return ConfigurationValueMapper.New(Short.class, (config, key, value) -> {
            try {
                return Short.parseShort(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationExceptionValueMappingFailed(config, e, key, value);
            }
        });
    }

    public static ConfigurationValueMapper<Integer> Integer() {
        return ConfigurationValueMapper.New(Integer.class, (config, key, value) -> {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationExceptionValueMappingFailed(config, e, key, value);
            }
        });
    }

    public static ConfigurationValueMapper<Long> Long() {
        return ConfigurationValueMapper.New(Long.class, (config, key, value) -> {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationExceptionValueMappingFailed(config, e, key, value);
            }
        });
    }

    public static ConfigurationValueMapper<Float> Float() {
        return ConfigurationValueMapper.New(Float.class, (config, key, value) -> {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationExceptionValueMappingFailed(config, e, key, value);
            }
        });
    }

    public static ConfigurationValueMapper<Double> Double() {
        return ConfigurationValueMapper.New(Double.class, (config, key, value) -> {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationExceptionValueMappingFailed(config, e, key, value);
            }
        });
    }

    public static ConfigurationValueMapper<ByteSize> ByteSize() {
        ByteSizeParser parser = ByteSizeParser.New();
        return ConfigurationValueMapper.New(ByteSize.class, (config, key, value) -> {
            try {
                return parser.parse(value);
            }
            catch (Exception e) {
                throw new ConfigurationExceptionValueMappingFailed(config, e, key, value);
            }
        });
    }

    public static ConfigurationValueMapper<ByteSize> ByteSize(ByteUnit defaultUnit) {
        ByteSizeParser parser = ByteSizeParser.New(defaultUnit);
        return ConfigurationValueMapper.New(ByteSize.class, (config, key, value) -> {
            try {
                return parser.parse(value);
            }
            catch (Exception e) {
                throw new ConfigurationExceptionValueMappingFailed(config, e, key, value);
            }
        });
    }

    public static ConfigurationValueMapper<Duration> Duration() {
        DurationParser parser = DurationParser.New();
        return ConfigurationValueMapper.New(Duration.class, (config, key, value) -> {
            try {
                return parser.parse(value);
            }
            catch (Exception e) {
                throw new ConfigurationExceptionValueMappingFailed(config, e, key, value);
            }
        });
    }

    public static ConfigurationValueMapper<Duration> Duration(DurationUnit defaultUnit) {
        DurationParser parser = DurationParser.New(defaultUnit);
        return ConfigurationValueMapper.New(Duration.class, (config, key, value) -> {
            try {
                return parser.parse(value);
            }
            catch (Exception e) {
                throw new ConfigurationExceptionValueMappingFailed(config, e, key, value);
            }
        });
    }

    public static <T> ConfigurationValueMapper<T> New(Class<T> type, ConfigurationValueMappingFunction<T> mappingFunction) {
        return new Default((Class)X.notNull(type), (ConfigurationValueMappingFunction)X.notNull(mappingFunction));
    }

    public static class Default<T>
    implements ConfigurationValueMapper<T> {
        private final Class<T> type;
        private final ConfigurationValueMappingFunction<T> mappingFunction;

        Default(Class<T> type, ConfigurationValueMappingFunction<T> mappingFunction) {
            this.type = type;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public Class<T> type() {
            return this.type;
        }

        @Override
        public T map(Configuration config, String key, String value) {
            return this.mappingFunction.map(config, key, value);
        }
    }
}

