/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.serializer.exceptions.IORuntimeException;
import org.eclipse.serializer.util.X;

@FunctionalInterface
public interface ConfigurationStorer {
    public void storeConfiguration(String var1);

    public static ConfigurationStorer New(Path path) {
        return ConfigurationStorer.New(path, Defaults.defaultCharset());
    }

    public static ConfigurationStorer New(Path path, Charset charset) {
        return new PathStorer((Path)X.notNull((Object)path), (Charset)X.notNull((Object)charset));
    }

    public static ConfigurationStorer New(File file) {
        return ConfigurationStorer.New(file, Defaults.defaultCharset());
    }

    public static ConfigurationStorer New(File file, Charset charset) {
        return new FileStorer((File)X.notNull((Object)file), (Charset)X.notNull((Object)charset));
    }

    public static ConfigurationStorer New(URL url) {
        return ConfigurationStorer.New(url, Defaults.defaultCharset());
    }

    public static ConfigurationStorer New(URL url, Charset charset) {
        return new UrlStorer((URL)X.notNull((Object)url), (Charset)X.notNull((Object)charset));
    }

    public static ConfigurationStorer New(OutputStream outputStream) {
        return ConfigurationStorer.New(outputStream, Defaults.defaultCharset());
    }

    public static ConfigurationStorer New(OutputStream outputStream, Charset charset) {
        return new OutputStreamStorer((OutputStream)X.notNull((Object)outputStream), (Charset)X.notNull((Object)charset));
    }

    public static class FileStorer
    implements ConfigurationStorer {
        private final File file;
        private final Charset charset;

        FileStorer(File file, Charset charset) {
            this.file = file;
            this.charset = charset;
        }

        @Override
        public void storeConfiguration(String configurationData) {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.charset);){
                writer.write(configurationData);
                writer.flush();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static class PathStorer
    implements ConfigurationStorer {
        private final Path path;
        private final Charset charset;

        PathStorer(Path path, Charset charset) {
            this.path = path;
            this.charset = charset;
        }

        @Override
        public void storeConfiguration(String configurationData) {
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(this.path, new OpenOption[0]), this.charset);){
                writer.write(configurationData);
                writer.flush();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static class UrlStorer
    implements ConfigurationStorer {
        private final URL url;
        private final Charset charset;

        UrlStorer(URL url, Charset charset) {
            this.url = url;
            this.charset = charset;
        }

        @Override
        public void storeConfiguration(String configurationData) {
            try {
                URLConnection urlConnection = this.url.openConnection();
                urlConnection.setDoOutput(true);
                try (OutputStreamWriter writer = new OutputStreamWriter(urlConnection.getOutputStream(), this.charset);){
                    writer.write(configurationData);
                    writer.flush();
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static class OutputStreamStorer
    implements ConfigurationStorer {
        private final OutputStream outputStream;
        private final Charset charset;

        OutputStreamStorer(OutputStream outputStream, Charset charset) {
            this.outputStream = outputStream;
            this.charset = charset;
        }

        @Override
        public void storeConfiguration(String configurationData) {
            try (OutputStreamWriter writer = new OutputStreamWriter(this.outputStream, this.charset);){
                writer.write(configurationData);
                writer.flush();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static interface Defaults {
        public static Charset defaultCharset() {
            return StandardCharsets.UTF_8;
        }
    }
}

