/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.configuration.types.Configuration;
import org.eclipse.serializer.configuration.types.ConfigurationMapper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public interface ConfigurationMapperXml
extends ConfigurationMapper<Element> {
    public static ConfigurationMapperXml New() {
        return new Default();
    }

    public static class Default
    implements ConfigurationMapperXml {
        Default() {
        }

        @Override
        public Configuration.Builder mapConfiguration(Configuration.Builder builder, Element source) {
            if (this.isFlatLayout(source)) {
                this.mapFlat(builder, source);
            } else {
                this.mapDeep(builder, source, "");
            }
            return builder;
        }

        private boolean isFlatLayout(Element source) {
            if (!source.getTagName().equalsIgnoreCase("properties")) {
                return false;
            }
            NodeList childNodes = source.getChildNodes();
            int c = childNodes.getLength();
            for (int i = 0; i < c; ++i) {
                Element element;
                Node node = childNodes.item(i);
                if (!(node instanceof Element) || (element = (Element)node).getTagName().equalsIgnoreCase("property")) continue;
                return false;
            }
            return true;
        }

        private void mapFlat(Configuration.Builder builder, Element source) {
            NodeList propertyNodes = source.getElementsByTagName("property");
            int c = propertyNodes.getLength();
            for (int i = 0; i < c; ++i) {
                Element propertyElement = (Element)propertyNodes.item(i);
                String name = (String)XChars.notEmpty((CharSequence)propertyElement.getAttribute("name").trim());
                String value = (String)XChars.notEmpty((CharSequence)propertyElement.getAttribute("value").trim());
                builder.set(name, value);
            }
        }

        private void mapDeep(Configuration.Builder builder, Element documentElement, String prefix) {
            NodeList childNodes = documentElement.getChildNodes();
            int c = childNodes.getLength();
            for (int i = 0; i < c; ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                String tagName = element.getTagName();
                String key = prefix.concat(tagName);
                String value = this.getTextValue(element);
                if (value != null) {
                    builder.set(key, value);
                }
                this.mapDeep(builder, element, key + ".");
            }
        }

        private String getTextValue(Element element) {
            NodeList childNodes = element.getChildNodes();
            int c = childNodes.getLength();
            for (int i = 0; i < c; ++i) {
                String text;
                Node node = childNodes.item(i);
                if (!(node instanceof Text) || XChars.isEmpty((CharSequence)(text = node.getTextContent().trim()))) continue;
                return text;
            }
            return null;
        }
    }
}

