/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.configuration.types.Configuration;
import org.eclipse.serializer.util.X;

public interface ConfigurationBasedCreator<T> {
    public Class<T> resultType();

    public String key();

    public T create(Configuration var1);

    public static <T> List<ConfigurationBasedCreator<T>> registeredCreators(Class<T> resultType) {
        return StreamSupport.stream(ServiceLoader.load(ConfigurationBasedCreator.class).spliterator(), false).filter(creator -> resultType.isAssignableFrom(creator.resultType())).map(c -> c).collect(Collectors.toList());
    }

    public static abstract class Abstract<T>
    implements ConfigurationBasedCreator<T> {
        private final Class<T> resultType;
        private final String key;

        protected Abstract(Class<T> resultType, String key) {
            this.resultType = (Class)X.notNull(resultType);
            this.key = (String)XChars.notEmpty((CharSequence)key);
        }

        @Override
        public Class<T> resultType() {
            return this.resultType;
        }

        @Override
        public String key() {
            return this.key;
        }
    }
}

