/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public enum ByteUnit {
    B(1, 1, "b", "byte", "bytes"),
    KB(1000, 1, "k", "kb", "kilo", "kilobyte", "kilobytes"),
    MB(1000, 2, "m", "mb", "mega", "megabyte", "megabytes"),
    GB(1000, 3, "g", "gb", "giga", "gigabyte", "gigabytes"),
    TB(1000, 4, "t", "tb", "tera", "terabyte", "terabytes"),
    PB(1000, 5, "p", "pb", "peta", "petabyte", "petabytes"),
    EB(1000, 6, "e", "eb", "exa", "exabyte", "exabytes"),
    ZB(1000, 7, "z", "zb", "zetta", "zettabyte", "zettabytes"),
    YB(1000, 8, "y", "yb", "yotta", "yottabyte", "yottabytes"),
    KiB(1024, 1, "ki", "kib", "kibi", "kibibyte", "kibibytes"),
    MiB(1024, 2, "mi", "mib", "mebi", "mebibyte", "mebibytes"),
    GiB(1024, 3, "gi", "gib", "gibi", "gibibyte", "gibibytes"),
    TiB(1024, 4, "ti", "tib", "tebi", "tebibyte", "tebibytes"),
    PiB(1024, 5, "pi", "pib", "pebi", "pebibyte", "pebibytes"),
    EiB(1024, 6, "ei", "eib", "exbi", "exbibyte", "exbibytes"),
    ZiB(1024, 7, "zi", "zib", "zebi", "zebibyte", "zebibytes"),
    YiB(1024, 8, "yi", "yib", "yobi", "yobibyte", "yobibytes");

    private static final Map<String, ByteUnit> nameToUnit;
    private final BigDecimal factor;
    private final String[] names;

    public static ByteUnit ofName(String name) {
        return nameToUnit.get(name.toLowerCase());
    }

    public static Conversion convert(double sourceValue, ByteUnit sourceUnit) {
        return targetUnit -> BigDecimal.valueOf(sourceUnit.toBytes(sourceValue)).divide(targetUnit.factor).doubleValue();
    }

    private ByteUnit(int base, int exponent, String ... names) {
        this.factor = BigDecimal.valueOf(base).pow(exponent);
        this.names = names;
    }

    public long toBytes(double value) {
        return BigDecimal.valueOf(value).multiply(this.factor).longValue();
    }

    static {
        nameToUnit = new HashMap<String, ByteUnit>();
        for (ByteUnit sizeUnit : ByteUnit.values()) {
            for (String name : sizeUnit.names) {
                nameToUnit.put(name, sizeUnit);
            }
        }
    }

    @FunctionalInterface
    public static interface Conversion {
        public double to(ByteUnit var1);
    }
}

