/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.include.sax;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.xml.include.CircularIncludeException;
import scala.xml.include.UnavailableResourceException;
import scala.xml.include.sax.EncodingHeuristics$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XIncludeFilter
extends XMLFilterImpl
implements ScalaObject {
    private boolean atRoot = false;
    private int depth = 0;
    private int level = 0;
    private final Stack<Locator> locators;
    private final Stack<URL> bases = new Stack();
    private final String XINCLUDE_NAMESPACE;

    public XIncludeFilter() {
        this.locators = new Stack();
    }

    /*
     * Unable to fully structure code
     */
    private void includeXMLDocument(String url) {
        try {
            base = this.bases().peek();
            source = new URL(base, url);
        }
        catch (MalformedURLException var3_5) {
            ex = new UnavailableResourceException(new StringBuilder().append((Object)"Unresolvable URL ").append((Object)url).append((Object)this.getLocation()).toString());
            ex.setRootCause(var3_5);
            throw new SAXException(new StringBuilder().append((Object)"Unresolvable URL ").append((Object)url).append((Object)this.getLocation()).toString(), ex);
        }
        parser = null;
        try {
            parser = XMLReaderFactory.createXMLReader();
            ** GOTO lbl21
        }
        catch (SAXException v0) {
            try {
                try {
                    parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                }
                catch (SAXException v1) {
                    System.err.println("Could not find an XML parser");
                }
                if (parser != null && !parser.equals(null)) {
                    parser.setContentHandler(this);
                    resolver = this.getEntityResolver();
                    if (resolver != null && !resolver.equals(null)) {
                        parser.setEntityResolver(resolver);
                    }
                    previousLevel = this.level();
                    this.level_$eq(0);
                    if (this.bases().contains(source)) {
                        e = new CircularIncludeException(new StringBuilder().append((Object)"Circular XInclude Reference to ").append(source).append((Object)this.getLocation()).toString());
                        throw new SAXException("Circular XInclude Reference", e);
                    }
                    this.bases().push(source);
                    this.atRoot_$eq(true);
                    parser.parse(source.toExternalForm());
                    this.level_$eq(previousLevel);
                    this.bases().pop();
                }
                return;
            }
            catch (IOException var10_10) {
                throw new SAXException(new StringBuilder().append((Object)"Document not found: ").append((Object)source.toExternalForm()).append((Object)this.getLocation()).toString(), var10_10);
            }
        }
    }

    private void atRoot_$eq(boolean bl) {
        this.atRoot = bl;
    }

    private boolean atRoot() {
        return this.atRoot;
    }

    /*
     * Loose catch block
     */
    private void includeTextDocument(String url, String encoding1) {
        int charsRead;
        String encoding = encoding1;
        if (encoding1 == null || encoding1.equals(null) || encoding1.trim().equals("")) {
            encoding = "UTF-8";
        }
        URL base = this.bases().peek();
        URL source = new URL(base, url);
        URLConnection uc = source.openConnection();
        BufferedInputStream in = new BufferedInputStream(uc.getInputStream());
        String encodingFromHeader = uc.getContentEncoding();
        String contentType = uc.getContentType();
        if (encodingFromHeader == null || encodingFromHeader.equals(null)) {
            if (contentType != null && !contentType.equals(null) && ((contentType = contentType.toLowerCase()).equals("text/xml") || contentType.equals("application/xml") || contentType.startsWith("text/") && contentType.endsWith("+xml") || contentType.startsWith("application/") && contentType.endsWith("+xml"))) {
                encoding = EncodingHeuristics$.MODULE$.readEncodingFromStream(in);
            }
        } else {
            encoding = encodingFromHeader;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)in, encoding);
        char[] c = new char[1024];
        do {
            if ((charsRead = reader.read(c, 0, 1024)) <= 0) continue;
            this.characters(c, 0, charsRead);
        } while (charsRead != -1);
        return;
        catch (MalformedURLException malformedURLException) {
            UnavailableResourceException ex = new UnavailableResourceException(new StringBuilder().append((Object)"Unresolvable URL ").append((Object)url).append((Object)this.getLocation()).toString());
            ex.setRootCause(malformedURLException);
            throw new SAXException(new StringBuilder().append((Object)"Unresolvable URL ").append((Object)url).append((Object)this.getLocation()).toString(), ex);
        }
        catch (IOException iOException) {
            throw new SAXException(new StringBuilder().append((Object)"Document not found: ").append((Object)source.toExternalForm()).append((Object)this.getLocation()).toString(), iOException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SAXException(new StringBuilder().append((Object)"Unsupported encoding: ").append((Object)encoding).append((Object)this.getLocation()).toString(), unsupportedEncodingException);
        }
    }

    private String getLocation() {
        Locator locator = this.locators().peek();
        String publicID = "";
        String systemID = "";
        int column = -1;
        int line = -1;
        if (locator != null && !locator.equals(null)) {
            publicID = locator.getPublicId();
            systemID = locator.getSystemId();
            line = locator.getLineNumber();
            column = locator.getColumnNumber();
        }
        String locationString = new StringBuilder().append((Object)" in document included from ").append((Object)publicID).append((Object)" at ").append((Object)systemID).append((Object)" at line ").append(BoxesRunTime.boxToInteger(line)).append((Object)", column ").append(BoxesRunTime.boxToInteger(column)).toString();
        return locationString;
    }

    @Override
    public void skippedEntity(String name) {
        if (this.level() == 0) {
            super.skippedEntity(name);
        }
    }

    @Override
    public void processingInstruction(String target, String data2) {
        if (this.level() == 0) {
            super.processingInstruction(target, data2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.level() == 0) {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.level() == 0) {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        if (this.level() == 0) {
            super.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.level() == 0) {
            super.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endDocument() {
        this.locators().pop();
        this.bases().pop();
        this.depth_$eq(this.depth() - 1);
        if (this.depth() == 0) {
            super.endDocument();
        }
    }

    @Override
    public void startDocument() {
        this.level_$eq(0);
        if (this.depth() == 0) {
            super.startDocument();
        }
        this.depth_$eq(this.depth() + 1);
    }

    private void depth_$eq(int n) {
        this.depth = n;
    }

    private int depth() {
        return this.depth;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (uri.equals("http://www.w3.org/2001/XInclude") && localName.equals("include")) {
            this.level_$eq(this.level() - 1);
        } else if (this.level() == 0) {
            this.bases().pop();
            super.endElement(uri, localName, qName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts1) {
        URL parentBase;
        Attributes atts = atts1;
        if (this.level() != 0) return;
        String base = atts1.getValue("http://www.w3.org/XML/1998/namespace", "base");
        URL currentBase = parentBase = this.bases().peek();
        if (base != null && !base.equals(null)) {
            try {
                currentBase = new URL(parentBase, base);
            }
            catch (MalformedURLException malformedURLException) {
                throw new SAXException(new StringBuilder().append((Object)"Malformed base URL: ").append(currentBase).toString(), malformedURLException);
            }
        }
        this.bases().push(currentBase);
        if (uri.equals("http://www.w3.org/2001/XInclude") && localName.equals("include")) {
            String href = atts1.getValue("href");
            if (href == null) throw new SAXException("Missing href attribute");
            if (href.equals(null)) {
                throw new SAXException("Missing href attribute");
            }
            String parse = atts1.getValue("parse");
            if (parse == null || parse.equals(null)) {
                parse = "xml";
            }
            if (parse.equals("text")) {
                String encoding = atts1.getValue("encoding");
                this.includeTextDocument(href, encoding);
            } else {
                if (!parse.equals("xml")) throw new SAXException(new StringBuilder().append((Object)"Illegal value for parse attribute: ").append((Object)parse).toString());
                this.includeXMLDocument(href);
            }
            this.level_$eq(this.level() + 1);
            return;
        }
        if (this.atRoot()) {
            AttributesImpl attsImpl = new AttributesImpl(atts1);
            attsImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "base", "xml:base", "CDATA", currentBase.toExternalForm());
            atts = attsImpl;
            this.atRoot_$eq(false);
        }
        super.startElement(uri, localName, qName, atts);
    }

    public boolean insideIncludeElement() {
        return this.level() != 0;
    }

    private void level_$eq(int n) {
        this.level = n;
    }

    private int level() {
        return this.level;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locators().push(locator);
        String base = locator.getSystemId();
        try {
            this.bases().push(new URL(base));
            super.setDocumentLocator(locator);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnsupportedOperationException(new StringBuilder().append((Object)"Unrecognized SYSTEM ID: ").append((Object)base).toString());
        }
    }

    private Stack<Locator> locators() {
        return this.locators;
    }

    private Stack<URL> bases() {
        return this.bases;
    }

    public final String XINCLUDE_NAMESPACE() {
        return "http://www.w3.org/2001/XInclude";
    }
}

