/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import scala.ScalaObject;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.Fractional;
import scala.math.Integral;
import scala.math.Ordering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Numeric<T>
extends Ordering<T>,
ScalaObject {
    public Ops mkNumericOps(T var1);

    public int signum(T var1);

    public T abs(T var1);

    public T one();

    public T zero();

    public double toDouble(T var1);

    public float toFloat(T var1);

    public long toLong(T var1);

    public int toInt(T var1);

    public T fromInt(int var1);

    public T negate(T var1);

    public T times(T var1, T var2);

    public T minus(T var1, T var2);

    public T plus(T var1, T var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Ops
    implements ScalaObject {
        public final /* synthetic */ Numeric $outer;
        private final T lhs;

        public Ops(Numeric<T> $outer, T lhs) {
            this.lhs = lhs;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public /* synthetic */ Numeric scala$math$Numeric$Ops$$$outer() {
            return this.$outer;
        }

        public double toDouble() {
            return this.scala$math$Numeric$Ops$$$outer().toDouble(this.lhs);
        }

        public float toFloat() {
            return this.scala$math$Numeric$Ops$$$outer().toFloat(this.lhs);
        }

        public long toLong() {
            return this.scala$math$Numeric$Ops$$$outer().toLong(this.lhs);
        }

        public int toInt() {
            return this.scala$math$Numeric$Ops$$$outer().toInt(this.lhs);
        }

        public int signum() {
            return this.scala$math$Numeric$Ops$$$outer().signum(this.lhs);
        }

        public T abs() {
            return this.scala$math$Numeric$Ops$$$outer().abs(this.lhs);
        }

        public T unary_$minus() {
            return this.scala$math$Numeric$Ops$$$outer().negate(this.lhs);
        }

        public T $times(T rhs) {
            return this.scala$math$Numeric$Ops$$$outer().times(this.lhs, rhs);
        }

        public T $minus(T rhs) {
            return this.scala$math$Numeric$Ops$$$outer().minus(this.lhs, rhs);
        }

        public T $plus(T rhs) {
            return this.scala$math$Numeric$Ops$$$outer().plus(this.lhs, rhs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IntIsIntegral
    extends Integral<Integer>,
    ScalaObject {
        @Override
        public double toDouble(int var1);

        @Override
        public float toFloat(int var1);

        @Override
        public long toLong(int var1);

        @Override
        public int toInt(int var1);

        @Override
        public int fromInt(int var1);

        @Override
        public int negate(int var1);

        @Override
        public int rem(int var1, int var2);

        @Override
        public int quot(int var1, int var2);

        @Override
        public int times(int var1, int var2);

        @Override
        public int minus(int var1, int var2);

        @Override
        public int plus(int var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LongIsIntegral
    extends Integral<Long>,
    ScalaObject {
        @Override
        public double toDouble(long var1);

        @Override
        public float toFloat(long var1);

        @Override
        public long toLong(long var1);

        @Override
        public int toInt(long var1);

        @Override
        public long fromInt(int var1);

        @Override
        public long negate(long var1);

        @Override
        public long rem(long var1, long var3);

        @Override
        public long quot(long var1, long var3);

        @Override
        public long times(long var1, long var3);

        @Override
        public long minus(long var1, long var3);

        @Override
        public long plus(long var1, long var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ByteIsIntegral
    extends Integral<Byte>,
    ScalaObject {
        @Override
        public double toDouble(byte var1);

        @Override
        public float toFloat(byte var1);

        @Override
        public long toLong(byte var1);

        @Override
        public int toInt(byte var1);

        @Override
        public byte fromInt(int var1);

        @Override
        public byte negate(byte var1);

        @Override
        public byte rem(byte var1, byte var2);

        @Override
        public byte quot(byte var1, byte var2);

        @Override
        public byte times(byte var1, byte var2);

        @Override
        public byte minus(byte var1, byte var2);

        @Override
        public byte plus(byte var1, byte var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ShortIsIntegral
    extends Integral<Short>,
    ScalaObject {
        @Override
        public double toDouble(short var1);

        @Override
        public float toFloat(short var1);

        @Override
        public long toLong(short var1);

        @Override
        public int toInt(short var1);

        @Override
        public short fromInt(int var1);

        @Override
        public short negate(short var1);

        @Override
        public short rem(short var1, short var2);

        @Override
        public short quot(short var1, short var2);

        @Override
        public short times(short var1, short var2);

        @Override
        public short minus(short var1, short var2);

        @Override
        public short plus(short var1, short var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BigIntIsIntegral
    extends Integral<BigInt>,
    ScalaObject {
        @Override
        public double toDouble(BigInt var1);

        @Override
        public float toFloat(BigInt var1);

        @Override
        public long toLong(BigInt var1);

        @Override
        public int toInt(BigInt var1);

        @Override
        public BigInt fromInt(int var1);

        @Override
        public BigInt negate(BigInt var1);

        @Override
        public BigInt rem(BigInt var1, BigInt var2);

        @Override
        public BigInt quot(BigInt var1, BigInt var2);

        @Override
        public BigInt times(BigInt var1, BigInt var2);

        @Override
        public BigInt minus(BigInt var1, BigInt var2);

        @Override
        public BigInt plus(BigInt var1, BigInt var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FloatIsFractional
    extends Fractional<Float>,
    ScalaObject {
        @Override
        public double toDouble(float var1);

        @Override
        public float toFloat(float var1);

        @Override
        public long toLong(float var1);

        @Override
        public int toInt(float var1);

        @Override
        public float fromInt(int var1);

        @Override
        public float negate(float var1);

        @Override
        public float div(float var1, float var2);

        @Override
        public float times(float var1, float var2);

        @Override
        public float minus(float var1, float var2);

        @Override
        public float plus(float var1, float var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoubleAsIfIntegral
    extends DoubleIsConflicted,
    Integral<Double>,
    ScalaObject {
        @Override
        public double rem(double var1, double var3);

        @Override
        public double quot(double var1, double var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoubleIsFractional
    extends DoubleIsConflicted,
    Fractional<Double>,
    ScalaObject {
        @Override
        public double div(double var1, double var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoubleIsConflicted
    extends Numeric<Double>,
    ScalaObject {
        @Override
        public double toDouble(double var1);

        @Override
        public float toFloat(double var1);

        @Override
        public long toLong(double var1);

        @Override
        public int toInt(double var1);

        @Override
        public double fromInt(int var1);

        @Override
        public double negate(double var1);

        @Override
        public double times(double var1, double var3);

        @Override
        public double minus(double var1, double var3);

        @Override
        public double plus(double var1, double var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BigDecimalAsIfIntegral
    extends BigDecimalIsConflicted,
    Integral<BigDecimal>,
    ScalaObject {
        @Override
        public BigDecimal rem(BigDecimal var1, BigDecimal var2);

        @Override
        public BigDecimal quot(BigDecimal var1, BigDecimal var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BigDecimalIsFractional
    extends BigDecimalIsConflicted,
    Fractional<BigDecimal>,
    ScalaObject {
        @Override
        public BigDecimal div(BigDecimal var1, BigDecimal var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BigDecimalIsConflicted
    extends Numeric<BigDecimal>,
    ScalaObject {
        @Override
        public double toDouble(BigDecimal var1);

        @Override
        public float toFloat(BigDecimal var1);

        @Override
        public long toLong(BigDecimal var1);

        @Override
        public int toInt(BigDecimal var1);

        @Override
        public BigDecimal fromInt(int var1);

        @Override
        public BigDecimal negate(BigDecimal var1);

        @Override
        public BigDecimal times(BigDecimal var1, BigDecimal var2);

        @Override
        public BigDecimal minus(BigDecimal var1, BigDecimal var2);

        @Override
        public BigDecimal plus(BigDecimal var1, BigDecimal var2);
    }
}

