/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.solr;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lucene.AbstractSearchIndex;
import org.eclipse.rdf4j.sail.lucene.BulkUpdater;
import org.eclipse.rdf4j.sail.lucene.DocumentDistance;
import org.eclipse.rdf4j.sail.lucene.DocumentResult;
import org.eclipse.rdf4j.sail.lucene.DocumentScore;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.eclipse.rdf4j.sail.lucene.SearchQuery;
import org.eclipse.rdf4j.sail.lucene.util.GeoUnits;
import org.eclipse.rdf4j.sail.solr.SolrBulkUpdater;
import org.eclipse.rdf4j.sail.solr.SolrClientFactory;
import org.eclipse.rdf4j.sail.solr.SolrDocumentDistance;
import org.eclipse.rdf4j.sail.solr.SolrDocumentResult;
import org.eclipse.rdf4j.sail.solr.SolrDocumentScore;
import org.eclipse.rdf4j.sail.solr.SolrSearchDocument;
import org.eclipse.rdf4j.sail.solr.SolrSearchQuery;
import org.eclipse.rdf4j.sail.solr.SolrUtil;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndex
extends AbstractSearchIndex {
    public static final String SERVER_KEY = "server";
    public static final String DISTANCE_FIELD = "_dist";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SolrClient client;
    private Function<? super String, ? extends SpatialContext> geoContextMapper;

    @Override
    public void initialize(Properties parameters) throws Exception {
        super.initialize(parameters);
        this.geoContextMapper = this.createSpatialContextMapper(parameters);
        String server = parameters.getProperty(SERVER_KEY);
        if (server == null) {
            throw new SailException("Missing server parameter");
        }
        int pos = server.indexOf(58);
        if (pos == -1) {
            throw new SailException("Missing scheme in server parameter: " + server);
        }
        String scheme = server.substring(0, pos);
        Class<?> clientFactoryCls = Class.forName("org.eclipse.rdf4j.sail.solr.client." + scheme + ".Factory");
        SolrClientFactory clientFactory = (SolrClientFactory)clientFactoryCls.newInstance();
        this.client = clientFactory.create(server);
    }

    protected Function<? super String, ? extends SpatialContext> createSpatialContextMapper(Map<String, String> parameters) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        SpatialContext geoContext = SpatialContextFactory.makeSpatialContext(parameters, (ClassLoader)classLoader);
        return Functions.constant((Object)geoContext);
    }

    public SolrClient getClient() {
        return this.client;
    }

    @Override
    protected SpatialContext getSpatialContext(String property) {
        return (SpatialContext)this.geoContextMapper.apply((Object)property);
    }

    @Override
    public void shutDown() throws IOException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    @Override
    protected SearchDocument getDocument(String id) throws IOException {
        SolrDocument doc;
        try {
            doc = (SolrDocument)this.client.query((SolrParams)new SolrQuery().setRequestHandler("/get").set("id", new String[]{id})).getResponse().get("doc");
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
        return doc != null ? new SolrSearchDocument(doc) : null;
    }

    @Override
    protected Iterable<? extends SearchDocument> getDocuments(String resourceId) throws IOException {
        SolrDocumentList docs;
        SolrQuery query = new SolrQuery(SolrIndex.termQuery("uri", resourceId));
        try {
            docs = this.getDocuments(query);
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
        return Iterables.transform((Iterable)docs, (Function)new Function<SolrDocument, SearchDocument>(){

            public SearchDocument apply(SolrDocument hit) {
                return new SolrSearchDocument(hit);
            }
        });
    }

    @Override
    protected SearchDocument newDocument(String id, String resourceId, String context) {
        return new SolrSearchDocument(id, resourceId, context);
    }

    @Override
    protected SearchDocument copyDocument(SearchDocument doc) {
        SolrDocument document = ((SolrSearchDocument)doc).getDocument();
        SolrDocument newDocument = new SolrDocument();
        newDocument.putAll((Map)document);
        return new SolrSearchDocument(newDocument);
    }

    @Override
    protected void addDocument(SearchDocument doc) throws IOException {
        SolrDocument document = ((SolrSearchDocument)doc).getDocument();
        try {
            this.client.add(SolrUtil.toSolrInputDocument(document));
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void updateDocument(SearchDocument doc) throws IOException {
        this.addDocument(doc);
    }

    @Override
    protected void deleteDocument(SearchDocument doc) throws IOException {
        try {
            this.client.deleteById(doc.getId());
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected BulkUpdater newBulkUpdate() {
        return new SolrBulkUpdater(this.client);
    }

    static String termQuery(String field, String value) {
        return field + ":\"" + value + "\"";
    }

    private SolrDocumentList getDocuments(SolrQuery query) throws SolrServerException, IOException {
        return this.search(query).getResults();
    }

    public SearchDocument getDocument(Resource subject, Resource context) throws IOException {
        String resourceId = SearchFields.getResourceID(subject);
        String contextId = SearchFields.getContextID(context);
        return this.getDocument(SearchFields.formIdString(resourceId, contextId));
    }

    public Iterable<? extends SearchDocument> getDocuments(Resource subject) throws IOException {
        String resourceId = SearchFields.getResourceID(subject);
        return this.getDocuments(resourceId);
    }

    public static Set<String> getPropertyFields(Set<String> fields) {
        HashSet<String> result = new HashSet<String>(fields.size());
        for (String field : fields) {
            if (!SearchFields.isPropertyField(field)) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public void begin() throws IOException {
    }

    @Override
    public void commit() throws IOException {
        try {
            this.client.commit();
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void rollback() throws IOException {
        try {
            this.client.rollback();
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void beginReading() throws IOException {
    }

    @Override
    public void endReading() throws IOException {
    }

    @Override
    @Deprecated
    protected SearchQuery parseQuery(String query, IRI propertyURI) throws MalformedQueryException {
        SolrQuery q = this.prepareQuery(propertyURI, new SolrQuery(query));
        return new SolrSearchQuery(q, this);
    }

    @Override
    protected Iterable<? extends DocumentScore> query(Resource subject, String query, IRI propertyURI, boolean highlight) throws MalformedQueryException, IOException {
        QueryResponse response;
        SolrQuery q = this.prepareQuery(propertyURI, new SolrQuery(query));
        if (highlight) {
            q.setHighlight(true);
            String field = propertyURI != null ? SearchFields.getPropertyField(propertyURI) : "*";
            q.addHighlightField(field);
            q.setHighlightSimplePre("<B>");
            q.setHighlightSimplePost("</B>");
            q.setHighlightSnippets(2);
        }
        if (q.getHighlight()) {
            q.addField("*");
        } else {
            q.addField("uri");
        }
        q.addField("score");
        try {
            response = subject != null ? this.search(subject, q) : this.search(q);
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
        SolrDocumentList results = response.getResults();
        final Map highlighting = response.getHighlighting();
        return Iterables.transform((Iterable)results, (Function)new Function<SolrDocument, DocumentScore>(){

            public DocumentScore apply(SolrDocument document) {
                SolrSearchDocument doc = new SolrSearchDocument(document);
                Map docHighlighting = highlighting != null ? (Map)highlighting.get(doc.getId()) : null;
                return new SolrDocumentScore(doc, docHighlighting);
            }
        });
    }

    public QueryResponse search(Resource resource, SolrQuery query) throws SolrServerException, IOException {
        String idQuery = SolrIndex.termQuery("uri", SearchFields.getResourceID(resource));
        query.setQuery(query.getQuery() + " AND " + idQuery);
        return this.search(query);
    }

    @Override
    protected Iterable<? extends DocumentDistance> geoQuery(IRI geoProperty, Point p, final IRI units, double distance, String distanceVar, Var contextVar) throws MalformedQueryException, IOException {
        QueryResponse response;
        boolean requireContext;
        double kms = GeoUnits.toKilometres(distance, units);
        String qstr = "{!geofilt score=recipDistance}";
        if (contextVar != null) {
            Resource ctx = (Resource)contextVar.getValue();
            String tq = SolrIndex.termQuery("context", SearchFields.getContextID(ctx));
            qstr = ctx != null ? tq + " AND " + qstr : "-" + tq + " AND " + qstr;
        }
        SolrQuery q = new SolrQuery(qstr);
        q.set("sfield", new String[]{SearchFields.getPropertyField(geoProperty)});
        q.set("pt", new String[]{p.getY() + "," + p.getX()});
        q.set("d", new String[]{Double.toString(kms)});
        q.addField("uri");
        q.addField("*" + geoProperty.getLocalName());
        q.addField("_dist:geodist()");
        boolean bl = requireContext = contextVar != null && !contextVar.hasValue();
        if (requireContext) {
            q.addField("context");
        }
        try {
            response = this.search(q);
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
        SolrDocumentList results = response.getResults();
        return Iterables.transform((Iterable)results, (Function)new Function<SolrDocument, DocumentDistance>(){

            public DocumentDistance apply(SolrDocument document) {
                SolrSearchDocument doc = new SolrSearchDocument(document);
                return new SolrDocumentDistance(doc, units);
            }
        });
    }

    @Override
    protected Iterable<? extends DocumentResult> geoRelationQuery(String relation, IRI geoProperty, Shape shape, Var contextVar) throws MalformedQueryException, IOException {
        QueryResponse response;
        boolean requireContext;
        String spatialOp = this.toSpatialOp(relation);
        if (spatialOp == null) {
            return null;
        }
        String wkt = this.toWkt(shape);
        String qstr = "\"" + spatialOp + "(" + wkt + ")\"";
        if (contextVar != null) {
            Resource ctx = (Resource)contextVar.getValue();
            String tq = SolrIndex.termQuery("context", SearchFields.getContextID(ctx));
            qstr = ctx != null ? tq + " AND " + qstr : "-" + tq + " AND " + qstr;
        }
        SolrQuery q = new SolrQuery(qstr);
        q.set("df", new String[]{SearchFields.getPropertyField(geoProperty)});
        q.addField("uri");
        q.addField("*" + geoProperty.getLocalName());
        boolean bl = requireContext = contextVar != null && !contextVar.hasValue();
        if (requireContext) {
            q.addField("context");
        }
        try {
            response = this.search(q);
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
        SolrDocumentList results = response.getResults();
        return Iterables.transform((Iterable)results, (Function)new Function<SolrDocument, DocumentResult>(){

            public DocumentResult apply(SolrDocument document) {
                SolrSearchDocument doc = new SolrSearchDocument(document);
                return new SolrDocumentResult(doc);
            }
        });
    }

    private String toSpatialOp(String relation) {
        if (GEOF.SF_INTERSECTS.stringValue().equals(relation)) {
            return "Intersects";
        }
        if (GEOF.SF_DISJOINT.stringValue().equals(relation)) {
            return "IsDisjointTo";
        }
        if (GEOF.EH_COVERED_BY.stringValue().equals(relation)) {
            return "IsWithin";
        }
        return null;
    }

    @Override
    protected Shape parseQueryShape(String property, String value) throws ParseException {
        Shape s = super.parseQueryShape(property, value);
        return s instanceof Point ? new WktPoint((Point)s, value) : new WktShape<Shape>(s, value);
    }

    protected String toWkt(Shape s) {
        return ((WktShape)s).wkt;
    }

    public QueryResponse search(SolrQuery query) throws SolrServerException, IOException {
        int nDocs;
        if (this.maxDocs > 0) {
            nDocs = this.maxDocs;
        } else {
            long docCount = this.client.query((SolrParams)query.setRows(Integer.valueOf(0))).getResults().getNumFound();
            nDocs = Math.max((int)Math.min(docCount, Integer.MAX_VALUE), 1);
        }
        return this.client.query((SolrParams)query.setRows(Integer.valueOf(nDocs)));
    }

    private SolrQuery prepareQuery(IRI propertyURI, SolrQuery query) {
        if (propertyURI == null) {
            query.set("df", new String[]{"text"});
        } else {
            query.set("df", new String[]{SearchFields.getPropertyField(propertyURI)});
        }
        return query;
    }

    @Override
    public synchronized void clearContexts(Resource ... contexts) throws IOException {
        this.logger.debug("deleting contexts: {}", (Object)Arrays.toString(contexts));
        try {
            for (Resource context : contexts) {
                String contextString = SearchFields.getContextID(context);
                this.client.deleteByQuery(SolrIndex.termQuery("context", contextString));
            }
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void clear() throws IOException {
        try {
            this.client.deleteByQuery("*:*");
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    private static class WktPoint
    extends WktShape<Point>
    implements Point {
        WktPoint(Point p, String wkt) {
            super(p, wkt);
        }

        public void reset(double x, double y) {
            ((Point)this.s).reset(x, y);
        }

        public double getX() {
            return ((Point)this.s).getX();
        }

        public double getY() {
            return ((Point)this.s).getY();
        }
    }

    private static class WktShape<S extends Shape>
    implements Shape {
        final S s;
        final String wkt;

        WktShape(S s, String wkt) {
            this.s = s;
            this.wkt = wkt;
        }

        public SpatialRelation relate(Shape other) {
            return this.s.relate(other);
        }

        public Rectangle getBoundingBox() {
            return this.s.getBoundingBox();
        }

        public boolean hasArea() {
            return this.s.hasArea();
        }

        public double getArea(SpatialContext ctx) {
            return this.s.getArea(ctx);
        }

        public Point getCenter() {
            return this.s.getCenter();
        }

        public Shape getBuffered(double distance, SpatialContext ctx) {
            return this.s.getBuffered(distance, ctx);
        }

        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        public boolean equals(Object other) {
            return this.s.equals(other);
        }

        public SpatialContext getContext() {
            return this.s.getContext();
        }
    }
}

