/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.config;

import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.sail.base.config.BaseSailConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.nativerdf.config.NativeStoreSchema;

public class NativeStoreConfig
extends BaseSailConfig {
    private String tripleIndexes;
    private boolean forceSync = false;
    private int valueCacheSize = -1;
    private int valueIDCacheSize = -1;
    private int namespaceCacheSize = -1;
    private int namespaceIDCacheSize = -1;

    public NativeStoreConfig() {
        super("openrdf:NativeStore");
    }

    public NativeStoreConfig(String tripleIndexes) {
        this();
        this.setTripleIndexes(tripleIndexes);
    }

    public NativeStoreConfig(String tripleIndexes, boolean forceSync) {
        this(tripleIndexes);
        this.setForceSync(forceSync);
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public void setTripleIndexes(String tripleIndexes) {
        this.tripleIndexes = tripleIndexes;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public int getValueCacheSize() {
        return this.valueCacheSize;
    }

    public void setValueCacheSize(int valueCacheSize) {
        this.valueCacheSize = valueCacheSize;
    }

    public int getValueIDCacheSize() {
        return this.valueIDCacheSize;
    }

    public void setValueIDCacheSize(int valueIDCacheSize) {
        this.valueIDCacheSize = valueIDCacheSize;
    }

    public int getNamespaceCacheSize() {
        return this.namespaceCacheSize;
    }

    public void setNamespaceCacheSize(int namespaceCacheSize) {
        this.namespaceCacheSize = namespaceCacheSize;
    }

    public int getNamespaceIDCacheSize() {
        return this.namespaceIDCacheSize;
    }

    public void setNamespaceIDCacheSize(int namespaceIDCacheSize) {
        this.namespaceIDCacheSize = namespaceIDCacheSize;
    }

    @Override
    public Resource export(Model m) {
        Resource implNode = super.export(m);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        m.setNamespace("ns", "http://www.openrdf.org/config/sail/native#");
        if (this.tripleIndexes != null) {
            m.add(implNode, NativeStoreSchema.TRIPLE_INDEXES, (Value)vf.createLiteral(this.tripleIndexes), new Resource[0]);
        }
        if (this.forceSync) {
            m.add(implNode, NativeStoreSchema.FORCE_SYNC, (Value)vf.createLiteral(this.forceSync), new Resource[0]);
        }
        if (this.valueCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.VALUE_CACHE_SIZE, (Value)vf.createLiteral(this.valueCacheSize), new Resource[0]);
        }
        if (this.valueIDCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.VALUE_ID_CACHE_SIZE, (Value)vf.createLiteral(this.valueIDCacheSize), new Resource[0]);
        }
        if (this.namespaceCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.NAMESPACE_CACHE_SIZE, (Value)vf.createLiteral(this.namespaceCacheSize), new Resource[0]);
        }
        if (this.namespaceIDCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE, (Value)vf.createLiteral(this.namespaceIDCacheSize), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Models.objectLiteral((Model)m.filter(implNode, NativeStoreSchema.TRIPLE_INDEXES, null, new Resource[0])).ifPresent(lit -> this.setTripleIndexes(lit.getLabel()));
            Models.objectLiteral((Model)m.filter(implNode, NativeStoreSchema.FORCE_SYNC, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setForceSync(lit.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + NativeStoreSchema.FORCE_SYNC + " property, found " + lit);
                }
            });
            Models.objectLiteral((Model)m.filter(implNode, NativeStoreSchema.VALUE_CACHE_SIZE, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setValueCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + NativeStoreSchema.VALUE_CACHE_SIZE + " property, found " + lit);
                }
            });
            Models.objectLiteral((Model)m.filter(implNode, NativeStoreSchema.VALUE_ID_CACHE_SIZE, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setValueIDCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + NativeStoreSchema.VALUE_ID_CACHE_SIZE + " property, found " + lit);
                }
            });
            Models.objectLiteral((Model)m.filter(implNode, NativeStoreSchema.NAMESPACE_CACHE_SIZE, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setNamespaceCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + NativeStoreSchema.NAMESPACE_CACHE_SIZE + " property, found " + lit);
                }
            });
            Models.objectLiteral((Model)m.filter(implNode, NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setNamespaceIDCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE + " property, found " + lit);
                }
            });
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }
}

